
/***************************
**** AMMP - Main header ****
***************************/


#ifndef __AMMP_H
#  define  __AMMP_H
#  include <stdio.h>

#ifdef AMMP_DOUBLE_PRECISION
#  define  float        double
#endif

#  ifdef QUARTIC
#    define  CUBIC
#  endif

#  ifdef QUINTIC
#    define  CUBIC
#    define  QUARTIC
#  endif

#  if defined(SGI) || defined(WIN32)
#    include <sys/types.h>
#    include <stdlib.h>
#  endif

#  ifdef WIN32
#    define  AMMP_FASTCALL              __fastcall
#    ifdef __BORLANDC__
#      define  AMMP_USE_ERF
#    else
#      define  AMMP_USE_DLMALLOC
#    endif
#  else
#    define  AMMP_FASTCALL
#  endif

#  ifdef __GNUC__
#    define  AMMP_INLINE             __inline__
#  else
#    define  AMMP_INLINE             __inline
#  endif

#  ifndef FALSE
#    define  FALSE                      0
#  endif

#  ifndef TRUE
#    define  TRUE                       1
#  endif

#  if defined(VEGAZZ) || defined(GRAMMP)
#    define  AMMP_SENDTOGFX
#  endif

/**** Constants ****/

#  define  AMMP_COPYRIGHT               "1993-2012"
#  define  AMMP_VERSTR                  "2.4.0"
#  define  AMMP_LINEBUF                 4096

#  define  critical_precision           double
#  define  doublefloat                  double
#  define  MAXENT                       201
#  define  MAXTGROUP                    100
#  define  MAXTGSTEP                    24
#  define  NEXCLUDE                     32
#  define  NCLOSE                       200
#  define  NUM_TOT                      7
#  define  NSWARM                       8
#  define  TOKENLENGTH                  80

/**** Endian ****/

#  define  AMMP_LITTLE_ENDIAN           0
#  define  AMMP_BIG_ENDIAN              1

/**** Non-bont table types ****/

#  define AMMP_NBTABLE_NORMAL           0
#  define AMMP_NBTABLE_REACT            1
#  define AMMP_NBTABLE_RECTMM           2
#  define AMMP_NBTABLE_SHADOW           3

/**** Variable types ****/

#  define  AMMP_VAR_TYPE_INTEGER        0       /* Don't change the order */
#  define  AMMP_VAR_TYPE_FLOAT          1

/**** Variable flags ****/

#  define  AMMP_VAR_FLAG_NONE           0
#  define  AMMP_VAR_FLAG_READONLY       1

/**** Torsion group flags ****/

#  define  AMMP_TGPF_NONE               0
#  define  AMMP_TGPF_ACTIVE             1

/**** dlmalloc ****/

#ifdef AMMP_USE_DLMALLOC
#  define  calloc                       dlcalloc
#  define  free                         dlfree
#  define  malloc                       dlmalloc
#  define  realloc                      dlrealloc

void *          dlcalloc(size_t, size_t);
void            dlfree(void *);
void *          dlmalloc(size_t);
void *          dlrealloc(void *, size_t);
#endif

/**** Function types ****/

typedef int (AMMP_FASTCALL *AMMP_FFUNC)(float);
typedef int (AMMP_FASTCALL *AMMP_VFUNC)(float *, float);

/**** Atom ****/

typedef struct __atom {
  struct __atom *       next;
  float                 x, y, z, w;
  critical_precision    fx, fy, fz, fw;
  int                   serial;
  float                 q, a, b, mass;
  float                 na;
  char                  active;
  char                  name[9];
  float                 chi, jaa;
  float                 vx, vy, vz, vw, dx, dy, dz, dw;
  float                 gx, gy, gz, gw;
  float                 VP, px, py, pz, pw, dpx, dpy, dpz, dpw;

  /**** Place holders for interpolation on V ****/

  float                 qxx, qxy, qxz, qyy, qyz, qzz;
  float                 qxw, qyw, qzw, qww;

#ifdef CUBIC
  float                 qxxx, qxxy, qxxz, qxyy, qxyz, qxzz;
  float                 qyyy, qyyz, qyzz, qzzz;
#endif

#ifdef QUARTIC
  float                 qxxxx, qxxxy, qxxxz, qxxyy, qxxyz, qxxzz;
  float                 qxyyy, qxyyz, qxyzz, qxzzz;
  float                 qyyyy, qyyyz, qyyzz, qyzzz, qzzzz;
#endif

#ifdef QUINTIC
  float                 qxxxxx, qxxxxy, qxxxxz, qxxxyy, qxxxyz, qxxxzz;
  float                 qxxyyy, qxxyyz, qxxyzz, qxxzzz;
  float                 qxyyyy, qxyyyz, qxyyzz, qxyzzz, qxzzzz;
  float                 qyyyyy, qyyyyz, qyyyzz, qyyzzz, qyzzzz, qzzzzz;
#endif

  /**** Interpolation on force ****/

  struct __atom **      Close;
  int                   nclose;
  void *                excluded[NEXCLUDE];
  char                  exkind[NEXCLUDE];
  int                   dontuse;
} AMMP_ATOM;

/**** Abc ****/

typedef struct __abc {
  struct __abc *        next;
  AMMP_ATOM             *atom1, *atom2, *atom3;
  float                 theta, thetazero, dr, dk1, dk2;
  void                  *b1, *b2; /* pointers to the bonds for atom1 atom 2 */
} AMMP_ABC;

/**** Generic list ****/

typedef struct __list {
  struct __list *       next;
  struct __list *       prev;
  void *                Data;
} AMMP_LIST;

/**** Multipole method atom ****/

typedef struct {
 AMMP_ATOM *    who;
 int            next, which;
} AMMP_MMATOM;

/**** Multipole method node ****/

typedef struct {
  float         xc, yc, zc;
  float         sqp;
  float         sa, xa, ya, za;
  float         q100, q010, q001;
  float         q200, q020, q002, q110, q101, q011;
  float         q300, q030, q003, q210, q201, q120, q021, q102, q012, q111;
#ifdef FOURTH
  float         q400, q040, q004, q310, q301, q130, q031, q103, q013, q220;
  float         q202, q022, q211, q121, q112;
#endif
#ifdef FIFTH
  float         q500, q050, q005, q410, q401, q140, q041, q104, q014, q320;
  float         q230, q302, q203, q032, q023, q311, q131, q113, q221, q212, q122;
#endif
  int           first, last, innode;
} AMMP_MMNODE;

/**** Angle ****/

typedef struct __angle {
  struct __angle *      next;
  AMMP_ATOM             *atom1, *atom2,* atom3;
  float                 target, k;
} ANGLE;

/**** Av5 ****/

typedef struct __av5 {
  struct __av5 *        next;
  AMMP_ATOM             *atom1, *atom2, *atom3, *atom4, *atom5;
  float                 k, offset;
} AV5;

/**** Bond ****/

typedef struct __bond {
  struct __bond *       next;           /* Pointer to previous list element */
  struct __bond *       prev;           /* Pointer to next list element     */
  AMMP_ATOM *           atom1;          /* Pointer to the first bond atom   */
  AMMP_ATOM *           atom2;          /* Pointer to the second bond atom  */
  float                 k;              /* Force constant                   */
  float                 length;         /* Bond length                      */
  float                 dlength, dk;    /* Abc terms                        */
  int                   ndiff;
  float                 order;          /* Bond order                       */
} BOND;

/**** Clone structure ****/

typedef struct __clone {
  struct __clone *      next;
  struct __clone *      prev;
  int                   inme, serial;
  float                 *x, *y, *z;
  char                  *active_flag;
} CLONE;

/**** Data table ****/

typedef struct __datatable {
  struct __datatable *  next;
  int                   id, inme;
  float                 r[MAXENT], v[MAXENT];
} DATATABLE;

/**** Hybrid angle ****/

typedef struct __hybrid {
  struct __hybrid *     next;
  AMMP_ATOM             *atom1, *atom2, *atom3, *atom4;
  float                 k, offset;
} HYBRID;

/**** Morse potential ****/

typedef struct __morse {
  struct __morse *      next;
  AMMP_ATOM             *atom1, *atom2;
  float                 length, k, order;
} MORSE;

/**** Noel ****/

typedef struct __noel {
  struct __noel *       next;
  AMMP_ATOM             *atom1, *atom2;
  float                 d, dm, dh, km, kh;
  int                   ismet;
} NOEL;

/**** Restrain ****/

typedef struct __restrain {
  struct __restrain *   next;
  AMMP_ATOM             *atom1, *atom2;
  float                 length, k;
} RESTRAIN;

/**** Step ****/

typedef struct __step {
  struct __step *       next;
  AMMP_ATOM             *atom1, *atom2;
  float                 d1, d2, d3, k1, k2, k3;
} STEP;

/**** Swarm bonds ****/

typedef struct __swarm {
  struct __swarm *      next;
  AMMP_ATOM *           atoms[NSWARM];
  float                 k;
  int                   n;
} SWARM;

/**** Bond table ****/

typedef struct __tbond {
  struct __tbond *      next;
  AMMP_ATOM             *a1, *a2;
  DATATABLE *           which;
  float                 scale;
} TBOND;

/**** Thether ****/

typedef struct __tether {
  struct __tether *     next;
  AMMP_ATOM             *atom1;
  float                 k, x, y, z;
} TETHER;

/**** Group ****/

typedef struct __tgroup {
  struct __tgroup *     next;           /* Pointer to previous list element */
  struct __tgroup *     prev;           /* Pointer to next list element     */
  AMMP_ATOM *           b1;             /* Atom pointer 1                   */
  AMMP_ATOM *           b2;             /* Atom pointer 2                   */
  AMMP_ATOM *           b3;             /* Atom pointer 3                   */
  AMMP_ATOM *           context;        /* Atom pointer 4                   */
  AMMP_ATOM **          group;          /* Atoms to move                    */
  float                 base;           /* Torsion base value               */
  float                 TorWin;         /* Torsion window for random search */
  int                   ingroup;        /* Number of atoms to move          */
  int                   ntry;           /* Rotation steps                   */
  int                   which;          /* Torsion ID                       */
  int                   B1Id;           /* Atom ID 1                        */
  int                   B2Id;           /* Atom ID 2                        */
  int                   B3Id;           /* Atom ID 3                        */
  int                   ContextId;      /* Atom ID 4                        */
  int                   Flags;          /* Flags                            */
} TGROUP;

/**** Torsion ****/

typedef struct __torsion {
  struct __torsion *    next;
  AMMP_ATOM             *atom1, *atom2, *atom3, *atom4;
  float                 k, offset;
  int                   n;
} TORSION;

/**** Ttarget ****/

typedef struct __ttarget {
  struct __ttarget *    next;
  AMMP_ATOM             *atom1, *atom2, *atom3, *atom4;
  float                 k, angle;
} TTARGET;

/**** Variable ****/

typedef struct __variable {
  struct __variable *   next;
  int                   type;
  int                   flags;
  char                  name[NUM_TOT];
  union {
    float               (AMMP_FASTCALL *f)(void);
    int                 (AMMP_FASTCALL *i)(void);
  } GetVal;
  union {
    float               f;
    int                 i;
  } value;
} VARIABLE;

#include "numeric.h"

/**** Global variables ****/

extern AMMP_ABC         *abc_first, *abc_last;
extern AMMP_ATOM        *atomfirst, *atomlast, **mom_list;
extern AMMP_FFUNC       forces[];
extern AMMP_VFUNC       potentials[];
extern ANGLE            *angle_first, *angle_last;
extern AV5              *av5_first, *av5_last;
extern BOND             *bond_first, *bond_last;
extern CLONE            *clone_first, *clone_last;
extern DATATABLE        *first_datatable, *last_datatable;
extern int              AmmpEndian, atomNUMBER, atomUPDATE, in_mom_list;
extern int              nused;
extern HYBRID           *hybrid_first, *hybrid_last;
extern MORSE            *morse_first, *morse_last;
extern NOEL             *noel_first, *noel_last;
extern RESTRAIN         *restrain_first, *restrain_last;
extern STEP             *STEP_first, *STEP_last;
extern SWARM            *SWARM_first, *SWARM_last;
extern TBOND            *first_tbond, *last_tbond;
extern TETHER           *tether_first, *tether_last;
extern TGROUP           *tg_first, *tg_last;
extern TORSION          *torsion_first, *torsion_last;
extern TTARGET          *ttarget_first, *ttarget_last;
extern VARIABLE         *variableFIRST, *variableLAST;

/**** Prototypes ****/

void                          aaerror(const char *, ...);
void                          aawarning(const char *line, ...);
int             AMMP_FASTCALL abc(int p1, int p2, int p3, float theta, float thetazero, float dr, float dk1, float dk2);
float           AMMP_FASTCALL abuild_dgeom(float vect[3], float lam, AMMP_ATOM *who, AMMP_ATOM *bps[], int inbps);
float           AMMP_FASTCALL abuild_line_search(float vect[3], float *step, AMMP_ATOM *who, AMMP_ATOM *bps[], int inbps);
int             AMMP_FASTCALL activate(int i1, int i2, int Val);
void            AMMP_FASTCALL add_pair_to_table(int id, int count, float r, float v);
void *          AMMP_FASTCALL Alloca(unsigned int Size, const char *Routine);
void *          AMMP_FASTCALL AllocaC(unsigned int Size, const char *Routine);
int             AMMP_FASTCALL alltether(float fk);
void            AMMP_FASTCALL analyze(AMMP_VFUNC vsf[], int nfs, int ilow, int ihigh, FILE *op);
int             AMMP_FASTCALL angle(int p1, int p2, int p3, float fk, float bl);
void            AMMP_FASTCALL assign_scatter(int ilow, int ihi);
int             AMMP_FASTCALL atom(float x, float y, float z, int serial, float q, float a, float b, float mass, char *name);
int             AMMP_FASTCALL av5(int p1, int p2, int p3, int p4, int p5, float fk, float off);
int             AMMP_FASTCALL a_abc(float *V, float lambda, int ilow, int ihigh, FILE *op);
int             AMMP_FASTCALL a_angle(float *V, float lambda, int ilow, int ihigh, FILE *op);
int             AMMP_FASTCALL a_av5(float *V, float lambda, int ilow, int ihigh, FILE *op);
int             AMMP_FASTCALL a_bond(float *V, float lambda, int ilow, int ihigh, FILE *op);
void            AMMP_FASTCALL a_build(FILE *op, int nused, AMMP_VFUNC pot[], AMMP_FFUNC force[], int ncycles, int low_atom, int high_atom, int echo);
int             AMMP_FASTCALL a_c_angle(float *V, float lambda, int ilow, int ihigh, FILE *op);
int             AMMP_FASTCALL a_d_zero(void);
int             AMMP_FASTCALL a_f_zero(void);
int             AMMP_FASTCALL a_ftodx(float lambda, float lamold);
int             AMMP_FASTCALL a_ftogx(float lambda, float lamold);
int             AMMP_FASTCALL a_ftovx(float lambda, float lamold);
int             AMMP_FASTCALL a_g_zero(void);
int             AMMP_FASTCALL a_hybrid(float *V, float lambda, int ilow, int ihigh, FILE *op);
int             AMMP_FASTCALL a_inactive_f_zero(void);
int             AMMP_FASTCALL a_inc_d(float lambda);
int             AMMP_FASTCALL a_inc_f(float lambda);
int             AMMP_FASTCALL a_inc_v(float lambda);
float           AMMP_FASTCALL a_l2_d(void);
float           AMMP_FASTCALL a_l2_f(void);
float           AMMP_FASTCALL a_l2_g(void);
float           AMMP_FASTCALL a_l2_v(void);
float           AMMP_FASTCALL a_max_d(void);
float           AMMP_FASTCALL a_max_f(void);
int             AMMP_FASTCALL a_mmangle(float *V, float lambda, int ilow, int ihigh, FILE *op);
int             AMMP_FASTCALL a_mmbond(float *V, float lambda, int ilow, int ihigh, FILE *op);
AMMP_ATOM *     AMMP_FASTCALL a_m_serial(int serial);
AMMP_ATOM *     AMMP_FASTCALL a_m_serial_table(int serial);
AMMP_ATOM *     AMMP_FASTCALL a_next(int flag);
int             AMMP_FASTCALL a_noel(float *V, float lambda, int ilow, int ihigh, FILE *op);
int             AMMP_FASTCALL a_nonbon(float *V, float lambda, int ilow, int ihigh, FILE *op);
int             AMMP_FASTCALL a_number(void);
float           AMMP_FASTCALL a_pr_beta(void);
int             AMMP_FASTCALL a_readvelocity(int serial, float vx, float vy, float vz);
int             AMMP_FASTCALL a_restrain(float *V, float lambda, int ilow, int ihigh, FILE *op);
int             AMMP_FASTCALL a_screen(float *V, float lambda, int ilow, int ihigh, FILE *op);
int             AMMP_FASTCALL a_step(float *V, float lambda, int ilow, int ihigh, FILE *op);
int             AMMP_FASTCALL a_swarm(float *V, float lambda, int ilow, int ihigh, FILE *op);
int             AMMP_FASTCALL a_tether(float *V, float lambda, int ilow, int ihigh, FILE *op);
int             AMMP_FASTCALL a_torsion(float *V, float lambda, int ilow, int ihigh, FILE *op);
int             AMMP_FASTCALL a_ttarget(float *V, float lambda, int ilow, int ihigh, FILE *op);
int             AMMP_FASTCALL a_v_zero(void);
int             AMMP_FASTCALL bfgs(AMMP_VFUNC vsf[], AMMP_FFUNC ffs[], int nfs, int nstep, float toler, int echo);
void            AMMP_FASTCALL bellman(FILE *op, AMMP_VFUNC vsf[], int nfs, int niter, int low_serial, int high_serial, int echo);
float           AMMP_FASTCALL bellman_dgeom(float vect[3], float lam, AMMP_ATOM *who);
float           AMMP_FASTCALL bellman_line_search(float vect[3], float *step, AMMP_ATOM *who);
int             AMMP_FASTCALL bellman_relax(AMMP_ATOM *who);
int             AMMP_FASTCALL bond(int p1, int p2, float bl, float fk, float order);
float           AMMP_FASTCALL bond_length(AMMP_ATOM *a1, AMMP_ATOM *a2);
int             AMMP_FASTCALL bond_next(int i, AMMP_ATOM **ap1, AMMP_ATOM **ap2);
int             AMMP_FASTCALL bond_number(void);
float           AMMP_FASTCALL bstrot(float x[], float y[], float z[], float xx[], float yy[], float zz[], int na, float matrix[3][3], float delta[3]);
float           AMMP_FASTCALL CeilF(float x);
float           AMMP_FASTCALL Charge(void);
int             AMMP_FASTCALL CheckAtoms(void);
int             AMMP_FASTCALL CheckEndian(void);
CLONE *         AMMP_FASTCALL Clone(CLONE *cp, int who);
int             AMMP_FASTCALL CloneDel(CLONE *Cp, int Id);
void            AMMP_FASTCALL CloneFree(CLONE *Cp);
CLONE *         AMMP_FASTCALL CloneRestore(CLONE *cp, int who);
float           AMMP_FASTCALL clone_average_distance(int iat, int jat, int min, float radius, float error);
int             AMMP_FASTCALL cngdel(AMMP_VFUNC vsf[], AMMP_FFUNC ffs[], int nfs, int nstep, int nreset, float toler, int echo, int nupdat);
int             AMMP_FASTCALL concatview(float r1[3][3], float rout[3][3]);
void            AMMP_FASTCALL cpyvec(float orig[], float copy[], int n);
int             AMMP_FASTCALL create_table(int id, int inme);
void            AMMP_FASTCALL Default(void);
void            AMMP_FASTCALL dgeom(FILE *op, AMMP_VFUNC vsf[], int nfs, int niter, int origin, float eigshift, int echo);
void            AMMP_FASTCALL dgeom_ortho(int numatm, float *a, float *b, float *c, float x[], float y[], float z[]);
void            AMMP_FASTCALL dgeom_update(FILE *op, int numatm, int echo);
void            AMMP_FASTCALL dipole(FILE *op, int first, int last);
void            AMMP_FASTCALL direct_scf(FILE *output, int nstep , float toler, char *what);
int             AMMP_FASTCALL doubletime(AMMP_FFUNC forces[], int nforces, int nstep, float dlong, float dshort, float temper);
void            AMMP_FASTCALL do_abc(float lambda);
void            AMMP_FASTCALL dump_abcs(FILE *where);
void            AMMP_FASTCALL dump_angles(FILE *where);
void            AMMP_FASTCALL dump_av5s(FILE *where);
void            AMMP_FASTCALL dump_atoms(FILE *where);
void            AMMP_FASTCALL dump_bonds(FILE *where);
void            AMMP_FASTCALL dump_excludes(FILE *where);
void            AMMP_FASTCALL dump_force(FILE *where);
void            AMMP_FASTCALL dump_hybrids(FILE *where);
void            AMMP_FASTCALL dump_morse(FILE *where);
void            AMMP_FASTCALL dump_noels(FILE *where);
void            AMMP_FASTCALL dump_pdb(FILE *where, int res_mod);
void            AMMP_FASTCALL dump_reflection(FILE *fp);
void            AMMP_FASTCALL dump_restrains(FILE *where);
void            AMMP_FASTCALL dump_scatter(FILE *fp);
void            AMMP_FASTCALL dump_steps(FILE *where);
void            AMMP_FASTCALL dump_swarms(FILE *where);
void            AMMP_FASTCALL dump_symmetry(FILE *fp);
void            AMMP_FASTCALL dump_table(FILE * where);
void            AMMP_FASTCALL dump_tbond(FILE *where);
void            AMMP_FASTCALL dump_tethers(FILE *where);
void            AMMP_FASTCALL dump_torsions(FILE *where);
void            AMMP_FASTCALL dump_ttargets(FILE *where);
void            AMMP_FASTCALL dump_variable(FILE *where);
void            AMMP_FASTCALL dump_velocity(FILE *where);
void            AMMP_FASTCALL dump_xtalcell(FILE *fp);
int             AMMP_FASTCALL eval(FILE *ip, FILE *op, char *line);
int             AMMP_FASTCALL FDnormal(AMMP_FFUNC forces[], int nfs, int echo, FILE *op, float normal);
void            AMMP_FASTCALL fittraj(float steps[], float coef[], int nstep, int ncoef);
int             AMMP_FASTCALL fv_update_debye(float lambda);
int             AMMP_FASTCALL fv_update_nonbon(float lambda);
int             AMMP_FASTCALL fv_update_react(float lambda);
int             AMMP_FASTCALL fv_update_shadow(float lambda);
int             AMMP_FASTCALL f_abc(float lambda);
int             AMMP_FASTCALL f_angle_p(float lambda);
int             AMMP_FASTCALL f_angle(float lambda);
int             AMMP_FASTCALL f_av5(float lambda);
int             AMMP_FASTCALL f_bond_p(float lambda);
int             AMMP_FASTCALL f_bond(float lambda);
int             AMMP_FASTCALL f_box(float lambda);
int             AMMP_FASTCALL f_c_angle(float lambda);
int             AMMP_FASTCALL f_debye(float lambda);
int             AMMP_FASTCALL f_fourd(float lambda);
int             AMMP_FASTCALL f_hard(float lambda);
int             AMMP_FASTCALL f_ho_angle(float lambda);
int             AMMP_FASTCALL f_ho_av5(float lambda);
int             AMMP_FASTCALL f_ho_bond(float lambda);
int             AMMP_FASTCALL f_ho_hybrid(float lambda);
int             AMMP_FASTCALL f_ho_noel(float lambda);
int             AMMP_FASTCALL f_ho_tether(float lambda);
int             AMMP_FASTCALL f_hybrid(float lambda);
int             AMMP_FASTCALL f_mmangle(float lambda);
int             AMMP_FASTCALL f_mmbond(float lambda);
int             AMMP_FASTCALL f_morse(float lambda);
int             AMMP_FASTCALL f_noel(float lambda);
int             AMMP_FASTCALL f_nonbon(float lambda);
int             AMMP_FASTCALL f_react(float lambda);
int             AMMP_FASTCALL f_restrain(float lambda);
int             AMMP_FASTCALL f_periodic(float lambda);
int             AMMP_FASTCALL f_screen(float lambda);
int             AMMP_FASTCALL f_shadow(float lambda);
int             AMMP_FASTCALL f_step(float lambda);
int             AMMP_FASTCALL f_swarm(float lambda);
int             AMMP_FASTCALL f_tbond(float lambda);
int             AMMP_FASTCALL f_tether(float lambda);
int             AMMP_FASTCALL f_torsion_p(float lambda);
int             AMMP_FASTCALL f_torsion(float lambda);
int             AMMP_FASTCALL f_trace(float lambda);
int             AMMP_FASTCALL f_ttarget(float lambda);
void            AMMP_FASTCALL gdock(FILE *op,float toler, int ngene, int niter, float vara, float varx, AMMP_VFUNC potent[], int inpotent, int imin, int imax, int echo);
int             AMMP_FASTCALL gene(FILE *op, AMMP_VFUNC vsf[], AMMP_FFUNC ffs[], int nfs, int nstep, int ndeep, float sigma, float target, int nos);
void            AMMP_FASTCALL gene_valid_coordinate(void);
float           AMMP_FASTCALL GetCutoff(void);
int             AMMP_FASTCALL GetDend(void);
float           AMMP_FASTCALL GetDddr(void);
float           AMMP_FASTCALL GetDielectric(void);
float           AMMP_FASTCALL GetLambda(void);
float           AMMP_FASTCALL GetMmbox(void);
float           AMMP_FASTCALL GetMxcut(void);
float           AMMP_FASTCALL GetMxdq(void);
float           AMMP_FASTCALL GetMxdq2(void);
float           AMMP_FASTCALL GetMxPerIter(void);
int             AMMP_FASTCALL GetNbdeep(void);
int             AMMP_FASTCALL GetNbstep(void);
int             AMMP_FASTCALL GetNostep(void);
int             AMMP_FASTCALL GetNupdat(void);
float           AMMP_FASTCALL GetRdebye(void);
int             AMMP_FASTCALL GetSupdat(void);
int             AMMP_FASTCALL GetThreads(void);
float           AMMP_FASTCALL GetTrace(void);
float           AMMP_FASTCALL getsthol(int h, int k, int l);
void            AMMP_FASTCALL get_abc(AMMP_ATOM *a1, AMMP_ATOM *bonded[], int mbond, int *inbond);
float *         AMMP_FASTCALL getatomdata(char *who);
void            AMMP_FASTCALL get_angle(AMMP_ATOM *a1, AMMP_ATOM *bonded[], int mbond, int *inbond);
void            AMMP_FASTCALL get_av5(AMMP_ATOM *a1, AMMP_ATOM *bonded[], int mbond, int *inbond);
void            AMMP_FASTCALL get_bond(AMMP_ATOM *a1, AMMP_ATOM *bonded[], int mbond, int *inbond);
void            AMMP_FASTCALL get_bond_and_length(AMMP_ATOM *a1, AMMP_ATOM *bonded[], float r[], int mbond, int *inbond);
BOND *          AMMP_FASTCALL get_bond_pointer(AMMP_ATOM *a1, AMMP_ATOM *a2);
float           AMMP_FASTCALL get_f_variable(char *name);
VARIABLE *      AMMP_FASTCALL get_fi_variable(char *name, float *f, int *i);
void            AMMP_FASTCALL get_hybrid(AMMP_ATOM *a1, AMMP_ATOM *bonded[], int mbond, int *inbond);
int             AMMP_FASTCALL get_i_variable(char *name);
void            AMMP_FASTCALL get_morse(AMMP_ATOM *a1, AMMP_ATOM *morseed[], int mmorse, int *inmorse);
void            AMMP_FASTCALL get_noel(AMMP_ATOM *a1, AMMP_ATOM *noeled[], int mnoel, int *innoel);
void            AMMP_FASTCALL get_noel_and_bounds(AMMP_ATOM *a1, AMMP_ATOM *noeled[], float r[], float rmax[], int mnoel, int *innoel);
void            AMMP_FASTCALL get_noel_and_length(AMMP_ATOM *a1, AMMP_ATOM *noeled[], float r[], int mnoel, int *innoel);
void            AMMP_FASTCALL get_restrain(AMMP_ATOM *a1, AMMP_ATOM *restrained[], int mrestrain, int *inrestrain);
void            AMMP_FASTCALL get_step(AMMP_ATOM *a1, AMMP_ATOM *STEPed[], int mSTEP, int *inSTEP);
void            AMMP_FASTCALL get_step_and_bounds(AMMP_ATOM *a1, AMMP_ATOM *steped[], float r[], float rmid[], float rmax[], int mstep, int *instep);
void            AMMP_FASTCALL get_step_and_length(AMMP_ATOM *a1, AMMP_ATOM *STEPed[], float r[], int mSTEP, int *inSTEP);
void            AMMP_FASTCALL get_torsion(AMMP_ATOM *a1, AMMP_ATOM *bonded[], int mbond, int *inbond);
float           AMMP_FASTCALL get_torsion_value(AMMP_ATOM *a1, AMMP_ATOM *a2, AMMP_ATOM *a3, AMMP_ATOM *a4);
void            AMMP_FASTCALL get_ttarget(AMMP_ATOM *a1, AMMP_ATOM *bonded[], int mbond, int *inbond);
int             AMMP_FASTCALL grasp(FILE *op, int echo, AMMP_VFUNC vsf[], AMMP_FFUNC ffs[], int nfs, int nstep, int nkeep, int nsearch, int imin, int imax, char *whom);
int             AMMP_FASTCALL grasp_valid_coordinate(void);
void            AMMP_FASTCALL gsdg(FILE *op, AMMP_VFUNC vsf[], int nfs, int niter, int low_serial, int high_serial, int echo);
void            AMMP_FASTCALL gsdg_angle(AMMP_ATOM *who);
void            AMMP_FASTCALL gsdg_bond(AMMP_ATOM *who);
float           AMMP_FASTCALL gsdg_dgeom(float vect[3], float lam, AMMP_ATOM *who);
void            AMMP_FASTCALL gsdg_hybrid(AMMP_ATOM *who);
float           AMMP_FASTCALL gsdg_line_search(float vect[3], float *step, AMMP_ATOM *who);
void            AMMP_FASTCALL gsdg_noel(AMMP_ATOM *ap);
void            AMMP_FASTCALL gsdg_step(AMMP_ATOM *ap);
void            AMMP_FASTCALL gsdg_torsion(AMMP_ATOM *ap);
void            AMMP_FASTCALL gsdg_ttarget(AMMP_ATOM *ap);
int             AMMP_FASTCALL hpac(AMMP_FFUNC forces[], AMMP_VFUNC poten[], int nforces, int nstep, float dtime_real, float H);
int             AMMP_FASTCALL hybrid(int p1, int p2, int p3, int p4, float fk, float off);
void            AMMP_FASTCALL inactivate_non_zero(int i1, int i2);
void            AMMP_FASTCALL init_fourd(float howmuch);
int             AMMP_FASTCALL jacobi(float *am, float *em, int n, int maxit, float toler);
int             AMMP_FASTCALL kdock(AMMP_VFUNC vfs[], AMMP_FFUNC ffs[], int nfs, int niter, float radius, int initialize, float rx, float ry, float rz);
void            AMMP_FASTCALL kohonen(FILE *op, AMMP_VFUNC vsf[], AMMP_FFUNC ffs[], int nfs, int niter, float radius, int initialize, float rx, float ry, float rz, int echo);
void            AMMP_FASTCALL kohonen_minimizer(AMMP_VFUNC vsf[], AMMP_FFUNC ffs[], int nfs, int nstep);
float           AMMP_FASTCALL linmin(AMMP_VFUNC ffs[], int nfs, float damp);
void *          AMMP_FASTCALL ListAdd(void **BegList, void **LastList, int Size);
void            AMMP_FASTCALL ListFree(void **BegList, void **LastList);
void            AMMP_FASTCALL ListLinkAtEnd(void **BegList, void **LastList, void *Item);
void            AMMP_FASTCALL ListRemove(void **BegList, void **LastList, void *Item);
int             AMMP_FASTCALL ListUnlink(void **BegList, void **LastList, void *Item);
void            AMMP_FASTCALL loadloop(FILE *ip, FILE *tp, char *label);
void            AMMP_FASTCALL math_findlabel(FILE *fp, char *label);
int             AMMP_FASTCALL math_match_atom(char *who, AMMP_ATOM *ap);
VARIABLE *      AMMP_FASTCALL match_variable(char *name);
int             AMMP_FASTCALL math(char tokens[][TOKENLENGTH], float fvalue[], int *ivalue, FILE *ip, FILE *op, int echo);
void            AMMP_FASTCALL matmul(float a[], float b[], float c[], int n, int m);
int             AMMP_FASTCALL mcmin(FILE *op, AMMP_VFUNC vfs[], AMMP_FFUNC ffs[], int nfs, char *at1, char *at2, float temper, int nstep, int echo);
int             AMMP_FASTCALL mm_fv_update_nonbon(float lambda);
int             AMMP_FASTCALL mom(FILE *op, float tq, int niter, int echo);
int             AMMP_FASTCALL mom_add(int s1, int s2);
float           AMMP_FASTCALL mom_jab(float r, float j1, float j2);
void            AMMP_FASTCALL mom_param(int serial, float chi, float jaa);
int             AMMP_FASTCALL mom_solve(float (*matrix)[], float (*vector)[], int irow, int ilead);
void            AMMP_FASTCALL monitor(AMMP_VFUNC vsf[], AMMP_FFUNC ffs[], int nfs, FILE *op);
int             AMMP_FASTCALL morse(int p1, int p2, float bl, float fk, float order);
int             AMMP_FASTCALL nnclone(FILE *op, int who[], int how_many, float rmin, float rmax);
int             AMMP_FASTCALL noel(int p1, int p2, float d, float dm, float dh, float km, float kh);
int             AMMP_FASTCALL noel_generate(float dm, float dh);
int             AMMP_FASTCALL noel_next(int i, AMMP_ATOM **n1, AMMP_ATOM **n2, int *ismet);
int             AMMP_FASTCALL NonBondAllocTable(int Atoms, int Type);
int             AMMP_FASTCALL NonBondCheck(register float mxdq, register float lambda);
void            AMMP_FASTCALL NonBondFreeTable(void);
float           AMMP_FASTCALL normalize_torsion(float Val);
int             AMMP_FASTCALL pac(AMMP_FFUNC forces[], int nforces, int nstep, float dtime);
int             AMMP_FASTCALL pacpac(AMMP_FFUNC forces[], int nforces, int nstep, float dtime);
int             AMMP_FASTCALL ppac(AMMP_FFUNC forces[], int nforces, int nstep, float dtime_real, float P);
void            AMMP_FASTCALL PrintStr(FILE *FH, char *Str);
void            AMMP_FASTCALL projtraj(float *x, float *vx, float x0, float coef[], int ncoef, float dlong, float dshort);
int             AMMP_FASTCALL ptpac(AMMP_FFUNC forces[], int nforces, int nstep, float dtime_real, float P, float T);
void            AMMP_FASTCALL quarternion_rot_tran(float what[], AMMP_ATOM *(*who)[], int howmany);
void            AMMP_FASTCALL rand3(float *x, float *y, float *z);
float           AMMP_FASTCALL randf(void);
float           AMMP_FASTCALL randg(void);
void            AMMP_FASTCALL read_eval_do(FILE *ip, FILE *op);
void *          AMMP_FASTCALL ReAlloca(void *OldMem, unsigned int Size, const char *Routine);
int             AMMP_FASTCALL reflection(int h, int k, int l, float fo, float sigma, float fa, float fb);
void            AMMP_FASTCALL Reset(void);
void            AMMP_FASTCALL ResetAtom(void);
void            AMMP_FASTCALL ResetClone(void);
void            AMMP_FASTCALL ResetDebye(void);
void            AMMP_FASTCALL ResetMom(void);
void            AMMP_FASTCALL ResetN3(void);
void            AMMP_FASTCALL ResetNoel(void);
void            AMMP_FASTCALL ResetOrbit(void);
void            AMMP_FASTCALL ResetRandom(void);
void            AMMP_FASTCALL ResetReact(void);
void            AMMP_FASTCALL ResetShadow(void);
void            AMMP_FASTCALL ResetTable(void);
void            AMMP_FASTCALL ResetUnonbon(void);
void            AMMP_FASTCALL ResetVnonbon(void);
int             AMMP_FASTCALL restrain(int p1, int p2, float bl, float fk);
int             AMMP_FASTCALL richard(FILE *op, int echo, AMMP_VFUNC vsf[], AMMP_FFUNC ffs[], int nfs, char *who, int niter, float p1, float p2, float p3);
int             AMMP_FASTCALL rigid(FILE *op, float toler, int niter, float var, AMMP_VFUNC potent[], int inpotent, int imin, int imax, int echo);
void            AMMP_FASTCALL SafeFree(void *Mem);
int             AMMP_FASTCALL scatter(char *atom, int number, float a1, float b1, float a2, float b2, float a3, float b3, float a4, float b4, float c);
float           AMMP_FASTCALL scatter_factor(int id, float sthol);
void            AMMP_FASTCALL SetMxdq(float Val);
VARIABLE *      AMMP_FASTCALL set_f_variable(char *name, float f);
int             AMMP_FASTCALL set_flags_variable(char *name, int flags);
VARIABLE *      AMMP_FASTCALL set_i_variable(char *name, int f);
void            AMMP_FASTCALL set_torsion(AMMP_ATOM *ap1, AMMP_ATOM *ap2, AMMP_ATOM *ap3, AMMP_ATOM *ap4, float howmuch);
int             AMMP_FASTCALL simplex(FILE *op, float toler, int niter, float var, AMMP_VFUNC potent[], int inpotent, int imin, int imax, int echo);
void            AMMP_FASTCALL simplex_contract(float *pt, float *rf, int n, int best, int worst , float howmuch);
int             AMMP_FASTCALL simplex_get_best(float *fvals, int n);
float           AMMP_FASTCALL simplex_get_var(float *fvals, int n);
int             AMMP_FASTCALL simplex_get_worst(float *fvals, int n);
void            AMMP_FASTCALL simplex_reflect(float *pt, float *rf, int n, int worst, float wait);
int             AMMP_FASTCALL statclone(FILE *op);
int             AMMP_FASTCALL steep(AMMP_VFUNC vsf[], AMMP_FFUNC ffs[], int nfs, int nstep, float toler, int echo);
int             AMMP_FASTCALL step(int p1, int p2, float d1, float d2, float d3, float k1, float k2, float k3);
int             AMMP_FASTCALL STEP_next(int i, AMMP_ATOM **n1, AMMP_ATOM **n2);
int             AMMP_FASTCALL subclone(FILE *op,  int who[], int how_many);
int             AMMP_FASTCALL swarm(float k, int n, int p1, int p2, int p3, int p4, int p5, int p6, int p7, int p8);
void            AMMP_FASTCALL symmetry(int id, char *oper, FILE *fp, int echo);
int             AMMP_FASTCALL symmetry_parse(char *oper, float matrix[3][3], float vector[3], FILE *fp, int echo);
void            AMMP_FASTCALL tailor_exclude(int from, int to);
void            AMMP_FASTCALL tailor_include(int from, int to);
void            AMMP_FASTCALL tailor_qab(int who, float q, float a, float b);
int             AMMP_FASTCALL tbond(int s1, int s2, int id, float scale);
int             AMMP_FASTCALL tether(int p1, float fk, float x, float y, float z);
int             AMMP_FASTCALL Tgroup(int which, int context, int b1, int b2, int b3, float base, int ntry, float TorWin);
void            AMMP_FASTCALL TgroupDump(FILE *where);
void            AMMP_FASTCALL TgroupReset(void);
int             AMMP_FASTCALL tisint(char *p);
int             AMMP_FASTCALL tisvariable(char * p);
int             AMMP_FASTCALL Tjump(AMMP_VFUNC vfs[], AMMP_FFUNC ffs[], int nfs, int TotConf, int MinSteps, float MinToler, float Temp, float RefRmsd, int Echo);
int             AMMP_FASTCALL tncnewt(FILE *op, AMMP_VFUNC vfs[], AMMP_FFUNC ffs[], int nfs, int nstep, float dtoler, float toler, int echo);
void            AMMP_FASTCALL tmap(FILE *op, int echo, AMMP_VFUNC vsf[],int nfs,int i1,int i2,int i3,int i4, int j1 , int j2 ,int j3, int j4 , int nistep, int njstep);
void            AMMP_FASTCALL tmin(FILE *op, int echo ,int i1,int i2,int i3,int i4,int nstep, AMMP_VFUNC vsf[], int nfs);
int             AMMP_FASTCALL tofrac(float x, float y, float z, float *xf, float *yf, float *zf);
int             AMMP_FASTCALL torsion(int p1, int p2, int p3, int p4, float fk, int n, float off);
int             AMMP_FASTCALL tpac(AMMP_FFUNC forces[], int nforces, int nstep, float dtime_real, float T);
int             AMMP_FASTCALL Trandom(AMMP_VFUNC vfs[], AMMP_FFUNC ffs[], int nfs, int TotConf, int MinSteps, float MinToler, int KeepPrev, int KeepMin, int Echo);
int             AMMP_FASTCALL trust(AMMP_VFUNC vsf[], AMMP_FFUNC ffs[], int nfs, int nstep, float dtoler, float toler);
int             AMMP_FASTCALL Tsearch(int MinSteps, float MinToler, int Echo);
void            AMMP_FASTCALL tset(FILE *op, int echo ,int i1,int i2,int i3,int i4, float alpha);
void            AMMP_FASTCALL tset_bond_build(AMMP_ATOM *ap1, AMMP_ATOM *ap2, AMMP_ATOM *ap3, AMMP_ATOM *ap4);
int             AMMP_FASTCALL ttarget(int p1, int p2, int p3, int p4, float angle, float fk);
int             AMMP_FASTCALL u_f_nonbon(float lambda);
int             AMMP_FASTCALL u_v_nonbon(float *V, float lambda);
int             AMMP_FASTCALL validatom(char *who);
int             AMMP_FASTCALL verlet(AMMP_FFUNC forces[], int nforces, int nstep, float dtime);
int             AMMP_FASTCALL v_abc(float *V, float lambda);
int             AMMP_FASTCALL v_angle_p(float *V, float lambda);
int             AMMP_FASTCALL v_angle(float *V, float lambda);
int             AMMP_FASTCALL v_av5(float *V, float lambda);
int             AMMP_FASTCALL v_bond_p(float *V, float lambda);
int             AMMP_FASTCALL v_bond(float *V, float lambda);
int             AMMP_FASTCALL v_box(float *V, float lambda);
int             AMMP_FASTCALL v_c_angle(float *V, float lambda);
int             AMMP_FASTCALL v_debye(float *V, float lambda);
int             AMMP_FASTCALL v_fourd(float *V, float lambda);
int             AMMP_FASTCALL v_hard(float *V, float lambda);
int             AMMP_FASTCALL v_ho_angle(float *V, float lambda);
int             AMMP_FASTCALL v_ho_av5(float *V, float lambda);
int             AMMP_FASTCALL v_ho_bond(float *V, float lambda);
int             AMMP_FASTCALL v_ho_hybrid(float *V, float lambda);
int             AMMP_FASTCALL v_ho_noel(float *V, float lambda);
int             AMMP_FASTCALL v_ho_tether(float *V, float lambda);
int             AMMP_FASTCALL v_hybrid(float *V, float lambda);
int             AMMP_FASTCALL v_maxwell(float T, float dx, float dy, float dz);
int             AMMP_FASTCALL v_mmangle(float *V, float lambda);
int             AMMP_FASTCALL v_mmbond(float *V, float lambda);
int             AMMP_FASTCALL v_morse(float *V, float lambda);
int             AMMP_FASTCALL v_noel(float *V, float lambda);
int             AMMP_FASTCALL v_nonbon(float *V, float lambda);
int             AMMP_FASTCALL v_periodic(float *V, float lambda);
float           AMMP_FASTCALL v_predict(float lambda, float vinit);
int             AMMP_FASTCALL v_react(float *V, float lambda);
int             AMMP_FASTCALL v_rescale(float T);
int             AMMP_FASTCALL v_restrain(float *V, float lambda);
int             AMMP_FASTCALL v_screen(float *V, float lambda);
int             AMMP_FASTCALL v_shadow(float *V, float lambda);
int             AMMP_FASTCALL v_step(float *V, float lambda);
int             AMMP_FASTCALL v_swarm(float *V, float lambda);
int             AMMP_FASTCALL v_tbond(float *V, float lambda);
int             AMMP_FASTCALL v_trace(float *V , float lambda);
int             AMMP_FASTCALL v_tether(float *V, float lambda);
int             AMMP_FASTCALL v_torsion_p(float *V, float lambda);
int             AMMP_FASTCALL v_torsion(float *V, float lambda);
int             AMMP_FASTCALL v_ttarget(float *V, float lambda);
int             AMMP_FASTCALL v_xray(float *V, float lambda);
void            AMMP_FASTCALL xtalcell(float a, float b, float c, float alpha, float beta, float gamma);
int             AMMP_FASTCALL zone_nonbon(float *V, float lambda, AMMP_ATOM *(*alist)[], int inalist);
int             AMMP_FASTCALL zone_react(float *V, float lambda, AMMP_ATOM *(*alist)[], int inalist);
int             AMMP_FASTCALL zone_screen(float *V, float lambda , AMMP_ATOM *(*alist)[], int inalist);
int             AMMP_FASTCALL zone_shadow(float *V, float lambda , AMMP_ATOM *(*alist)[], int inalist);

#  ifdef AMMP_USE_ERF
double          AMMP_FASTCALL erf(double x);
#  endif

#  ifdef GRAMMP
int             AMMP_FASTCALL concatview(float r1[3][3], float rout[3][3]);
int             AMMP_FASTCALL send_an_atom(AMMP_ATOM *who);
#  endif

#  ifdef AMMP_SENDTOGFX
int             AMMP_FASTCALL BinDumpCharge(void);
int             AMMP_FASTCALL DumpAtoms(float Ene);
int             AMMP_FASTCALL DumpVal(const char *ValName, void *Val, int ValType);
int             AMMP_FASTCALL send_all_atoms(void);
#  endif
#endif
