/* analyze.c
*
*  routine to analyze energy and force for AMMP.
*
*  analyzes the potential due to each kind of potential used
*
*/
/*
*  copyright 1992 Robert W. Harrison
*  
*  This notice may not be removed
*  This program may be copied for scientific use
*  It may not be sold for profit without explicit
*  permission of the author(s) who retain any
*  commercial rights including the right to modify 
*  this notice
*/

#define ANSI 1
/* misc includes - ANSI and some are just to be safe */
#include <stdio.h>
#include <ctype.h>

#ifdef ANSI
#  include <stdlib.h>
#endif

#ifdef __BORLANDC__
#  pragma hdrstop
#  include <fastmath.h>
#else
#  include <math.h>
#endif

#include "ammp.h"
/* ATOM structure contains a serial number for indexing into
* arrays and the like (a Hessian)
* but otherwise is self-contained. Note the hooks for Non-bonded potentials
*/

void AMMP_FASTCALL analyze(AMMP_VFUNC vfs[], int nfs, int ilow, int ihigh, FILE *op)
{
  float         vt;
  int           ifs;

  float         V = 0.0f;
  int           i = ilow;
  int           j = ihigh;

  if (ihigh < ilow) j = ilow;

  for(ifs = 0; ifs < nfs; ifs++) {
    vt = 0.0f;

    /* (*vfs[ifs])(&vt,0.); */

    if (vfs[ifs] == v_bond) {
      a_bond(&vt, 0.0f, i, j, op);
      fprintf(op, " %f bond energy\n", vt);
      goto DONE;
    }

    if (vfs[ifs] == v_mmbond) {
      a_mmbond(&vt, 0.0f, i, j, op);
      fprintf(op, " %f mm bond energy\n", vt);
      goto DONE;
    }

    if (vfs[ifs] == v_mmangle) {
      a_mmangle(&vt, 0.0f, i, j, op);
      fprintf(op, " %f mm angle energy\n", vt);
      goto DONE;
    }

    if (vfs[ifs] == v_angle) {
      a_angle(&vt, 0.0f, i, j, op);
      fprintf(op, " %f angle energy\n", vt);
      goto DONE;
    }

    if (vfs[ifs] == v_abc) {
      a_abc(&vt, 0.0f, i, j, op);
      fprintf(op, " %f abc energy\n",vt);
      goto DONE;
    }

    if (vfs[ifs] == v_noel) {
      a_noel(&vt, 0.0f, i, j, op);
      fprintf(op, " %f noel energy\n", vt);
      goto DONE;
    }

    if (vfs[ifs] == v_ho_noel) {
      a_noel(&vt, 0.0f, i, j, op);
      fprintf(op, " %f noel energy\n", vt);
      goto DONE;
    }

    if (vfs[ifs] == u_v_nonbon) {
      a_nonbon(&vt, 0.0f, i, j, op);
      fprintf(op, " %f non-bonded energy\n", vt);
      goto DONE;
    }

    if (vfs[ifs] == v_nonbon) {
      a_nonbon(&vt, 0.0f , i, j, op);
      fprintf(op, " %f non-bonded energy\n", vt);
      goto DONE;
    }

    if (vfs[ifs] == v_screen) {
      a_screen(&vt, 0.0f, i, j, op);
      fprintf(op, " %f screened non-bonded energy\n", vt);
      goto DONE;
    }

    if (vfs[ifs] == v_torsion) {
      a_torsion(&vt, 0.0f, i, j, op);
      fprintf(op, " %f torsion energy\n", vt);
      goto DONE;
    }

    if (vfs[ifs] == v_hybrid) {
      a_hybrid(&vt, 0.0f, i, j, op);
      fprintf(op, " %f hybrid energy\n", vt);
      goto DONE;
    }

    if (vfs[ifs] == v_periodic) goto DONE;

    if (vfs[ifs] == v_tether) {
      a_tether(&vt, 0.0f, i, j, op);
      fprintf(op, " %f tether restraint energy\n", vt);
      goto DONE;
    }

    if (vfs[ifs] == v_restrain) {
      a_restrain(&vt, 0.0f, i, j, op);
      fprintf(op, " %f restraint bond energy\n", vt);
      goto DONE;
    }

    if (vfs[ifs] == v_morse) goto DONE;

    if (vfs[ifs] == v_step) {
      a_step(&vt, 0.0f, i, j, op);
      fprintf(op, "%f step energy\n", vt);
      goto DONE;
    }

    if (vfs[ifs] == v_swarm) {
      a_swarm(&vt, 0.0f, i, j, op);
      fprintf(op, "%f swarm energy\n", vt);
      goto DONE;
    }

    if (vfs[ifs] == v_ttarget) {
      a_ttarget(&vt, 0.0f, i, j, op);
      fprintf(op, " %f torsion target energy\n", vt);
      goto DONE;
    }

DONE:

    /* next statement is needed because cannot have a label at an end loop */

    V += vt;
  } /* End of for (ifs) */

  fprintf(op, " %f total potential energy\n", V);
}

