/* av5.c
*
* collection of routines to service bond av5  potentials
*
*
*  av5 = b.b
*  where b = sum ( a2-a1,a3-a1, a4-a1,a5-a1) vectors
*
*  this term forces tetrahedral atoms to be tetrahedral
*  and introduces some mixing between angles and bonds
*  
*
* POOP (Poor-mans Object Oriented Programming) using scope rules
*
* these routines hold a data base (in terms of array indeces)
* of av5, with the associated length and force constant
*
* (this could be table driven but what the hell memories cheap)
*
* the routines for potential value, force and (eventually) second
* derivatives are here also
*
* force and 2nd derivative routines assume zero'd arrays for output
* this allows for parralellization if needed (on a PC?)
*
* forces are bond wise symmetric - so we don't have to fuck around with
* s matrices and the like.
*/
/*
*  copyright 1992 Robert W. Harrison
*  
*  This notice may not be removed
*  This program may be copied for scientific use
*  It may not be sold for profit without explicit
*  permission of the author(s) who retain any
*  commercial rights including the right to modify 
*  this notice
*/

#include <stdio.h>
#include <ctype.h>
#include <math.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#  include <fastmath.h>
#else
#  include <math.h>
#endif

#include "ammp.h"


/* a_av5()
* this function sums up the potentials
* for the atoms defined in the av5 data structure.
*/
/* standard returns 0 if error (any) 1 if ok
* V is the potential */

int AMMP_FASTCALL a_av5(float *V, float lambda, int ilow, int ihigh, FILE*op)
{
  /* difference vectors */
  float         x1,y1,z1,x2,y2,z2,x3,y3,z3,x4,y4,z4;

  /* cross products and storage for normalizing */

  float         r,cx,cy,cz;
  float         hite;
  AMMP_ATOM          *a1, *a2, *a3, *a4, *a5;

  AV5  *        bp = av5_first;

  if (bp == NULL) return 1;

  while(bp) {
	a1 = bp->atom1; a2 = bp->atom2; a3 = bp->atom3;
	a4 = bp->atom4; a5 = bp->atom5;
	if( (a1->serial >= ilow && a1->serial <= ihigh)
	||  (a2->serial >= ilow && a2->serial <= ihigh)
	||  (a3->serial >= ilow && a3->serial <= ihigh) 
	||  (a4->serial >= ilow && a4->serial <= ihigh) 
	||  (a5->serial >= ilow && a5->serial <= ihigh) )
	{

        x1 = (a2->x -a1->x +lambda*(a2->dx-a1->dx));
        y1 = (a2->y -a1->y +lambda*(a2->dy-a1->dy));
        z1 = (a2->z -a1->z +lambda*(a2->dz-a1->dz));
        x2 = (a3->x -a1->x +lambda*(a3->dx-a1->dx));
        y2 = (a3->y -a1->y +lambda*(a3->dy-a1->dy));
        z2 = (a3->z -a1->z +lambda*(a3->dz-a1->dz));
        x3 = (a4->x -a1->x +lambda*(a4->dx-a1->dx));
        y3 = (a4->y -a1->y +lambda*(a4->dy-a1->dy));
        z3 = (a4->z -a1->z +lambda*(a4->dz-a1->dz));
        x4 = (a5->x -a1->x +lambda*(a5->dx-a1->dx));
        y4 = (a5->y -a1->y +lambda*(a5->dy-a1->dy));
        z4 = (a5->z -a1->z +lambda*(a5->dz-a1->dz));
	cx = x1 + x2 + x3 + x4;
	cy = y1 + y2 + y3 + y4;
	cz = z1 + z2 + z3 + z4;

        r = cx*cx + cy*cy + cz*cz;
	hite = sqrt(r);
	z2 = hite - bp->offset;
	

	z2 =  bp->k *z2*z2; 
	*V += z2; 
	fprintf(op,"AV5 %s %d %s %d %s %d %s %d %s %d E %f value %f error %f\n",
	a1->name,a1->serial,a2->name,a2->serial,a3->name,a3->serial,a4->name,
	a4->serial,a5->name,a5->serial,z2,hite,hite- bp->offset);
	}
    if (bp == bp -> next) return 1;
    bp = bp -> next;
  }

  return 0;
}


/**** Add a new av5 entry ****/

int AMMP_FASTCALL av5(int p1, int p2, int p3, int p4, int p5, float fk, float off)
{
  AMMP_ATOM     *ap1, *ap2, *ap3, *ap4,*ap5;
  AV5           *new;

  /**** Get the atom pointers for the two serial numbers ****/

  ap1 = a_m_serial(p1);
  ap2 = a_m_serial(p2);
  ap3 = a_m_serial(p3);
  ap4 = a_m_serial(p4);
  ap5 = a_m_serial(p5);

  if ((!ap1) || (!ap2) || (!ap3) || (!ap4) || (!ap5)) {
    aaerror("Undefined atom in av5 %d %d %d %d %d", p1, p2, p3, p4, p5);
    return FALSE;
  }

  if((new = (AV5 *)Alloca(sizeof(AV5), "av5()")) == NULL)
    return FALSE;

  /**** Initialize the pointers ****/

  if (av5_first == NULL) av5_first = new;
  if (av5_last  == NULL) av5_last  = new;
  new -> atom1 = ap1;
  new -> atom2 = ap2;
  new -> atom3 = ap3;
  new -> atom4 = ap4;
  new -> atom5 = ap5;
  new -> offset = off;
  new -> k = fk;
  new -> next = new;
  av5_last -> next = new;
  av5_last = new;

  return TRUE;
}

/**** Dump the av5 terms ****/

void AMMP_FASTCALL dump_av5s(FILE *where)
{
  AV5           *b = av5_first;

  while(b) {
    fprintf(where, "av5 %d %d %d %d %d %f %f;\n",
            b -> atom1 -> serial, b -> atom2 -> serial,
            b -> atom3 -> serial, b -> atom4 -> serial,
            b -> atom5 -> serial, b -> k, b -> offset);
    if (b -> next == b) break;
    b = b -> next;
  } /* End of while */
}


/**** Increment the av5 force ****/

int AMMP_FASTCALL f_av5(float lambda)
{
  /* Difference vectors */

  float         x1, y1, z1;
  float         x2, y2, z2;
  float         x3, y3, z3;
  float         x4, y4, z4;

  /* Cross products and storage for normalizing */

  float         r,cx1,cy1,cz1;
  float         hite;
  float         df;
  AMMP_ATOM     *a1, *a2, *a3, *a4, *a5 ;

  AV5  *        bp = av5_first;

  if (bp == NULL ) return 1;

  while(bp) {
	a1 = bp->atom1; a2 = bp->atom2; a3 = bp->atom3;
	a4 = bp->atom4; a5 = bp->atom5;
	if( a1->active || a2->active || a3->active || a4->active
		|| a5->active){
        x1 = (a2->x -a1->x +lambda*(a2->dx-a1->dx));
        y1 = (a2->y -a1->y +lambda*(a2->dy-a1->dy));
        z1 = (a2->z -a1->z +lambda*(a2->dz-a1->dz));
        x2 = (a3->x -a1->x +lambda*(a3->dx-a1->dx));
        y2 = (a3->y -a1->y +lambda*(a3->dy-a1->dy));
        z2 = (a3->z -a1->z +lambda*(a3->dz-a1->dz));
        x3 = (a4->x -a1->x +lambda*(a4->dx-a1->dx));
        y3 = (a4->y -a1->y +lambda*(a4->dy-a1->dy));
        z3 = (a4->z -a1->z +lambda*(a4->dz-a1->dz));
        x4 = (a5->x -a1->x +lambda*(a5->dx-a1->dx));
        y4 = (a5->y -a1->y +lambda*(a5->dy-a1->dy));
        z4 = (a5->z -a1->z +lambda*(a5->dz-a1->dz));

	cx1 = x1 + x2 + x3 + x4;
	cy1 = y1 + y2 + y3 + y4;
	cz1 = z1 + z2 + z3 + z4;

	hite = sqrt(cx1*cx1 + cy1*cy1 + cz1*cz1);

	df =  two*bp->k*(bp->offset - hite );
/* do the  derivatives now  */
	r = two*sqrt(x1*x1 + y1*y1 + z1*z1);
	if( r > 1.e-6){
	a2->fx += df/r*(cx1+x1);
	a2->fy += df/r*(cy1+y1);
	a2->fz += df/r*(cz1+z1);
	a1->fx -= df/r*(cx1+x1);
	a1->fy -= df/r*(cy1+y1);
	a1->fz -= df/r*(cz1+z1);
	}
	r = two*sqrt(x2*x2 + y2*y2 + z2*z2);
	if( r > 1.e-6){
	a3->fx += df/r*(cx1+x2);
	a3->fy += df/r*(cy1+y2);
	a3->fz += df/r*(cz1+z2);
	a1->fx -= df/r*(cx1+x2);
	a1->fy -= df/r*(cy1+y2);
	a1->fz -= df/r*(cz1+z2);
	}
	r = two*sqrt(x3*x3 + y3*y3 + z3*z3);
	if( r > 1.e-6){
	a4->fx += df/r*(cx1+x3);
	a4->fy += df/r*(cy1+y3);
	a4->fz += df/r*(cz1+z3);
	a1->fx -= df/r*(cx1+x3);
	a1->fy -= df/r*(cy1+y3);
	a1->fz -= df/r*(cz1+z3);
	}
	r = two*sqrt(x4*x4 + y4*y4 + z4*z4);
	if( r > 1.e-6){
	a5->fx += df/r*(cx1+x4);
	a5->fy += df/r*(cy1+y4);
	a5->fz += df/r*(cz1+z4);
	a1->fx -= df/r*(cx1+x4);
	a1->fy -= df/r*(cy1+y4);
	a1->fz -= df/r*(cz1+z4);
	}
	if( a1->active == 0){ a1->fx = 0; a1->fy = 0.; a1->fz = 0;}
	if( a2->active == 0){ a2->fx = 0; a2->fy = 0.; a2->fz = 0;}
	if( a3->active == 0){ a3->fx = 0; a3->fy = 0.; a3->fz = 0;}
	if( a4->active == 0){ a4->fx = 0; a4->fy = 0.; a4->fz = 0;}
	if( a5->active == 0){ a5->fx = 0; a5->fy = 0.; a5->fz = 0;}

		} /* if active */

    if (bp == bp -> next) return 1;
    bp = bp -> next;
  } /* End of while */

  return 0;
}


/**** Increment the av5 force (homotopy version) ****/

int AMMP_FASTCALL f_ho_av5(float lambda)
{
  AMMP_ATOM     *a1, *a2, *a3, *a4, *a5;
  float         x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4;
  float         r, cx1, cy1, cz1;
  float         df, hite, hol;

  AV5 *         bp  = av5_first;

  if (!bp) return TRUE;

  hol  = one - GetLambda();
  hol *= hol;

  while(bp) {
    a1 = bp -> atom1;
    a2 = bp -> atom2;
    a3 = bp -> atom3;
    a4 = bp -> atom4;
    a5 = bp -> atom5;

    if ((a1 -> active) || (a2 -> active) || (a3 -> active) ||
        (a4 -> active) || (a5 -> active)) {
      if (lambda) {
        x1 = a2 -> x - a1 -> x + lambda * (a2 -> dx - a1 -> dx);
        y1 = a2 -> y - a1 -> y + lambda * (a2 -> dy - a1 -> dy);
        z1 = a2 -> z - a1 -> z + lambda * (a2 -> dz - a1 -> dz);
        x2 = a3 -> x - a1 -> x + lambda * (a3 -> dx - a1 -> dx);
        y2 = a3 -> y - a1 -> y + lambda * (a3 -> dy - a1 -> dy);
        z2 = a3 -> z - a1 -> z + lambda * (a3 -> dz - a1 -> dz);
        x3 = a4 -> x - a1 -> x + lambda * (a4 -> dx - a1 -> dx);
        y3 = a4 -> y - a1 -> y + lambda * (a4 -> dy - a1 -> dy);
        z3 = a4 -> z - a1 -> z + lambda * (a4 -> dz - a1 -> dz);
        x4 = a5 -> x - a1 -> x + lambda * (a5 -> dx - a1 -> dx);
        y4 = a5 -> y - a1 -> y + lambda * (a5 -> dy - a1 -> dy);
        z4 = a5 -> z - a1 -> z + lambda * (a5 -> dz - a1 -> dz);
      } else {
        x1 = a2 -> x - a1 -> x;
        y1 = a2 -> y - a1 -> y;
        z1 = a2 -> z - a1 -> z;
        x2 = a3 -> x - a1 -> x;
        y2 = a3 -> y - a1 -> y;
        z2 = a3 -> z - a1 -> z;
        x3 = a4 -> x - a1 -> x;
        y3 = a4 -> y - a1 -> y;
        z3 = a4 -> z - a1 -> z;
        x4 = a5 -> x - a1 -> x;
        y4 = a5 -> y - a1 -> y;
        z4 = a5 -> z - a1 -> z;
      }

      cx1 = x1 + x2 + x3 + x4;
      cy1 = y1 + y2 + y3 + y4;
      cz1 = z1 + z2 + z3 + z4;

      hite = sqrt(cx1 * cx1 + cy1 * cy1 + cz1 * cz1);
      df   =  two * bp -> k * hol * (bp -> offset - hite);

      /**** Do the derivatives ****/

      r = two * sqrt(x1 * x1 + y1 * y1 + z1 * z1);
      if( r > 1.e-6){
        a2 -> fx += df / r * (cx1 + x1);
        a2 -> fy += df / r * (cy1 + y1);
        a2 -> fz += df / r * (cz1 + z1);
        a1 -> fx -= df / r * (cx1 + x1);
        a1 -> fy -= df / r * (cy1 + y1);
        a1 -> fz -= df / r * (cz1 + z1);
      }

      r = two*sqrt(x2*x2 + y2*y2 + z2*z2);
      if( r > 1.e-6){
	a3->fx += df/r*(cx1+x2);
	a3->fy += df/r*(cy1+y2);
	a3->fz += df/r*(cz1+z2);
	a1->fx -= df/r*(cx1+x2);
	a1->fy -= df/r*(cy1+y2);
	a1->fz -= df/r*(cz1+z2);
	}
	r = two*sqrt(x3*x3 + y3*y3 + z3*z3);
	if( r > 1.e-6){
	a4->fx += df/r*(cx1+x3);
	a4->fy += df/r*(cy1+y3);
	a4->fz += df/r*(cz1+z3);
	a1->fx -= df/r*(cx1+x3);
	a1->fy -= df/r*(cy1+y3);
	a1->fz -= df/r*(cz1+z3);
	}
	r = two*sqrt(x4*x4 + y4*y4 + z4*z4);
	if( r > 1.e-6){
	a5->fx += df/r*(cx1+x4);
	a5->fy += df/r*(cy1+y4);
	a5->fz += df/r*(cz1+z4);
	a1->fx -= df/r*(cx1+x4);
	a1->fy -= df/r*(cy1+y4);
	a1->fz -= df/r*(cz1+z4);
      }

      if (!a1 -> active) {
        a1 -> fx = zero;
        a1 -> fy = zero;
        a1 -> fz = zero;
      }

      if (!a2 -> active) {
        a2 -> fx = zero;
        a2 -> fy = zero;
        a2 -> fz = zero;
      }

      if (!a3 -> active) {
        a3 -> fx = zero;
        a3 -> fy = zero;
        a3 -> fz = zero;
      }

      if (!a4 -> active) {
        a4 -> fx = zero;
        a4 -> fy = zero;
        a4 -> fz = zero;
      }

      if (!a5 -> active) {
        a5 -> fx = zero;
        a5 -> fy = zero;
        a5 -> fz = zero;
      }
    }

    if (bp == bp -> next ) return TRUE;
    bp = bp -> next;
  } /* End of while */

  return FALSE;
}


/**** Get the av5 ****/

void AMMP_FASTCALL get_av5(AMMP_ATOM *a1, AMMP_ATOM *bonded[], int mbond, int *inbond)
{
  AV5           *mine = av5_first;

  while(mine) {
    if (mine -> atom1 == a1)
      bonded[(*inbond)++] = mine->atom4;

    if (mine -> atom4 == a1)
      bonded[(*inbond)++] = mine->atom1;

    if ((mine == mine -> next) || (*inbond == mbond)) return;
    mine = mine -> next;
  } /* End of while */
}


/**** Calculate the av5 potential ****/

int AMMP_FASTCALL v_av5(float *V, float lambda)
{
  AMMP_ATOM     *a1, *a2, *a3, *a4, *a5;
  float         x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4;
  float         cx, cy, cz;
  float         hite;

  AV5 *         bp = av5_first;

  if (!bp) return TRUE;

  if (lambda) {
    while(bp) {
      a1 = bp -> atom1;
      a2 = bp -> atom2;
      a3 = bp -> atom3;
      a4 = bp -> atom4;
      a5 = bp -> atom5;
      if ((a1 -> active) || (a2 -> active) || (a3 -> active) ||
          (a4 -> active) || (a5 -> active)) {
        x1 = a2 -> x - a1 -> x + lambda * (a2 -> dx - a1 -> dx);
        y1 = a2 -> y - a1 -> y + lambda * (a2 -> dy - a1 -> dy);
        z1 = a2 -> z - a1 -> z + lambda * (a2 -> dz - a1 -> dz);
        x2 = a3 -> x - a1 -> x + lambda * (a3 -> dx - a1 -> dx);
        y2 = a3 -> y - a1 -> y + lambda * (a3 -> dy - a1 -> dy);
        z2 = a3 -> z - a1 -> z + lambda * (a3 -> dz - a1 -> dz);
        x3 = a4 -> x - a1 -> x + lambda * (a4 -> dx - a1 -> dx);
        y3 = a4 -> y - a1 -> y + lambda * (a4 -> dy - a1 -> dy);
        z3 = a4 -> z - a1 -> z + lambda * (a4 -> dz - a1 -> dz);
        x4 = a5 -> x - a1 -> x + lambda * (a5 -> dx - a1 -> dx);
        y4 = a5 -> y - a1 -> y + lambda * (a5 -> dy - a1 -> dy);
        z4 = a5 -> z - a1 -> z + lambda * (a5 -> dz - a1 -> dz);

        cx = x1 + x2 + x3 + x4;
        cy = y1 + y2 + y3 + y4;
        cz = z1 + z2 + z3 + z4;

        hite  = sqrt(cx * cx + cy * cy + cz * cz) - bp -> offset;
        *V   += bp -> k * hite * hite;
      }
      if (bp == bp -> next) return TRUE;
      bp = bp -> next;
    } /* End of while */
  } else {
    while(bp) {
      a1 = bp -> atom1;
      a2 = bp -> atom2;
      a3 = bp -> atom3;
      a4 = bp -> atom4;
      a5 = bp -> atom5;
      if ((a1 -> active) || (a2 -> active) || (a3 -> active) ||
          (a4 -> active) || (a5 -> active)) {
        x1 = a2 -> x - a1 -> x;
        y1 = a2 -> y - a1 -> y;
        z1 = a2 -> z - a1 -> z;
        x2 = a3 -> x - a1 -> x;
        y2 = a3 -> y - a1 -> y;
        z2 = a3 -> z - a1 -> z;
        x3 = a4 -> x - a1 -> x;
        y3 = a4 -> y - a1 -> y;
        z3 = a4 -> z - a1 -> z;
        x4 = a5 -> x - a1 -> x;
        y4 = a5 -> y - a1 -> y;
        z4 = a5 -> z - a1 -> z;

        cx = x1 + x2 + x3 + x4;
        cy = y1 + y2 + y3 + y4;
        cz = z1 + z2 + z3 + z4;

        hite  = sqrt(cx * cx + cy * cy + cz * cz) - bp -> offset;
        *V   += bp -> k * hite * hite;
      }
      if (bp == bp -> next) return TRUE;
      bp = bp -> next;
    } /* End of while */
  }

  return FALSE;
}


/**** Calculate the av5 potential (homotopy version) ****/

int AMMP_FASTCALL v_ho_av5(float *V, float lambda)
{
  AMMP_ATOM     *a1, *a2, *a3, *a4, *a5;
  float         x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4;
  float         cx, cy, cz;
  float         hite, hol;

  AV5 *         bp  = av5_first;

  if (!bp) return TRUE;

  hol = one - GetLambda();

  if (lambda) {
    while(bp) {
      a1 = bp -> atom1;
      a2 = bp -> atom2;
      a3 = bp -> atom3;
      a4 = bp -> atom4;
      a5 = bp -> atom5;
      if ((a1 -> active) || (a2 -> active) || (a3 -> active) ||
          (a4 -> active) || (a5 -> active)) {
        x1 = a2 -> x - a1 -> x + lambda * (a2 -> dx - a1 -> dx);
        y1 = a2 -> y - a1 -> y + lambda * (a2 -> dy - a1 -> dy);
        z1 = a2 -> z - a1 -> z + lambda * (a2 -> dz - a1 -> dz);
        x2 = a3 -> x - a1 -> x + lambda * (a3 -> dx - a1 -> dx);
        y2 = a3 -> y - a1 -> y + lambda * (a3 -> dy - a1 -> dy);
        z2 = a3 -> z - a1 -> z + lambda * (a3 -> dz - a1 -> dz);
        x3 = a4 -> x - a1 -> x + lambda * (a4 -> dx - a1 -> dx);
        y3 = a4 -> y - a1 -> y + lambda * (a4 -> dy - a1 -> dy);
        z3 = a4 -> z - a1 -> z + lambda * (a4 -> dz - a1 -> dz);
        x4 = a5 -> x - a1 -> x + lambda * (a5 -> dx - a1 -> dx);
        y4 = a5 -> y - a1 -> y + lambda * (a5 -> dy - a1 -> dy);
        z4 = a5 -> z - a1 -> z + lambda * (a5 -> dz - a1 -> dz);

        cx = x1 + x2 + x3 + x4;
        cy = y1 + y2 + y3 + y4;
        cz = z1 + z2 + z3 + z4;

        hite = hol * (sqrt(cx * cx + cy * cy + cz * cz) - bp -> offset);
        *V   += bp -> k * hite * hite;
      }
      if (bp == bp -> next) return TRUE;
      bp = bp -> next;
    } /* End of while */
  } else {
    while(bp) {
      a1 = bp -> atom1;
      a2 = bp -> atom2;
      a3 = bp -> atom3;
      a4 = bp -> atom4;
      a5 = bp -> atom5;
      if ((a1 -> active) || (a2 -> active) || (a3 -> active) ||
          (a4 -> active) || (a5 -> active)) {
        x1 = a2 -> x - a1 -> x;
        y1 = a2 -> y - a1 -> y;
        z1 = a2 -> z - a1 -> z;
        x2 = a3 -> x - a1 -> x;
        y2 = a3 -> y - a1 -> y;
        z2 = a3 -> z - a1 -> z;
        x3 = a4 -> x - a1 -> x;
        y3 = a4 -> y - a1 -> y;
        z3 = a4 -> z - a1 -> z;
        x4 = a5 -> x - a1 -> x;
        y4 = a5 -> y - a1 -> y;
        z4 = a5 -> z - a1 -> z;

        cx = x1 + x2 + x3 + x4;
        cy = y1 + y2 + y3 + y4;
        cz = z1 + z2 + z3 + z4;

        hite = hol * (sqrt(cx * cx + cy * cy + cz * cz) - bp -> offset);
        *V   += bp -> k * hite * hite;
      }
      if (bp == bp -> next) return TRUE;
      bp = bp -> next;
    } /* End of while */
  }

  return FALSE;
}


