
/********************************************
****        AMMP - Base64 routines       ****
**** Copyright 2006, Alessandro Pedretti ****
********************************************/


#include <malloc.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#endif

#include "ammp.h"
#include "base64.h"

/**** Local prototypes ****/

AMMP_INLINE void Base64DecodeBlock(unsigned char in[4], unsigned char out[3]);
AMMP_INLINE void Base64EncodeBlock(unsigned char in[3], unsigned char out[4], int len);

/**** Tables ****/

const char cb64[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
static const char cd64[] = "|$$$}rstuvwxyz{$$$$$$$>?@ABCDEFGHIJKLMNOPQRSTUVW$$$$$$XYZ[\\]^_`abcdefghijklmnopq";


/**** Decode 4 '6-bit' characters into 3 8-bit binary bytes ****/

AMMP_INLINE void Base64DecodeBlock(unsigned char in[4], unsigned char out[3])
{
  out[0] = (unsigned char)(in[0] << 2 | in[1] >> 4);
  out[1] = (unsigned char)(in[1] << 4 | in[2] >> 2);
  out[2] = (unsigned char)(((in[2] << 6) & 0xc0) | in[3]);
}


/**** Encode 3 8-bit binary bytes as 4 '6-bit' characters ****/

AMMP_INLINE void Base64EncodeBlock(unsigned char in[3], unsigned char out[4], int len)
{
  out[0] = cb64[ in[0] >> 2 ];
  out[1] = cb64[ ((in[0] & 0x03) << 4) | ((in[1] & 0xf0) >> 4) ];
  out[2] = (unsigned char)(len > 1 ? cb64[ ((in[1] & 0x0f) << 2) | ((in[2] & 0xc0) >> 6) ] : '=');
  out[3] = (unsigned char)(len > 2 ? cb64[ in[2] & 0x3f ] : '=');
}


/**** Create the encoding context ****/

AMMP_BASE64 * AMMP_FASTCALL Base64EncodeContext(int MemDecSize, int LineSize)
{
  AMMP_BASE64 *         B64;
  unsigned char *       MemEnc;

  const char *          Routine = "Base64EncodeContext()";

  if ((B64 = (AMMP_BASE64 *)Alloca(sizeof(AMMP_BASE64), Routine)) == NULL)
    return NULL;

  B64 -> LineSize   = LineSize;
  B64 -> MemDecSize = MemDecSize;
  B64 -> MemEncSize = 3 * MemDecSize;
  if (B64 -> MemEncSize & 3) B64 -> MemEncSize = B64 -> MemEncSize >> 2 + 1;
  else B64 -> MemEncSize >>= 2;
  if (B64 -> MemEncSize % LineSize) B64 -> MemEncSize = B64 -> MemEncSize + (B64 -> MemEncSize / LineSize) * 2 + 2;
  else B64 -> MemEncSize = B64 -> MemEncSize + (B64 -> MemEncSize / LineSize) * 2;

  if ((B64 -> MemEnc = (unsigned char *)Alloca(B64 -> MemEncSize, Routine)) == NULL) {
    free(B64);
    return NULL;
  }

  return B64;
}


/**** Free the context ****/

void AMMP_FASTCALL Base64FreeContext(AMMP_BASE64 *B64)
{
  if (!B64) return;
  if (B64 -> MemEnc) free(B64 -> MemEnc);
  free(B64);
}


/**** Encode a memory block in base64 format ****/

void AMMP_FASTCALL Base64Encode(AMMP_BASE64 *B64, unsigned char *MemDec)
{
  unsigned char *       Ptr        = B64 -> MemEnc;
  int                   BlocksOut  = 0;
  int                   LineSize   = B64 -> LineSize >> 2;
  int                   MemDecSize = B64 -> MemDecSize;

  while(MemDecSize) {
    MemDecSize -= 4;
    if (MemDecSize < 0) {
      Base64EncodeBlock(MemDec, Ptr, 4 + MemDecSize);
      *++Ptr = '\r';
      *++Ptr = '\n';
      break;
    }
    Base64EncodeBlock(MemDec, Ptr, 4);
    if (++BlocksOut >= LineSize) {
      BlocksOut = 0;
      *++Ptr    = '\r';
      *++Ptr    = '\n';
    }
    MemDec += 4;
    Ptr    += 4;
  } /* End of while */
}

