/* gsdx.c
* just find a feasible solution.
*
*  instead of the error being minimized as a target
*  (i.e. points on spheres)
*  minimize the number of constraints being used
*  in the L1 sense
*   The error is the violations of the inequalities
*    from the constraint graph
*    ( 1,..,-1,...) <= v
*    where the graph matix is one for the atom and -1 for its
*    constraint target.
*  x,y,z are searched at once and the error is evaluated in a
*   3-d spherical sense.
*  This then becomes the Bellman-Ford graph algorithm.
*/
/* bellman.c
*
*  Gauss-Siedel Distance Geometry
*
*  iteratively solve distance geometry equations
*  one atom at a time, but update the calculated distance estimates
*  each time.  (we know from the PMDG experiments that this is not
*  too expensive)
*/
/*
*  copyright 1993,1994 Robert W. Harrison
*
*  This notice may not be removed
*  This program may be copied for scientific use
*  It may not be sold for profit without explicit
*  permission of the author(s) who retain any
*  commercial rights including the right to modify
*  this notice
*/

#include <stdio.h>
#include <ctype.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#  include <fastmath.h>
#else
#  include <math.h>
#endif

#include "ammp.h"

void AMMP_FASTCALL bellman(FILE *op, AMMP_VFUNC vfs[], int nfs, int niter,
                           int low_serial, int high_serial, int echo)
{
  AMMP_ATOM     *ap, *bp;
  int           numatm;
  int           iter, i, j, k;
  int           local_iter;

  const char *  StepStr = "  Bellman %4d: Computing\n";
#ifdef VEGAZZ
  int           nupdat = GetNupdat();
  int           supdat = GetSupdat();
#endif

  if (!CheckAtoms()) return;

  numatm = a_number();
  if (high_serial <= 0 ) {
    for(i = 0; i < numatm; i++) {
      ap = a_next(i);
      if (high_serial < ap -> serial) high_serial = ap -> serial;
    } /* End of for (i) */
  }

  if (low_serial > high_serial) {
    i = low_serial;
    low_serial = high_serial;
    high_serial = i;
  }

  for(iter = 0; iter < niter; iter++) {
#ifdef VEGAZZ
    if ((nupdat) && (!(iter % nupdat))) send_all_atoms();
    if ((supdat) && (!(iter % supdat)))
#else
    if (echo)
#endif
      fprintf(op, StepStr, iter);

    ap = a_next(-1);
    for(i = 0; i < numatm; i++) {
      if (ap == NULL) break;
      if ((ap -> serial >= low_serial) && (ap -> serial <= high_serial)) {
        /*if( ap->active)*/{
        for(local_iter = 0; local_iter < 1; local_iter++) {
          for(j = 0; j < numatm; j++) {
            bp       = a_next(j);
            bp -> vx = 16.0f; /* default to 4A separation */
            bp -> vx = 9.0f;  /* try 3 */
            bp -> vy = 0.0f;  /* but only as a lower bound */
          } /* End of for (j) */

          for(j = 0; j < nfs; j++) {
            if ((vfs[j] == v_nonbon) || (vfs[j] == u_v_nonbon)) {
              for(k = 0; k < numatm; k++) {
                bp        = a_next(k);
                bp -> vy = -10.0f;
              }
              break;
            }
          } /* End of for (j) */

          for(j = 0; j < nfs; j++) {
            if ((vfs[j] == v_bond) || (vfs[j] == v_mmbond) || (vfs[j] == v_abc))
              gsdg_bond(ap);
            if ((vfs[j] == v_angle) || (vfs[j] == v_mmangle) || (vfs[j] == v_c_angle))
              gsdg_angle(ap);
            if (vfs[j] == v_noel) gsdg_noel(ap);
            if (vfs[j] == v_hybrid) gsdg_hybrid(ap);
          } /* End of for (j) */
          ap -> vy = 0.0f;

          bellman_relax(ap);
        } /* End of for (local_iter) */
      }
    }

      if (ap == ap -> next) break;
      ap = ap -> next;
    }  /* End of for (i) */
  } /* End of for (iter) */

#ifdef VEGAZZ
  if ((supdat) && ((iter % supdat) || (iter == niter)))
    fprintf(op, StepStr, iter);
#else
  if (echo)
#endif
    fprintf(op, "\n");
}


/**** Bellman relax ****/

int AMMP_FASTCALL bellman_relax(AMMP_ATOM *who)
{
  int           na;
  int           i;
  AMMP_ATOM *        ap;
  float         r,dx,dy,dz,target;

  na = a_number();
  if( na < 2) return 0;

  for(i=0; i< na; i++)
  {ap = a_next(i);
  if( ap->active ){
  dx = ap->x - who->x;
  dy = ap->y - who->y;
  dz = ap->z - who->z;
  r = dx*dx + dy*dy + dz*dz;

  if( r < 1.e-5) {
    rand3( &dx,&dy,&dz);
    r = dx*dx + dy*dy + dz*dz;
        }

  if( ap->vy > 0. && r > ap->vx ){
    target = sqrt(ap->vx/r);
    if( target < 0.75) target = 0.75;
/*
//    who->x = 0.5*(who->x + ap->x - dx*target);
//    who->y = 0.5*(who->y + ap->y - dy*target);
//    who->z = 0.5*(who->z + ap->z - dz*target);
*/
/*
    ap->x = 0.25*( 3*ap->x + who->x + dx*target);
    ap->y = 0.25*( 3*ap->y + who->y + dy*target);
    ap->z = 0.25*( 3*ap->z + who->z + dz*target);
*/
    ap->x = 0.5*( ap->x + who->x + dx*target);
    ap->y = 0.5*( ap->y + who->y + dy*target);
    ap->z = 0.5*( ap->z + who->z + dz*target);

  }

  if( ap->vy < 0. && r < ap->vx){
    target = sqrt(ap->vx/r);

/*
//    who->x = 0.5*(who->x + ap->x - dx*target);
//    who->y = 0.5*(who->y + ap->y - dy*target);
//    who->z = 0.5*(who->z + ap->z - dz*target);
*/

    ap->x = 0.25*(3*ap->x + who->x + dx*target);
    ap->y = 0.25*(3*ap->y + who->y + dy*target);
    ap->z = 0.25*(3*ap->z + who->z + dz*target);

      }
  }/* ap->active ?*/
  }/* i */

  return 0;
}/* end of bellman_relax */


float AMMP_FASTCALL bellman_line_search(float vect[3], float *step, AMMP_ATOM *who)
{
float val;
float vt,lam;
int i,j;
float dstep;

val = bellman_dgeom(vect, 0.0f, who);
lam = 0;
*step = 0;
/*
dstep = -.5;
*/
dstep = -1.0f;
for( i=0; i< 3; i++)
{
dstep *= -.5;
for( j = 0; j< 200 ; j++)
{
  lam += dstep;
  vt =  bellman_dgeom(vect,lam,who);
  if( vt < val ){ *step = lam; val = vt;} else {break;}
}
if( j == 200) dstep *= -2;
}
return val;
}/*end of routine */

float AMMP_FASTCALL bellman_dgeom(float vect[3], float lam, AMMP_ATOM *who)
{
  int           numatm;
  int           i;
  float         x, y, z;
  AMMP_ATOM *   ap;
  float         dt;
  float         dsum;

numatm = a_number();
x = who->x + vect[0]*lam;
y = who->y + vect[1]*lam;
z = who->z + vect[2]*lam;

dsum = 0.;

for( i=0; i< numatm; i++)
{
ap = a_next(i);
if( ap != who )
{



if( ap->vy > 0 )
{
/*
dsum += ap->vy*(ap->vx -dt)*(ap->vx -dt);
*/
dt = (x -ap->x)*(x-ap->x);
dt += (y -ap->y)*(y-ap->y);
dt += (z -ap->z)*(z-ap->z);

  if( dt > ap->vx) dsum += fabs(dt - ap->vx);
} else {
/*
if( ap->vx > dt)
dsum -= ap->vy*(ap->vx -dt)*(ap->vx -dt);
*/
dt = (x -ap->x)*(x-ap->x);
dt += (y -ap->y)*(y-ap->y);
dt += (z -ap->z)*(z-ap->z);

  if( dt < ap->vx) dsum += fabs(ap->vx - dt);

}

}
}
return dsum;
}/* end of routine */
