/* bfgs.c
*
*  bfgs optimizer for AMMP
*  this is a bit of a memory hog when running
*  maximum size depends on the memory available on the
*  machine
*
*
*
*/
/*
*  copyright 1992 Robert W. Harrison
*
*  This notice may not be removed
*  This program may be copied for scientific use
*  It may not be sold for profit without explicit
*  permission of the author(s) who retain any
*  commercial rights including the right to modify
*  this notice
*/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#  include <fastmath.h>
#else
#  include <math.h>
#endif

#include "ammp.h"


int AMMP_FASTCALL bfgs(AMMP_VFUNC vfs[], AMMP_FFUNC ffs[], int nfs, int nstep, float toler, int echo)
{
  AMMP_ATOM     *ap;
  AMMP_ATOM     *(*atms)[];
  int           Abort, i, j, n, n2;
  int           istep, iatm, cent;
  float         (*gamma)[];
  float         (*Hup)[];  /* space to be allocated for the matrix */
  float         dg, gh, hg, ghg, ddtconst, alpha;
  float         lastgh, vb;

  const char *  Routine    = "bfgs()";
  float         (*delta)[] = NULL;
  float         (*H)[]     = NULL;
  int           na         = a_number();

  const char *  StepStr    = "  Bfgs   %5d: vb %f, gh %f, alpha %f\n";
  float         lastvb     = 0.0f;

#ifdef VEGAZZ
  int           nupdat     = GetNupdat();
  int           supdat     = GetSupdat();

  alpha  = 0.0f;
  lastgh = 0.0f;
#endif

  if (!CheckAtoms()) return FALSE;
  if (nstep < 1) nstep = 1;

  if ((atms = Alloca(na * sizeof(AMMP_ATOM *), Routine)) == NULL)
    return FALSE;

  n  = na * 3;
  n2 = n  * n;

  if (((gamma = Alloca(n  * sizeof(float), Routine)) == NULL) ||
      ((delta = Alloca(n  * sizeof(float), Routine)) == NULL) ||
      ((H     = Alloca(n2 * sizeof(float), Routine)) == NULL) ||
      ((Hup   = Alloca(n2 * sizeof(float), Routine)) == NULL)) {
    free(atms);
    SafeFree(gamma);
    SafeFree(delta);
    SafeFree(H);
    printf("Bfgs        : Using Cngdel instead - sorry\n");
    return cngdel(vfs, ffs, nfs, nstep, nstep, toler, TRUE, nupdat);
  }

  /**** Initialize the atms array ****/

  ap = a_next(-1);
  for(i = 0; i < na; i++) {
    (*atms)[i] = ap;
    ap = ap -> next;
  } /* End of for (i) */

  /**** Initialize H to I (scaled by gradient squared) ****/

  for(i = 0; i < n2; i++) (*H)[i] = 0.0f;

  /**** Set up the gradient the forces are the negative gradient ****/

  a_f_zero();
  for(i = 0; i < nfs; i++) (*ffs[i])(0.0f);

  for(i = 0; i < na; i++) {
    (*atms)[i] -> fx *= -1.0f;
    (*atms)[i] -> fy *= -1.0f;
    (*atms)[i] -> fz *= -1.0f;
  } /* End of for (i) */

  gh = a_l2_f();
  gh = gh / (float)n / 2.0f + 1.0f;

  for(i = 0; i < n; i++) (*H)[n * i + i] = 1.0f / gh;

  /**** Main loop ****/

  Abort = FALSE;
  for(istep = 0; istep < nstep; istep++) {

#ifdef VEGAZZ
    if ((nupdat) && (!(istep % nupdat))) send_all_atoms();
#endif

    /*    dg = 0.; */
    /*    gh = 0.; */

    a_d_zero();

    /**** Loop over all of the atoms ****/

    for(iatm = 0; iatm < na; iatm++) {
      ap = (*atms)[iatm];
      (*gamma)[iatm * 3    ] = -ap -> fx;
      (*gamma)[iatm * 3 + 1] = -ap -> fy;
      (*gamma)[iatm * 3 + 2] = -ap -> fz;
      for(j = 0; j < na; j++) {
        cent = 3 * iatm * n + 3 * j;
        ap -> dx -= (*H)[cent    ] * (*atms)[j] -> fx +
		    (*H)[cent + 1] * (*atms)[j] -> fy +
                    (*H)[cent + 2] * (*atms)[j] -> fz;
        ap -> dy -= (*H)[cent + n    ] * (*atms)[j] -> fx +
                    (*H)[cent + n + 1] * (*atms)[j] -> fy +
		    (*H)[cent + n + 2] * (*atms)[j] -> fz;
        ap -> dz -= (*H)[cent + n + n    ] * (*atms)[j] -> fx +
		    (*H)[cent + n + n + 1] * (*atms)[j] -> fy +
		    (*H)[cent + n + n + 2] * (*atms)[j] -> fz;
      } /* End of for (j) */
    } /* End of for (iatm) */

    /**** Do the line search ****/

    gh    = a_l2_f() / na;
/*  alpha = linmin(vfs, nfs, 4.0f); */

    alpha = linmin(vfs, nfs, 1.0f);

#ifdef VEGAZZ
    if ((supdat) && (!(istep % supdat))) {
#else
    if (echo) {
#endif
      vb = 0.0f;
      for(i = 0; i < nfs; i++) (*vfs[i])(&vb, 0.0f);
      printf(StepStr, istep, vb, gh, alpha);
      if (vb == lastvb) {
        Abort = TRUE;
        break;
      }
      lastvb = vb;
    }
    lastgh = gh;

    if ((gh < (toler * toler)) || (gh < 1.e-7) || (alpha < 1.e-10))
      goto CLEANUP;

    a_inc_d(alpha);
    a_f_zero();

    for(i = 0; i < nfs; i++) (*ffs[i])(0.0f);
    for(i = 0; i < na; i++) {
      (*atms)[i]->fx *= -1.0f;
      (*atms)[i]->fy *= -1.0f;
      (*atms)[i]->fz *= -1.0f;
    } /* End of for (i) */


    /**** Make up delta grad ****/

    for(iatm = 0; iatm < na; iatm++) {
      ap = (*atms)[iatm];
      (*gamma)[iatm * 3    ] += ap -> fx;
      (*gamma)[iatm * 3 + 1] += ap -> fy;
      (*gamma)[iatm * 3 + 2] += ap -> fz;
      (*delta)[iatm * 3    ]  = alpha * ap -> dx;
      (*delta)[iatm * 3 + 1]  = alpha * ap -> dy;
      (*delta)[iatm * 3 + 2]  = alpha * ap -> dz;
    } /* End of for (iatm) */

    dg = 0.0f;
    ghg = 0.0f;
/*
    gh = 0.0f;
    hg = 0.0f;
    ddtconst = 0.0f;
*/

    for(i = 0; i < n2; i++) (*Hup)[i] = 0.0f;

    for(i = 0; i < n; i++) {
      dg += (*delta)[i] * (*gamma)[i];
      hg  = 0.0f;
      for(j = 0; j < n; j++)
        hg += (*H)[i * n + j] * (*gamma)[j];
      ghg += (*gamma)[i] * hg;
    } /* End of for (i) */

    if (dg < (1.e-6 * ghg)) goto CLEANUP;
    ddtconst = (1.0f + ghg / dg) / dg;

    for(i = 0; i < n; i++) {
      for(j = 0; j < n;j++)
        (*Hup)[i * n + j] += (*delta)[i] * (*delta)[j] * ddtconst;
    } /* End of for (i) */

    for(i = 0; i < n; i++) {
      gh = 0.0f;
      for(j = 0; j < n; j++)
        gh += (*gamma)[j] * (*H)[j * n + i];
      gh = -gh / dg;
      for(j = 0; j < n; j++)
        (*Hup)[j * n + i] += (*delta)[j] * gh;
    } /* End of for (i) */

    for(i = 0; i < n; i++) {
      hg = 0.0f;
      for(j = 0; j < n; j++)
        hg += (*gamma)[j] * (*H)[i * n + j];
      hg = -hg / dg;
      for(j = 0; j <n; j++)
        (*Hup)[i * n + j] += (*delta)[j] * hg;
    } /* End of for (i) */
  } /* End of for (istep) */

CLEANUP:

#ifdef VEGAZZ
  if ((supdat) && ((istep % supdat) || (istep == nstep))) {
    vb = 0.0f;
    for(i = 0; i < nfs; i++) (*vfs[i])(&vb, 0.0f);
    printf(StepStr, istep, vb, lastgh, alpha);
  }
#endif

  if (Abort)
    printf("  Bfgs        : Unable to converge. Minimization stopped\n");

#ifdef VEGAZZ
  if (supdat) printf("\n");
#else
  if (echo  ) printf("\n");
#endif

  free(H    );
  free(Hup  );
  free(delta);
  free(gamma);
  free(atms );

  return TRUE;
}


