/* clone.c
*  keep copies of the current coordinates
*  return one or an average to the working set
*  sort of does what tether does, but somewhat
*  more elegantly
*  clone
*  statclone
*  subclone
*
*  nnclone
*/
#include <stdio.h>
#include <stdlib.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#  include <fastmath.h>
#else
#  include <math.h>
#endif

#include "ammp.h"

/**** Macros ****/

#define  CLONG                  sizeof(CLONE)

/**** Local variables ****/

static int                      N_clones = 0;

#ifdef graphic
void force_screen_update();
#endif


/**** Clone ****/

CLONE * AMMP_FASTCALL Clone(CLONE *cp, int who)
{
  AMMP_ATOM *           ap;
  int                   i;
  float                 *x, *y, *z;
  char                  *active_flag;

  const char *          Routine = "clone()";
  int                   numatom = a_number();

  if (numatom < 1) return NULL;

  if (!cp)
    for(cp = clone_first; (cp) && (cp -> serial != who); cp = cp -> next);

  if (cp) {
    if (cp -> inme != numatom) {
      cp -> inme = 0;
      free(cp -> z);
      free(cp -> y);
      free(cp -> x);
      free(cp -> active_flag);
    }
  } else {
    if ((cp = (CLONE *)ListAdd((void **)&clone_first, (void **)&clone_last, sizeof(CLONE))) == NULL)
      return NULL;

    ++N_clones;
    cp -> inme   = 0;
    cp -> next   = NULL;
    cp -> serial = who;
  }

  if (!cp -> inme) {
    i = numatom * sizeof(float);
    if ((cp -> x = (float *)Alloca(i, Routine)) == NULL)
      return NULL;

    if ((cp -> y = (float *)Alloca(i, Routine)) == NULL) {
      free(cp -> x);
      return NULL;
    }

    if ((cp -> z = (float *)Alloca(i, Routine)) == NULL) {
      free(cp -> x);
      free(cp -> y);
      return NULL;
    }

    if ((cp -> active_flag = (char *)Alloca(numatom, Routine)) == NULL) {
      free(cp -> x);
      free(cp -> y);
      free(cp -> z);
      return NULL;
    }
    cp -> inme = numatom;
  }

  x           = cp -> x;
  y           = cp -> y;
  z           = cp -> z;
  active_flag = cp -> active_flag;

  /**** Copy the coordinates to the clone ****/

  ap = atomfirst;
  while(ap -> next) {
    *x++           = ap -> x;
    *y++           = ap -> y;
    *z++           = ap -> z;
    *active_flag++ = ap -> active;

    if(ap -> next == ap) break;
    ap = ap -> next;
  } /* End of while */

  return cp;
}


/**** Delete a clone ****/

int AMMP_FASTCALL CloneDel(CLONE *Cp, int Id)
{
  if (!Cp) {
    for(Cp = clone_first; (Cp) && (Cp -> serial != Id); Cp = Cp -> next);
    if (!Cp) return FALSE;
  }

  /**** Find the clone ****/

  CloneFree(Cp);
  ListRemove((void **)&clone_first, (void **)&clone_last, Cp);
  --N_clones;

  return TRUE;
}


/**** Free the clone resources ****/

void AMMP_FASTCALL CloneFree(CLONE *Cp)
{
  if (!Cp) return;
  if (Cp -> x          ) free(Cp -> x          );
  if (Cp -> y          ) free(Cp -> y          );
  if (Cp -> z          ) free(Cp -> z          );
  if (Cp -> active_flag) free(Cp -> active_flag);
}


/**** Restore from clone ****/

CLONE * AMMP_FASTCALL CloneRestore(CLONE *cp, int who)
{
  AMMP_ATOM *   ap;
  char *        active_flag;
  float         *x, *y, *z;
  int           j, a;

  if (!cp) {
    for(cp = clone_first; (cp) && (cp -> serial != who); cp = cp -> next);
    if (!cp) return NULL;
  }

  a           = a_number();
  x           = cp -> x;
  y           = cp -> y;
  z           = cp -> z;
  active_flag = cp -> active_flag;
  for(j = 0; j < a; j++) {
    ap = a_next(j);
	ap -> x      = *x++;
    ap -> y      = *y++;
    ap -> z      = *z++;
    ap -> active = *active_flag++;
  } /* End of for (j) */

  return cp;
}


/**** Reset the clone ****/

void AMMP_FASTCALL ResetClone(void)
{
  CLONE *       cp = clone_first;

  while(cp) {
    CloneFree(cp);
    cp = cp -> next;
  } /* End of while */
  ListFree((void **)&clone_first, (void **)&clone_last);

  clone_first = NULL;
  clone_last  = NULL;
  N_clones    = 0;
}



int AMMP_FASTCALL statclone(FILE *op)
{
  AMMP_ATOM *           ap;
  CLONE *               cp;
  int                   i, indx, j, numclone;
  float                 *x, *y, *z;
  float                 dx, dy, dz, dr;

  int                   numatom = a_number();

  if ((numatom < 1) || (clone_first == NULL)) return FALSE;

  cp = clone_first;
  i  = 0;

  while(TRUE) {
    ++i;
    if ((cp -> next == cp) || (cp -> next == NULL)) break;
    cp = cp -> next;
  } /* End of while */

  fprintf(op, " There are %d cloned coordinate sets\n", i);
  numclone = i;

  cp = clone_first ;
  for(j = 0; j < numclone; j++) {
    fprintf(op, " Clone %d label %d number of atoms %d",
                j + 1, cp -> serial, cp -> inme);
    indx = numatom;
    if (indx < cp -> inme) indx = cp -> inme;
    x  = cp -> x;
    y  = cp -> y;
    z  = cp -> z;
    dr = 0.0f;
    for(i = 0; i < indx; i++) {
      ap  = a_next(i);
      dx  = ap -> x - x[i];
      dy  = ap -> y - y[i];
      dz  = ap -> z - z[i];
      dr += dx * dx + dy * dy + dz * dz;
    } /* End of for (i) */
    fprintf(op," rms %f\n", sqrt(dr/indx) );
    cp = cp -> next;
  } /* End of for (j) */

  return TRUE;
}


int AMMP_FASTCALL subclone(FILE *op, int who[], int how_many)
{
  AMMP_ATOM *           ap;
  char *                act;
  CLONE *               cp;
  float                 matrix[3][3], delta[3];
  float                 *x, *y, *z;
  float                 *xa, *ya, *za;
  int                   i, j, k;

  const char *          Routine = "subclone()";
  int                   numatom = a_number();

  if ((numatom < 1) || (!clone_first)) return FALSE;

  /**** Check that the clone is valid ****/

  if (how_many > 0) {
    j = -1;
    for(cp = clone_first; cp; cp = cp -> next) {
      for(i = 0; i < how_many; i++)
        if (cp -> serial == who[i]) {
          j = 1;
          break;
        }
      if (j == 1) break;
    } /* End of for (cp) */

    if (j < 0) {
      aaerror("No valid clones");
      return FALSE;
    }
  }
  i = numatom * sizeof(float);
  if ((xa = (float *)Alloca(i, Routine)) == NULL)
    return FALSE;

  if ((ya = (float *)Alloca(i, Routine)) == NULL) {
    free(xa);
    return FALSE;
  }

  if ((za = (float *)Alloca(i, Routine)) == NULL) {
    free(xa);
    free(ya);
    return FALSE;
  }

  /**** Zero the atoms ****/

  for(i = 0; i < numatom; i++) {
    ap       = a_next(i);
    xa[i]    = ap -> x;
    ya[i]    = ap -> y;
    za[i]    = ap -> z;
    ap -> x  = 0.0f;
    ap -> y  = 0.0f;
    ap -> z  = 0.0f;
    ap -> dx = 0.0f;
  } /* End of for (i) */

  if (!how_many) {
    for(cp = clone_first; cp; cp = cp -> next) {
      x = cp -> x;
      y = cp -> y;
      z = cp -> z;
      j = numatom ;
      if (j < cp -> inme) j = cp -> inme;

      fprintf(op, "Clone %d %d atoms RMS %f\n", cp -> serial, j,
		  bstrot(xa, ya,za, x, y, z, j, matrix,delta));
      for(i = 0; i < j; i++) {
        ap       = a_next(i);
        ap -> x += matrix[0][0] * x[i] + matrix[1][0] * y[i] + matrix[2][0] * z[i];
        ap -> y += matrix[0][1] * x[i] + matrix[1][1] * y[i] + matrix[2][1] * z[i];
        ap -> z += matrix[0][2] * x[i] + matrix[1][2] * y[i] + matrix[2][2] * z[i];
        ap -> x += delta[0];
        ap -> y += delta[1];
        ap -> z += delta[2];
        ap -> dx += one;
      } /* End of for (i) */
    } /* End of for (cp) */
  } else {
    for(cp = clone_first; cp; cp = cp -> next) {
      x = cp -> x;
      y = cp -> y;
      z = cp -> z;
      for(k = 0; k < how_many; k++) {
        if (cp -> serial == who[k]) {
          j = numatom;
          if (j < cp->inme) j = cp->inme;
          for(i = 0; i < j; i++) {
            ap        = a_next(i);
	    ap -> x  += x[i];
	    ap -> y  += y[i];
	    ap -> z  += z[i];
	    ap -> dx += one;
          } /* End of for (i) */
        }
      } /* End of for (k) */
    } /* End of the for (cp) */
  }

  /**** Now average out the data ****/

  act = cp -> active_flag;
  for(i = 0; i < numatom; i++) {
    ap = a_next(i);
    if (ap -> dx > zero) ap -> dx = one / (ap -> dx);
    ap -> x      *= ap -> dx;
    ap -> y      *= ap -> dx;
    ap -> z      *= ap -> dx;
    ap -> active  = act[i];
  } /* End of for (i) */

#ifdef graphic
  force_screen_update();
#endif
  free(za);
  free(ya);
  free(xa);

  return TRUE;
}

int AMMP_FASTCALL nnclone(FILE *op, int who[], int how_many, float rmin, float rmax)
{
  AMMP_ATOM     *ap, *ap1;
  CLONE         *cp;
  CLONE         *(*cpa)[];
  float         *xp1, *yp1, *zp1;
  float         x, y, z, r;
  float         rup, rdown, rbar;
  float         kup, kdown;
  float         (*rtable)[];
  int           i, j, k, numatom;
  int           iatom, jatom;
  int           incpa;

printf("%d %d\n",how_many,who[0]);
numatom = a_number();
if( numatom < 1) return 0;
if( clone_first == NULL) return 0;

if( rmin == 0.) rmin = 4.; /* short distances are covalent */
if( rmax == 0.) rmax = rmin+rmin;
if( rmin > rmax) 
{   x = rmin; rmin = rmax; rmax = x;}
kup = get_f_variable("kup");
kdown = get_f_variable("kdown");
if( kup < 0.001) kup = 10.;
if( kdown < 0.001) kdown = 10.;

cpa = malloc( how_many* sizeof( CLONE *) );
incpa = 0;
/* first check that the clone is valid */
for( i=0; i< how_many; i++)
	(*cpa)[i] = NULL;

	if( how_many > 0)
	{
		j = -1;
		cp = clone_first;
		while(1==1)
		{
			for(i=0; i< how_many; i++)
			if( cp->serial == who[i])
				{j=1; break;}
			if( j == 1) break;
			if(cp->next == cp) break;
			if( cp->next == NULL) break;
			cp = cp->next;
		}
		if( j < 0){ free(cpa);
		aaerror("no valid Clones"); return 0;
		}
	} 
	cp = clone_first;
	while(1==1)
	{
			for( i=0; i< how_many; i++)
					if( cp->serial == who[i])
						(*cpa)[incpa++] = cp;
			if( cp->next == cp) break;
			if( incpa == how_many) break;
			if( cp->next == NULL) break;
			cp = cp->next;
	}
	if( incpa < 3)
	{ free(cpa);  aaerror(" too few clones for nn_clone");
	   return 0;
	   }
/* so now cpa stores the pointers to the clones 
* 
*  loop over all atom pairs and if the pairs of atoms
*  and build a table
*  of distances 
*/
/* the following approach is not memory access efficient
* and will thrash like hell
* fortunately you only need to do i once in a while
*/
rtable = malloc( incpa * sizeof( float ));
	ap = a_next(-1);
for( iatom = 0; iatom < numatom-1; iatom++)
{

	ap1 = ap->next;
	for( jatom = iatom +1; jatom < numatom; jatom++)
	{
	
	for( i=0; i< incpa; i++)
	{
		xp1 = (*cpa)[i]->x;
		yp1 = (*cpa)[i]->y;
		zp1 = (*cpa)[i]->z;

		x = xp1[iatom] - xp1[jatom];
		y = yp1[iatom] - yp1[jatom];
		z = zp1[iatom] - zp1[jatom];

		r = sqrt(x * x + y * y + z * z);
		(*rtable)[i] = r;
	}/* i */
/* now we need to analyze the table of radii
* and by majority vote extract rmin,r,rmax
*/
	k = incpa/4 ;
	for( i=0; i< incpa-1; i++)
		for( j=i; j< incpa; j++)
			if( (*rtable)[i] > (*rtable)[j])
			{   x = (*rtable)[i]; (*rtable)[i] = (*rtable)[j];
			(*rtable)[j] = x; }
/*
			for( i=0; i< incpa; i++)
				printf("%f ",(*rtable)[i]);
			printf("\n");
*/
			rup = (*rtable)[incpa -k];
			rdown = (*rtable)[k];
			rbar = 0.5*(rup+rdown);
			if( rbar >= rmin && rbar <= rmax)
			noel( ap->serial, ap1->serial,
			rbar, rbar-rdown,rup -rbar, kdown,kup);
	ap1 = ap1->next;
	}/* jatom */
	ap = ap->next;
}/* iatom */


#ifdef graphic
	force_screen_update();
#endif
	free( rtable);
	free(cpa);
return 0;
}

/* clone_average_distance(iat,jat min, radius, error)
*  iat, jat specify the atom pair
*  min is the minimum number of clones to use
*  radius is the maxium distance
*  error is the maximum deviation as a fraction o
*
*  return -1 if not allowed, or too few clones
*
*  return the average distance if ok
*/

float AMMP_FASTCALL clone_average_distance(int iat, int jat, int min, float radius, float error)
{
  CLONE *               cp;
  float                 *xp, *yp, *zp;
  float                 x, y, z, r;
  float                 rbar;
  int                   i;

/*
  float                 r2bar = 0.0f;
*/

  if( N_clones < min) return -1.0f;

  cp   = clone_first;
  rbar = 0.0f;

  for(i = 0; i < N_clones; i++) {
    xp    = cp -> x;
    yp    = cp -> y;
    zp    = cp -> z;
    x     = xp[iat] - xp[jat];
    y     = yp[iat] - yp[jat];
    z     = zp[iat] - zp[jat];
    r     = x * x + y * y + z * z;
    rbar += r;

/*
    r2bar += r*r;
*/

    cp = cp -> next;
  } /* End of for (i) */

  rbar = rbar / N_clones;
  if (rbar > radius) return -1.0f;
/*
  r2bar = r2bar/N_clones - rbar*rbar;
  printf("%f %f\n", rbar,r2bar);
  if (r2bar > error*error*rbar*rbar) return -1.;
*/

  return rbar;
}

