
/*************************************************
****   AMMP - Common routines for non-bonds   ****
**** Copyright 2006-2012, Alessandro Pedretti ****
*************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#  include <fastmath.h>
#else
#  include <math.h>
#endif

#include "ammp.h"

/**** Global variables ****/

AMMP_ATOM **    NbAtomAll    = NULL;
AMMP_MMATOM *   NbAtomList   = NULL;
float *         NbRadius     = NULL;
float *         NbVector     = NULL;
int             NbAtomAllNum = 0;
int *           NbIndexes    = NULL;


/**** Alloc the non-bond table ****/

int AMMP_FASTCALL NonBondAllocTable(register int Atoms, int Type)
{
  register int          i;

  const char *          Routine = "NonBondAllocTable()";

  NonBondFreeTable();
  if (((NbAtomAll = (AMMP_ATOM **)Alloca(Atoms * sizeof(AMMP_ATOM *), Routine)) == NULL) ||
      ((NbVector  = (float *)Alloca(((Type == AMMP_NBTABLE_SHADOW) ? 5 : 4) * Atoms * sizeof(float), Routine)) == NULL) ||
      ((NbIndexes = (int *)Alloca(Atoms * sizeof(int), Routine)) == NULL)) {
    NonBondFreeTable();
    return FALSE;
  }

  for(i = 0; i < Atoms; i++) NbAtomAll[i] = a_next(i);
  NbAtomAllNum = Atoms;

  switch(Type) {
  case AMMP_NBTABLE_REACT:
    if ((NbRadius = (float *)Alloca(Atoms * sizeof(float), Routine)) == NULL) {
      NonBondFreeTable();
      return FALSE;
    }
    break;

  case AMMP_NBTABLE_RECTMM:
    if ((NbAtomList = (AMMP_MMATOM *)Alloca(Atoms * sizeof(AMMP_MMATOM), Routine)) == NULL) {
      NonBondFreeTable();
      return FALSE;
    }
    for(i = 0; i < Atoms; i++) NbAtomList[i].who = NbAtomAll[i];
    break;
  } /* End of switch */

  return TRUE;
}


/**** Check the atom movement ****/

int AMMP_FASTCALL NonBondCheck(register float mxdq, register float lambda)
{
  register AMMP_ATOM *  a1;
  register float        r, t;
  register int          ii;

  if (lambda) {
    for(ii = 0; ii < NbAtomAllNum; ii++) {
      a1 = NbAtomAll[ii];
      r  = a1 -> dx * lambda + a1 -> x - a1 -> px;
      r *= r;
      t  = a1 -> dy * lambda + a1 -> y - a1 -> py;
      r += t * t;
      t  = a1 -> dz * lambda + a1 -> z - a1 -> pz;
      r += t * t;
      if (r > mxdq) return FALSE;
    } /* End of for (ii) */
  } else {
    for(ii = 0; ii < NbAtomAllNum; ii++) {
      a1 = NbAtomAll[ii];
      r  = a1 -> x - a1 -> px;
      r *= r;
      t  = a1 -> y - a1 -> py;
      r += t * t;
      t  = a1 -> z - a1 -> pz;
      r += t * t;
      if (r > mxdq) return FALSE;
    } /* End of for (ii) */
  }

  return TRUE;
}


/**** Free the non-bond table ****/

void AMMP_FASTCALL NonBondFreeTable(void)
{
  SafeFree(NbAtomAll);
  SafeFree(NbIndexes);
  SafeFree(NbVector);
  NbAtomAll    = NULL;
  NbAtomAllNum = 0;
  NbIndexes    = NULL;
  NbVector     = NULL;
}

