
#ifdef __BORLANDC__
#  pragma hdrstop
#  include <fastmath.h>
#else
#  include <math.h>
#endif

#include "ammp.h"

/* concatview makes the r1.rout product
*  for  xview = rout x ( rout is last left concat)
* and graham-scmidts it to be
* an orthogonal matrix
*/

int AMMP_FASTCALL concatview(float r1[3][3], float rout[3][3])
{
  float         rs[3][3], a, b, c;
  int           i, j, k;

for( i=0; i< 3; i++)
for( j = 0; j<3; j++)
{
rs[i][j] = 0.;
for( k=0; k<3; k++)
rs[i][j] += r1[i][k]*rout[k][j];
}

/* now orthogonalize */
/* normalize the first row */
 a = rs[0][0]*rs[0][0] + rs[1][0]*rs[1][0] + rs[2][0]*rs[2][0];
 c = 1./sqrt(a);
 rs[0][0]*=c; rs[1][0] *= c; rs[2][0] *= c;
for( i=0; i<2; i++)
{
a = rs[0][i]*rs[0][i] + rs[1][i]*rs[1][i] + rs[2][i]*rs[2][i];
for( j=i+1; j< 3; j++)
{
b = rs[0][j]*rs[0][j] + rs[1][j]*rs[1][j] + rs[2][j]*rs[2][j];
c = rs[0][j]*rs[0][i] + rs[1][j]*rs[1][i] + rs[2][j]*rs[2][i];
c = c/ sqrt(a*b);
rs[0][j] -= c*rs[0][i]; rs[1][j] -= c*rs[1][i]; rs[2][j] -= c*rs[2][i];
b = rs[0][j]*rs[0][j] + rs[1][j]*rs[1][j] + rs[2][j]*rs[2][j];
c = 1./sqrt(b);
rs[0][j] *= c; rs[1][j] *= c; rs[0][j] *= c;
}/* j */
}/* i */
rout[0][0] = rs[0][0];
rout[0][1] = rs[0][1];
rout[0][2] = rs[0][2];
rout[1][0] = rs[1][0];
rout[1][1] = rs[1][1];
rout[1][2] = rs[1][2];
rout[2][0] = rs[2][0];
rout[2][1] = rs[2][1];
rout[2][2] = rs[2][2];

}/* end of concatview */
