/* dgeom()
* power method implementation of more or less cannonical
* distance geometry
*
*  One more attempt at distance geometry
*
*  actually build the matrices
*  randomized start
*   use a^2 + b ^2 -c^2 > 0 to adjust the a,b radii (this is not right)
*
*  include inactive atoms
*  superimpose at the end
*
*
*
*/
/*
*  copyright 1993,1994,1995 Robert W. Harrison
*
*  This notice may not be removed
*  This program may be copied for scientific use
*  It may not be sold for profit without explicit
*  permission of the author(s) who retain any
*  commercial rights including the right to modify
*  this notice
*/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#  include <fastmath.h>
#else
#  include <math.h>
#endif

#include "ammp.h"

void AMMP_FASTCALL dgeom(FILE *op, AMMP_VFUNC vfs[], int nfs, int niter, int origin, float eigshift, int echo)
{
  AMMP_ATOM     *ap, *bp, *aorig;
  float         *dist, *vect;
  float         x, y, z, xo, yo, zo;
  int           numatom;
  int           iter, i, j;
  AMMP_FFUNC    lffs[3];
  AMMP_VFUNC    lfs[3];
  int           nlfs;

  const char *  Routine = "dgeom()";
  const char *  StepStr = "  Dgeom  %5d: Top five eigenvalues %.4f %.4f %.4f %.4f %.4f\n";
  float *       dot     = NULL;
#ifdef VEGAZZ
  int           nupdat  = GetNupdat();
  int           supdat  = GetSupdat();
#endif

  if (!CheckAtoms()) return;

  numatom = a_number();
  lfs[0]  = v_bond;
  lfs[1]  = v_angle;
  lffs[0] = f_bond;
  lffs[1] = f_angle;
  nlfs    = 2;
  for(i = 0; i < nfs; i++) {
    if (vfs[i] == v_noel) {
      nlfs    = 3;
      lfs[2]  = v_noel;
      lffs[2] = f_noel;
    }
  } /* End of for (i) */

  i = numatom * numatom * sizeof(float);
  if (((dist = (float *)Alloca(i, Routine)) == NULL) ||
      ((dot  = (float *)Alloca(i, Routine)) == NULL) ||
      ((vect = (float *)Alloca(i, Routine)) == NULL)) {
    if (dist) free(dist);
    if (dot ) free(dot );
    return;
  }


  aorig = a_m_serial( origin);
  if (!aorig) aorig = a_next(-1);

  /* first build the theoretical distance tree */
  /* use bond, angle, noel for free atoms (at least one free)*/
  /* use the current distance for inactive atoms */
  /* note we store the squares */

  for(i = 0; i< numatom * numatom; i++) dist[i] = 0.0f;
  ap = a_next(-1);
  for(i = 0; i < (numatom - 1); i++) {

    /* follow the bond links */
    /* angles are done with gsdg angle and stored in ap->vx as the
    * square */

    for(iter = 0; iter < nfs; iter++) {
      for(j = 0; j < numatom; j++) {
        bp       = a_next(j);
        bp -> vx = 0.0f;
      }
      if (vfs[iter] == v_bond ) gsdg_bond(ap);
      if (vfs[iter] == v_angle) gsdg_angle(ap);
      if (vfs[iter] == v_noel ) gsdg_noel(ap);
      for(j = 0; j <numatom; j++) {
        bp = a_next(j);
        if (bp -> vx > 0.0f) {
          x = bp -> vx;
          dist[i * numatom + j] = x;
          dist[j * numatom + i] = x;
        }
      } /* End of for (j) */
    } /* End of for (iter) */

    /* finally overwrite anyone with exact distances from the
     * inactive atoms
     */

     bp = ap;
     for(j = i + 1; j< numatom; j++) {
       bp = bp -> next; /* now points to the i+1, .... atoms */
       if ((!ap -> active) && (!bp -> active)) {
         x = ap -> x - bp -> x;
         y = ap -> y - bp -> y;
         z = ap -> z - bp -> z;
         dist[i * numatom + j] = x*x + y*y + z*z;
         dist[j * numatom + i] = x*x + y*y + z*z;
       }
     }
    ap = ap->next;
  }

  /* now we interate the solutions */
  /*
  for( i=0; i<numatom; i++)
  { (*xv)[i] = 2.*randf()-1.; (*yv)[i] = 2.*randf()-1.; (*zv)[i] = 2.*randf()-1.;}

  dgeom_ortho(numatom,&x,&y,&z,xv,yv,zv);
  */

  for(iter = 0; iter < niter; iter++) {
    for(i = 0; i < (numatom * numatom); i++) dot[i] = 0.0f;

    /* build the dot product matrix */

    xo = aorig -> x;
    yo = aorig -> y;
    zo = aorig -> z;

    for(i = 0; i < numatom; i++) { /* diagonal initial values */
      ap = a_next(i);
      x  = ap -> x - xo;
      y  = ap -> y - yo;
      z  = ap -> z - zo;
      dot[i * numatom + i] = x*x + y*y + z*z;
    }
/*	for( i=0; i< numatom; i++)
	{ printf("\n");
	for( j=0; j< numatom; j++)
		printf("%f ",(*dot)[i*numatom+j]);
	}
*/

/* now working out from the first atom build the
*  dot product using the law of cosines
*   c^2 = a^2 + b^2 - 2ab cos(theta)
*    or
*  dot_product =  0.5*( -c^2 + a^2 + b^2)
*  when this is negative (i.e. c^2 >> a^2 + b^2)
*   update b^2 and recalculate all b terms  (actually will do this
*   by calculating all of each row and updating the relevant columns)
*/

    ap = a_next(-1);
    for( i=0; i< numatom; i++) {
      x  = dot[i * numatom + i];
      bp = a_next(-1);
      for(j = 0; j < numatom; j++) {
        if (j != i ) {
          y = dot[j * numatom + j ];
          if (dist[i * numatom + j] > 0.0f) {
            zo = dist[i * numatom + j];
          } else {
            xo = bp -> x - ap -> x;
	    yo = bp -> y - ap -> y;
	    zo = bp -> z - ap -> z;
            zo = xo * xo + yo * yo + zo * zo;
            if (zo < 9) zo = 9;
          }
          z = x + y - zo;
          dot[i * numatom + j] = 0.5f * z;
	} /* j != i */
	bp = bp -> next;
      }
      ap = ap -> next;
    } /* End of for (i) */

    /* Now use forward iteration to find the three largest
     *  eigen vectors */
/*	for( i=0; i< numatom; i++)
	{ printf("\n");
	for( j=0; j< numatom; j++)
		printf("%f ",(*dot)[i*numatom+j]);
	}

	for( i=0; i< numatom; i++)
	{ printf("\n");
	for( j=0; j< numatom; j++)
		printf("%f ",(*dist)[i*numatom+j]);
	}

*/
	/*
		for( k=0; k< 100;k++)
		{
			for( i=0; i< numatom; i++)
			{x = 0.; y = 0.; z= 0.;
			for( j=0; j< numatom; j++)
			{
				x += (*dot)[i*numatom+j]*(*xv)[j];
				y += (*dot)[i*numatom+j]*(*yv)[j];
				z += (*dot)[i*numatom+j]*(*zv)[j];

			}
			(*xn)[i] = x ;
			(*yn)[i] = y ;
			(*zn)[i] = z ;
			}

		x = 0.; y = 0.; z = 0.;
		for( i=0; i< numatom ; i++)
		{ x+= (*xn)[i]; y+= (*yn)[i]; z += (*zn)[i];
		}
		x /= numatom; y /= numatom ; z /= numatom;
		for( i=0; i< numatom; i++)
		{
			(*xv)[i] = (*xn)[i] -x;
			(*yv)[i] = (*yn)[i] -y;
			(*zv)[i] = (*zn)[i] -z;
		}
		dgeom_ortho(numatom,&x,&y,&z,*xv,*yv,*zv);
	//	printf("eigenvalues %f %f %f \n",x,y,z);
		}
	*/

    /**** For a test we'll call jacobi ****/

    j = jacobi(dot, vect, numatom, 10000 * numatom * numatom, 1e-10);
    if (j == 1) {
      fprintf(op, "  Dgeom       : Jacobi returns an error\n");
      break;
    } else {
#ifdef VEGAZZ
      if ((supdat) && (!(iter % supdat)))
#else
      if (echo)
#endif
        fprintf(op, StepStr,
                iter, dot[0], dot[numatom + 1], dot[numatom * 2 + 2],
	        dot[numatom * 3 + 3],  dot[numatom * 4 + 4]);
      x = dot[0];
      y = dot[numatom + 1];
      z = dot[numatom * 2 + 2];
      for(i = 0; i < numatom; i++) {
        ap = a_next(i);
	ap -> dx = vect[numatom * i    ] * sqrt(x);
	ap -> dy = vect[numatom * i + 1] * sqrt(y);
	ap -> dz = vect[numatom * i + 2] * sqrt(z);
      }
      dgeom_update(op, numatom, echo);
      kohonen_minimizer(lfs, lffs, nlfs, 10);

#ifdef VEGAZZ
      if ((nupdat) && (!(iter % nupdat))) send_all_atoms();
#endif

#ifdef WINDOWS
      force_screen_update();
#endif

#ifdef GRAMMP
      send_all_atoms();
#endif
    }
  } /* End of for (iter) */
#ifdef VEGAZZ
  if ((supdat) && ((iter % supdat) || (iter == niter)))
    fprintf(op, StepStr,
            iter, dot[0], dot[numatom + 1], dot[numatom * 2 + 2],
            dot[numatom * 3 + 3],  dot[numatom * 4 + 4]);
#else
  if (echo)
#endif
    printf("\n");

  free(vect);
  free(dot);
  free(dist);
}


/**** Ortho normalize x, y, z; return eigenvalues in a, b, c ****/

void AMMP_FASTCALL dgeom_ortho(int numatm, float *a, float *b, float *c, float x[], float y[], float z[])
{
  AMMP_ATOM *   ap;
  int           i;

  float         dot1 = 0.0f;
  float         dot2 = 0.0f;
  float         m1   = 0.0f;
  float         m2   = 0.0f;
  float         n1   = 0.0f;
  float         n2   = 0.0f;
  float         n3   = 0.0f;

  for(i = 0; i < numatm; i++) {
    dot1 += x[i] * y[i];
    dot2 += x[i] * z[i];
    n1   += x[i] * x[i];
    n2   += y[i] * y[i];
    n3   += z[i] * z[i];
  } /* End of for (i) */

  *a = sqrt(n1);
  if (n1 > 1.0e-8f) {
    if (n2 > 1.0e-8f) m1 = -dot1 / sqrt(n1 * n2);
    if (n3 > 1.0e-8f) m2 = -dot2 / sqrt(n1 * n3);
    n1 = 1.0f / *a;
  }

  dot2 = 0.0f;
  n2   = 0.0f;
  n3   = 0.0f;
  for(i = 0; i < numatm; i++) {
    y[i] += m1 * x[i];
    z[i] += m2 * x[i];
    x[i] *= n1;
    dot2 += y[i] * z[i];
    n2   += y[i] * y[i];
    n3   += z[i] * z[i];
  } /* End of for (i) */

  *b = sqrt(n2);
  if (n2 > 1.0e-8f) {
    if (n3 > 1.0e-8f) m2 = dot2 / sqrt(n2 * n3);
    n2 = 1.0f / *b;
  }


  n3 = 0.0f;
  for(i = 0; i < numatm; i++) {
    z[i] -= m2 * y[i];
    y[i] *= n2;
    n3   += z[i] * z[i];
  } /* End of for (i) */

  *c = sqrt(n3);
  if (n3 < 1.0e-8f) n3 = 0.0f;
  else n3 = 1.0f / *c;

  for(i = 0; i < numatm; i++) z[i] *= n3;

  /**** Finally put it in dx, dy, dz to use the update routine ****/

  n1 = sqrt(*a) ;
  n2 = sqrt(*b);
  n3 = sqrt(*c);
  for(i =0; i < numatm; i++) {
    ap       = a_next(i);
    ap -> dx = x[i] * n1;
    ap -> dy = y[i] * n2;
    ap -> dz = z[i] * n3;
  } /* End of for (i) */
}


/**** Update the structure if it's needed ****/

void AMMP_FASTCALL dgeom_update(FILE *op, int numatm, int echo)
{
  AMMP_ATOM *           ap;
  float                 matrix[12][12], vector[12];
  float                 x, y, z, dx, dy, dz;
  int                   i, j, ifixed;


  if (numatm < 1) return;

  for(i = 0; i < 12; i++) {
    vector[i] = 0.0f;
    for(j = 0; j < 12; j++)
      matrix[j][i] = 0.0f;
  } /* End of for (i) */

  ifixed = 0;
  for(i = 0; i < numatm; i++) {
    ap = a_next(i);
    if (!ap -> active) {
      ifixed++;
      dx              = ap -> dx;
      dy              = ap -> dy;
      dz              = ap -> dz;
      x               = ap -> x;
      y               = ap -> y;
      z               = ap -> z;

      matrix[0 ][0 ] += dx * dx;
      matrix[0 ][1 ] += dx * dy;
      matrix[0 ][2 ] += dx * dz;
      matrix[1 ][1 ] += dy * dy;
      matrix[1 ][2 ] += dy * dz;
      matrix[2 ][2 ] += dz * dz;
      matrix[0 ][9 ] += dx;
      matrix[1 ][10] += dy;
      matrix[2 ][11] += dz;
      matrix[9 ][9 ] += 1.0f;
      matrix[10][10] += 1.0f;
      matrix[11][11] += 1.0f;

      vector[0 ]     += x * dx;
      vector[1 ]     += x * dy;
      vector[2 ]     += x * dz;
      vector[3 ]     += y * dx;
      vector[4 ]     += y * dy;
      vector[5 ]     += y * dz;
      vector[6 ]     += z * dx;
      vector[7 ]     += z * dy;
      vector[8 ]     += z * dz;
      vector[9 ]     += x;
      vector[10]     += y;
      vector[11]     += z;
    }
  } /* End of for (i) */

  /**** Build the full matrix ****/

  if (ifixed > 3) {
    matrix[1][0] = matrix[0][1];
    matrix[2][0] = matrix[0][2];
    matrix[2][1] = matrix[1][2];
    for(j = 0; j < 3; j++)
      for(i = 0; i < 3; i++) {
        matrix[j + 3][i + 3] = matrix[j][i];
        matrix[j + 6][i + 6] = matrix[j][i];
      } /* End of for (i) */

    matrix[9 ][0 ] = matrix[0][9 ];
    matrix[10][1 ] = matrix[1][10];
    matrix[11][2 ] = matrix[2][11];
    matrix[9 ][3 ] = matrix[0][9 ];
    matrix[10][4 ] = matrix[1][10];
    matrix[11][5 ] = matrix[2][11];
    matrix[9 ][6 ] = matrix[0][9 ];
    matrix[10][7 ] = matrix[1][10];
    matrix[11][8 ] = matrix[2][11];
    matrix[3 ][9 ] = matrix[0][9 ];
    matrix[4 ][10] = matrix[1][10];
    matrix[5 ][11] = matrix[2][11];
    matrix[6 ][9 ] = matrix[0][9 ];
    matrix[7 ][10] = matrix[1][10];
    matrix[8 ][11] = matrix[2][11];

    mom_solve((float (*)[])matrix, (float (*)[])vector, 12, 12);
  } else {
    vector[0 ] = 1.0f;
    vector[1 ] = 0.0f;
    vector[2 ] = 0.0f;
    vector[3 ] = 0.0f;
    vector[4 ] = 1.0f;
    vector[5 ] = 0.0f;
    vector[6 ] = 0.0f;
    vector[7 ] = 0.0f;
    vector[8 ] = 1.0f;
    vector[9 ] = 0.0f;
    vector[10] = 0.0f;
    vector[11] = 0.0f;
  }

  dx = 0.0f;
  for(i = 0; i < numatm; i++) {
    ap = a_next(i);
    if (ap -> active) {
      ap -> x = vector[0] * ap -> dx + vector[1] * ap -> dy + vector[2] * ap -> dz + vector[9 ];
      ap -> y = vector[3] * ap -> dx + vector[4] * ap -> dy + vector[5] * ap -> dz + vector[10];
      ap -> z = vector[6] * ap -> dx + vector[7] * ap -> dy + vector[8] * ap -> dz + vector[11];
    } else {
      x  = vector[0] * ap -> dx + vector[1] * ap -> dy + vector[2] * ap -> dz + vector[9 ];
      y  = vector[3] * ap -> dx + vector[4] * ap -> dy + vector[5] * ap -> dz + vector[10];
      z  = vector[6] * ap -> dx + vector[7] * ap -> dy + vector[8] * ap -> dz + vector[11];
      x -= ap -> x;
      y -= ap -> y;
      z -= ap -> z;
      dx += x * x + y * y + z * z;
    }
  } /* End of for (i) */

  if (ifixed > 0) {
#ifndef VEGAZZ
    if (echo)
#endif
      fprintf(op, "  Dgeom       : Superposition error %f\n", dx / ifixed);
  }
}
