/* dipole.c
*
* calculate the dipole moment for a given range of atoms
*/
/*
*  copyright 1992 Robert W. Harrison
*
*  This notice may not be removed
*  This program may be copied for scientific use
*  It may not be sold for profit without explicit
*  permission of the author(s) who retain any
*  commercial rights including the right to modify
*  this notice
*/

#include <stdio.h>
#include <ctype.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#  include <fastmath.h>
#else
#  include <math.h>
#endif

#include "ammp.h"


void AMMP_FASTCALL dipole(FILE *op, int first, int last)
{
  AMMP_ATOM *   ap;
  double        x, y, z, sumq;
  int           i, sum;

  if (!CheckAtoms()) return;

  /**** Check the parameters ****/

  sum = a_number();
  if (last <= 0) {
    for(i = 0; i < sum; i++) {
      ap = a_next(i);
      if (last < ap -> serial) last = ap -> serial;
    } /* End of for (i) */
  }

  if (last < first) {
    i     = last;
    last  = first;
    first = i;
  }
  if (!first) first = 1;

  x    = 0.0;
  y    = 0.0;
  z    = 0.0;
  sumq = 0.0;
  sum  = 0;

  for(i = first; i <= last; i++) {
    ap = a_m_serial(i);
    if (ap != NULL) {
      x    += (double)ap -> x * (double)ap -> q;
      y    += (double)ap -> y * (double)ap -> q;
      z    += (double)ap -> z * (double)ap -> q;
      sumq += (double)ap -> q;
      ++sum;
    }
  } /* End of for (i) */

  if (sum == 0) {
    fprintf(op, "Dipole warning, no atoms in %d %d\n", first, last);
    return;
  }

  /**** Check that a dipole exists ****/

  if (fabs(sumq) > 1.e-5) {
    fprintf(op, "Dipole warning, %d %d sum charge is not zero %f\n", first, last, sumq);
    sumq = 1.0 / (double)sum;
    x *= sumq;
    y *= sumq;
    z *= sumq;
    fprintf(op, "Dipole %d %d center of charge is %f %f %f\n", first, last, x, y, z);
    return;
  }

  /**** Finally we have a dipole that is real ****/

  sumq = sqrt(x*x + y*y + z*z);
  fprintf(op, "Dipole %d %d moment %f vector %f %f %f\n", first, last, sumq, x, y, z);
}

