#include "dsc.h"

/*****************************************************************************
 * dscExec() - Start X Windows Application.  If there are "events" in the    *
 *             queue, then grab next event and send it to dscDispatchEvent.  *
 *             If no events, then execute IdleFunc (if defined)              *
 *****************************************************************************/
void dscExec(XtAppContext App)
{
	XEvent event;

	while (TRUE)
	{
		if (XtAppPending(App))
		{
			XtAppNextEvent(App,&event);
			dscDispatchEvent(&event);
		}	
		else  { if (IdleFunc)  (*IdleFunc)(); }
	}
}


/*****************************************************************************
 * dscDispatchEvent() - if MouseMoveFunc is defined then send it a copy of   *
 *                      the "event" and then call XtDispatch to handle the   *
 *                      event                                                *
 *****************************************************************************/
void dscDispatchEvent(XEvent *event)
{
	if (MouseMoveFunc)
		(*MouseMoveFunc)(event);
	XtDispatchEvent(event);
}


/*****************************************************************************
 * dscMouseMoveFunc() - Define mouse move function for dscExec               *
 *****************************************************************************/
void dscMouseMoveFunc(void (*func)(XEvent *)) 
{ 
	MouseMoveFunc = func; 
	LEFT_BUTTON_DOWN = FALSE;
}

/*****************************************************************************
 * dscIdleFunc() - Define idle function for dscExec                          *
 *****************************************************************************/
void dscIdleFunc(void (*func)(void)) { IdleFunc = func; }


/*****************************************************************************
 * dscSystem() - Similar to system() but it does not wait for this process to
 *               return (actually closer to exec than system).
 *****************************************************************************/
int dscSystem(char *command) {
   int pid;
   char *argv[4];

   if (command == 0)  return (1);
   pid = fork();
   if (pid == -1)  return (-1);
   if (pid == 0) 
   {
	   argv[0] = "sh";
	   argv[1] = "-c";
	   argv[2] = command;
	   argv[3] = 0; 
	   execv("/bin/sh", argv);
	   exit(127);
   }
}


/*****************************************************************************
 * dscDestroyWidget
 *****************************************************************************/
void dscDestroyWidget(Widget parent, Widget target, XtPointer dummy)
{
	XtUnmanageChild(target);
}
