/* direct scf calculation routines
*
*/
/*
*  copyright 1993,1994,1995 Robert W. Harrison
*
*  This notice may not be removed
*  This program may be copied for scientific use
*  It may not be sold for profit without explicit
*  permission of the author(s) who retain any
*  commercial rights including the right to modify
*  this notice
*/

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#  include <fastmath.h>
#else
#  include <math.h>
#endif

#include "ammp.h"
#include "orbit.h"

#define MAXPARAM 2000

void AMMP_FASTCALL direct_scf(FILE *output, int nstep , float toler, char *what)
{
  AMMP_ATOM *   ap;
  char          whattotry;
  float *       addresses[MAXPARAM];
  AMMP_OFUNC    touse, forgrad;
  float         ecurrent, enew;
  float         initstep;
  int           inparam, no;
  int           iter, i, j;
  ORBITAL       *op, *op1;

  no = o_number();
  if( no <= 0 ) return ;

	whattotry = 0; /* just do coefficients */
	if( what != NULL && *what != '\0' )
	{
	if ( strncmp( what,"coef",4)  == 0 ) whattotry = 0;  /* coefficients */
	if ( strncmp( what,"expo",4)  == 0 ) whattotry = 1;  /* exponents */
	if ( strncmp( what,"xyz",3)   == 0 ) whattotry = 2; /* atomic centers */
	if ( strncmp( what,"geom",4)  == 0 ) whattotry = 3; /*orbital geometry*/
	if ( strncmp( what,"ana",3)  == 0 ) whattotry = 4; /* just report */
	if ( strncmp( what,"fre",3)  == 0 ) whattotry = 5; /* freeze */
	if ( strncmp( what,"tha",3)  == 0 ) whattotry = 6; /* thaw */
	if ( strncmp( what,"gan",3)  == 0 ) whattotry = 7; /* gang together */
	if ( strncmp( what,"poli",4) == 0 ) whattotry = 8;
	if ( strncmp( what,"edmap",3) == 0 ) whattotry = 9;
	if ( strncmp( what,"phimap",3) == 0 ) whattotry = 10;
	if ( strncmp( what,"empir",3) == 0 ) whattotry = 11;
	if ( strncmp( what,"charge",3) == 0 ) whattotry = 12;
	if ( strncmp( what,"indo",3) == 0 ) whattotry = 13;
	if ( strncmp( what,"igeom",3) == 0 ) whattotry = 14;
	if ( strncmp( what,"ipoli",3) == 0 ) whattotry = 15;
	}

/* now inside of krymin
	for( iter=0; iter< nstep; iter++)
*/
	for( iter=0; iter< 1;iter++)
	{
	op = o_next(-1);
	inparam = 0;
	for( i=0; i< no; i++)
	{

	o_update_normals();
	renormalize();
	switch( whattotry )
	{
	case 0:
	if( !op->active) goto SKIP;
	if( op->gang != NULL) goto SKIP;
	for(j=1; j< op->n; j++)
	{
		addresses[inparam+j-1] = &(op->a[j]);
	}
	inparam += op->n-1;
	touse    = Loose_Ritz_product;
	forgrad  = Loose_Ritz_product;
//	initstep = 1.;
	break;
	case 1:
	if( !op->active) goto SKIP;
	if( op->gang != NULL) goto SKIP;
	for(j=0; j< op->n; j++)
	{
		addresses[inparam+j] = &(op->rl[j]);
	}
	inparam += op->n;
	for(j=1; j< op->n; j++)
	{
		addresses[inparam+j-1] = &(op->a[j]);
	}
	inparam += op->n-1;
	forgrad  = Loose_Ritz_product;
	touse    = Loose_Ritz_product;
//	initstep = 0.1f;
	break;
	case 2:
/*	if( !op->active) goto SKIP;
*/
		ap = op->myatom;
	if( ap->active ){
		addresses[inparam] = &(ap->x);
		addresses[inparam+1] = &(ap->y);
		addresses[inparam+2] = &(ap->z);
		inparam += 3;
	if( op->gang == NULL){
	for(j=0; j< op->n; j++)
	{
		addresses[inparam+j] = &(op->rl[j]);
	}
	inparam += op->n;
	for(j=1; j< op->n; j++)
	{
		addresses[inparam+j-1] = &(op->a[j]);
	}
	inparam += op->n-1;
			}
//		initstep = .01;
		}
	touse   = Ritz_product;
	forgrad = tight_INDO_Ritz_product;
	break;
	case 3:
	if( !op->active) goto SKIP;
	if( op->gang != NULL) goto SKIP;
/*	touse   = Ritz_product; */
	forgrad = INDO_Ritz_product;
        touse   = Loose_Ritz_product;

/* just the orbital x,y,z
	if( op->gang == NULL){
	for(j=0; j< op->n; j++)
	{
		addresses[inparam+j] = &(op->rl[j]);
	}
	inparam += op->n;
	for(j=1; j< op->n; j++)
	{
		addresses[inparam+j-1] = &(op->a[j]);
	}
	inparam += op->n-1;
				}
*/
	switch( op->type )
	{
	case Or1:
  	        goto SKIP;
	case Or1o:
		addresses[inparam] = &op->x;
		addresses[inparam+1] = &op->y;
		addresses[inparam+2] = &op->z;
		inparam += 3;
//		initstep = .01;
	break;
	case Or2:
		addresses[inparam] = &op->along;
		inparam += 1;
//		initstep = .01;
	break;
	case Or3:
		addresses[inparam] = &op->along;
		addresses[inparam+1] = &op->along2;
		inparam += 2;
//		initstep = .01;
	break;
	case Or4p:
	case Or4s:
		addresses[inparam] = &op->along;
		inparam += 1;
//		initstep = .01;
	break;
	case Orm:
	        goto SKIP;
	}
	break;
	case 4:
	o_update_normals();
	renormalize();
	Ritz_product(op);
	report(output);
	return;
	case 5:
		op = o_m_serial(nstep);
		if( op == NULL ) return;
		op->active = (1== 0);
		return ;
	case 6:
		op = o_m_serial(nstep);
		if( op == NULL ) return;
		op->active = (1== 1);
		return ;
	case 7:
		op = o_m_serial(nstep);
		op1 = o_m_serial( (int) toler);
		if(op == NULL ) { return ;}
		if(op1 == NULL ) {op->gang = NULL; return ;}
/* check for indirect gangs ang gang loops !!! */
		while(op1->gang != NULL && op1->gang != op ) op1 = op1->gang;
		if( op->type != op1->type ) return;
		op->gang = op1;
		return;
	case 8:
	if( op->gang != NULL) goto SKIP;
	touse   = Ritz_product;
/*	forgrad = Loose_Ritz_product; */
	forgrad = Ritz_product;

	if( op->gang == NULL){
	for(j=0; j< op->n; j++)
	{
		addresses[inparam+j] = &(op->rl[j]);
	}
	inparam += op->n;
	for(j=1; j< op->n; j++)
	{
		addresses[inparam+j-1] = &(op->a[j]);
	}
	inparam += op->n-1;
		}
	break;
	case 9:
	dscf_make_map( 0,output,toler,(float)nstep);
	return ;

	case 10:
	dscf_make_map( 1,output,toler,(float)nstep);
	return ;

	case 11:
	dscf_make_map( 2,output,toler,(float)nstep);
	return ;

	case 12:
	dscf_fit_q( (float)nstep);
	return ;

	case 13:
	if( !op->active) goto SKIP;
	if( op->gang != NULL) goto SKIP;
	for(j=0; j< op->n; j++)
	{
		addresses[inparam+j] = &(op->rl[j]);
	}
	inparam += op->n;
	for(j=1; j< op->n; j++)
	{
		addresses[inparam+j-1] = &(op->a[j]);
	}
	inparam += op->n-1;
	forgrad = INDO_Ritz_product;
	touse = INDO_Ritz_product;
//	initstep = .1;
	break;
	case 14:
	if( !op->active) goto SKIP;
	if( op->gang != NULL) goto SKIP;
/*	touse   = Ritz_product; */
	touse   = tight_INDO_Ritz_product;
	forgrad = INDO_Ritz_product;
/* touse = Loose_Ritz_product; */

	if( op->gang == NULL){
	for(j=0; j< op->n; j++)
	{
		addresses[inparam+j] = &(op->rl[j]);
	}
	inparam += op->n;
	for(j=1; j< op->n; j++)
	{
		addresses[inparam+j-1] = &(op->a[j]);
	}
	inparam += op->n-1;
				}
	switch( op->type )
	{
	case Or1:
		goto SKIP;
	case Or1o:
		addresses[inparam] = &op->x;
		addresses[inparam+1] = &op->y;
		addresses[inparam+2] = &op->z;
		inparam += 3;
//		initstep = .01;
	break;
	case Or2:
		addresses[inparam] = &op->along;
		inparam += 1;
//		initstep = .01;
	break;
	case Or3:
		addresses[inparam] = &op->along;
		addresses[inparam+1] = &op->along2;
		inparam += 2;
//		initstep = .01;
	break;
	case Or4p:
	case Or4s:
		addresses[inparam] = &op->along;
		inparam += 1;
//		initstep = .01;
	break;
	case Orm:
	goto SKIP;

	}
	break;

	case 15:
	if( op->gang != NULL) goto SKIP;
/*	touse = Ritz_product; */
/*	forgrad = Loose_Ritz_product; */
	forgrad = Ritz_product;
	touse = tight_INDO_Ritz_product;

	if( op->gang == NULL){
	for(j=0; j< op->n; j++)
	{
		addresses[inparam+j] = &(op->rl[j]);
	}
	inparam += op->n;
	for(j=1; j< op->n; j++)
	{
		addresses[inparam+j-1] = &(op->a[j]);
	}
	inparam += op->n-1;
		}
	break;


	}/* end switch( whattotry) */

SKIP:;

		op = op->next;

}/* i */
        ecurrent = (*touse)(NULL);
	initstep = .01;
	if( inparam > 0 ){
	dscf_krymin( addresses,inparam,initstep, touse,forgrad,output,nstep);
	renormalize();
			}

	enew = Ritz_product(NULL);
	report( output );
	fprintf(output,"iteration %d start %f finish %f delta %e\n",
		iter, ecurrent,enew,enew-ecurrent);
/*
	if( enew > ecurrent) break;
*/
	if (fabs(enew - ecurrent) < toler) break;
//	ecurrent = enew;

	}/* iter */

}/* end of directscf */

/* krymin is now a finite difference engine !!! */

void AMMP_FASTCALL dscf_krymin(float *where[], int n, float is, AMMP_OFUNC what, AMMP_OFUNC forgrad, FILE *output, int nstep)
{
  void *        parameter = NULL;
  static float  search[MAXPARAM],ograd[MAXPARAM];
  static float  params[MAXPARAM],grad[MAXPARAM];
/*  float         standard; */
  int           i, j;
  int           iter;
  float         beta, betad;

  assert( n < MAXPARAM);
  if (!n) return;

	for( i=0; i<n; i++)
	{  grad[i] = 0.; search[i] = 0.; }


	for( iter=0;iter<nstep; iter++)
	{

		renormalize();
	for( i=0; i< n; i++)
	{  params[i] = *where[i]; ograd[i] = grad[i];  }
/* use half-sided derivatives (a great leap backward but 2x faster) */
/* there is a de-sync which happened here
* (*what) calls o_update_normals() quite often
*/
/*	standard = (*what)(parameter); */
	for( i=0; i< n; i++)
		params[i] = *where[i];

/*	standard = (*forgrad)(parameter); */
	printf("gradient started");
	fflush(stdout);
	for( i=0; i< n; i++)
	{
	for( j=0; j< n; j++)
		*where[j] = params[j];
	*where[i] -= 1.e-2;

	grad[i] = (*forgrad)(parameter);
/*
	grad[i] = standard;
*/
	for( j=0; j< n; j++)
		*where[j] = params[j];
	*where[i] += 1.e-2;
/*
	grad[i] -= Just_Ritz_product(parameter);
*/
	grad[i] -= (*forgrad)(parameter);
	*where[i] = params[i];
	grad[i] *= 2.e+2;
	} /* i */
/* have the gradient ,old gradient ,old search (still in search )*/
	beta = 0.; betad = 0.;
	for(i=0; i<n; i++)
	{
	beta += (grad[i] - ograd[i])*grad[i];
	betad += ograd[i]*ograd[i];
	}
	if( fabs(betad) > 0.1* beta )
	{ beta = beta/betad; }else { beta = 0. ;}
	for( i=0;i< n;i++)
	{
	search[i] = (grad[i] + 100.*beta*search[i])/100.;
	}

	for( j=0; j< n; j++)
		*where[j] = params[j];
	printf(" and done\n");

    /**** Don't care about this return value ****/

    dscf_line(search, where, params, n, what, parameter);
    report(output);
  } /* End of for (iter) */
}

/* dscf_line is called by dscf_krymin()
*
* it searches for the closest local minimum
*
*/

float AMMP_FASTCALL dscf_line(float search[], float *where[], float params[], int n, AMMP_OFUNC what, void *whom)
{
#define MAXBUF 100
  float         beststep, step, dstep, myval, bestval;
  float         steps[MAXBUF], vals[MAXBUF];
  int           inbuf;
  int           i,irun,itry;

  inbuf    = 1;
  steps[0] = 0.0f;
  vals[0]  = (*what)(whom);
  bestval  = vals[0];
  step     = 0.0f;
  beststep = step;
  dstep    = 1.0f;

	for( itry = 0; itry < 10; itry ++)
	{
/* use irun to search  in terms of dstep */
		for( irun = 0; irun < 10; irun ++)
		{
		step += dstep;
/* first look in the table */

		for( i=0; i< inbuf; i++)
		{
		if( step == steps[i] ) {
				myval = vals[i];
				goto STEP_FOUND;
					}
		}
/* if here then we have to calculate the function */
		for( i=0; i< n; i++)
		{
			*where[i] = params[i] + search[i]*step;
		}
		myval = (*what)(whom);
	if (inbuf == MAXBUF) return beststep;
	assert( inbuf < MAXBUF );
		if( inbuf < MAXBUF)
			{vals[inbuf] = myval;steps[inbuf++] = step;}
		else { inbuf -= 10;   }
STEP_FOUND:
		if( myval >= bestval)
		{
			step -= dstep;
			dstep = -dstep*.5;
			break;
		} else {
		bestval = myval;
		beststep = step;
		/*
		step += dstep;
		*/
		}

	}/* irun */
	}/* itry */

/* update to the best found */
	for( i=0; i< n; i++)
	{
		*where[i] = params[i] + search[i]*beststep;
	}
	return beststep;
}

/* map.c
*
* routines to use floating gaussian orbitals for QM calculations
*
*/
/*
*  copyright 1993,1994,1995 Robert W. Harrison
*
*  This notice may not be removed
*  This program may be copied for scientific use
*  It may not be sold for profit without explicit
*  permission of the author(s) who retain any
*  commercial rights including the right to modify
*  this notice
*/


/* do the map */

void AMMP_FASTCALL dscf_make_map(int type, FILE *where, float grid, float guard)
{
  AMMP_ATOM          *ap;
  int           i, j, k, na;
  int           ix, imin, imax;
  int           jx, jmin, jmax;
  int           kx, kmin, kmax;
  int           irow;
  float         xa, ya, za, xmax, xmin, ymax, ymin, zmax, zmin;

  na = a_number();
  if (na <= 0) {
    fprintf(where,"No atoms - No map\n");
    return ;
  }

xmax = -10e10;
ymax = -10e10;
zmax = -10e10;
xmin =  10e10;
ymin =  10e10;
zmin =  10e10;
for( i=0; i< na; i++)
{
	ap = a_next(i);
	if( ap->na > 0.) {
	if( xmax < ap->x) xmax = ap->x;
	if( ymax < ap->y) ymax = ap->y;
	if( zmax < ap->z) zmax = ap->z;
	if( xmin > ap->x) xmin = ap->x;
	if( ymin > ap->y) ymin = ap->y;
	if( zmin > ap->z) zmin = ap->z;
			}
}
/* add guard box */
xmax += guard;
ymax += guard;
zmax += guard;
xmin -= guard;
ymin -= guard;
zmin -= guard;
/* force to integer grids */
i = xmax/grid + 1; imax = i; xmax = i*grid;
i = ymax/grid + 1; jmax = i; ymax = i*grid;
i = zmax/grid + 1; kmax = i; zmax = i*grid;
i = xmin/grid - 1; imin = i; xmin = i*grid;
i = ymin/grid - 1; jmin = i; ymin = i*grid;
i = zmin/grid - 1; kmin = i; zmin = i*grid;
/* figure out the fake cell (we'll keep it 90 90 90 ) */
ix = imax -imin; jx = jmax -jmin; kx = kmax -kmin;
/* write the header */
fprintf(where,"\n       2 !NTITLE\nREMARKS AMMP dscf map                                                                                  \nREMARKS                                                                                                 \n");
fprintf(where,"%8i%8i%8i%8i%8i%8i%8i%8i%8i\n",
	ix,imin,imax,jx,jmin,jmax,kx,kmin,kmax);
fprintf(where,"%12.5e%12.5e%12.5e%12.5e%12.5e%12.5e\nZXY",
	xmax-xmin,ymax-ymin,zmax-zmin,90.,90.,90.);
/* now do the work we loop with z outer then x then y
* and fake a FORTRAN implied do */
	dscf_map_setup();
	for( k=0; k<= kx; k++)
	{
	fprintf(where,"\n%8d\n",k);
	irow = 0;
	za = k*grid + zmin;
	for( j=0; j<= jx; j++)
	for( i=0; i<= ix; i++)
	{
	xa = i*grid + xmin;
	ya = j*grid + ymin;
	if(irow ==6) {fprintf(where,"\n"); irow = 0;}
	if( type == 0 ) fprintf(where,"%12.5e",dscf_map_ED(xa,ya,za));
	if( type == 1 ) fprintf(where,"%12.5e",dscf_map_field(xa,ya,za));
	if( type == 2 ) fprintf(where,"%12.5e",dscf_map_empirical(xa,ya,za));
	irow ++;
	}}
	fprintf(where,"\n%d\n",-9999);
}/* end of routine */


/*
* prepare normalizers so that the electrostatic potential can be
* calculated
*/

void AMMP_FASTCALL dscf_map_setup(void)
{
/* simply update the orbital coefficients and normalize
* so that phiphi(op,op) = 1.
*/
  o_update_normals();
  renormalize();
}

/* generate the electron density as a function of x,y,z */

float AMMP_FASTCALL dscf_map_ED(float x, float y, float z)
{
  float         ED;
  int           i, j, k, m, n, no;
  float         dx, dy, dz, r, rs, rab, rx, accum;
  float         temp;
  float         s1, s2, sign;
  ORBITAL       *op, *op1;

	ED = 0.;
	no = o_number();
	if( no <= 0 ) return ED;
	op = o_next(0);
	for( i=0; i< no; i++)
	{
/*
	for( l = 0; l < no; l++)
	{
		op1 = o_next(l);
*/
	{
	op1 = op;

	accum = 0.;
	for( j=0; j< op->n; j++)
	{
	for( n=0; n< op1->n; n++)
	{
	rs = (op->r[j]+ op1->r[n]);
	r = op->r[j]*op1->r[n]/rs;
/*
	temp = op->a[j]*op1->a[n] *pow( PI/rs,1.5);
*/
	temp = op->a[j]*op1->a[n];

	s1 = 1;
	for( k=0; k< op->ncenter; k++)
	{
	if( op->type == Or4p) s1 = -s1;
	s2 = 1;
	for( m=0; m< op1->ncenter; m++)
	{
	if( op1->type == Or4p) s2 = -s2;
	sign = s1*s2;
	dx = (op->rx[k] - op1->rx[m]);
	dy = (op->ry[k] - op1->ry[m]);
	dz = (op->rz[k] - op1->rz[m]);
	rab = dx*dx + dy*dy + dz*dz;
	rab = rab*INVBOHR*INVBOHR;
	dx = (op->r[j]*op->rx[k] + op1->r[n]*op1->rx[m])/rs;
	dy = (op->r[j]*op->ry[k] + op1->r[n]*op1->ry[m])/rs;
	dz = (op->r[j]*op->rz[k] + op1->r[n]*op1->rz[m])/rs;
	dx -= x;
	dy -= y;
	dz -= z;
	rx = (dx*dx + dy*dy + dz*dz)*INVBOHR*INVBOHR;

	dx = rs*rx +r*rab;
	if( dx > 50.) dx = 50.;
	if( dx < -50.) dx = -50.;
	accum += sign*temp*exp(-dx);
	} /*m */
	} /* k */
	} /* n */
	} /*j */
	if( op->ipair == 2) ED += accum;
	ED += accum;
	} /* l */
	op = op->next;
	} /*i */

return ED;
}

float AMMP_FASTCALL dscf_map_field(float x, float y, float z)
{
  AMMP_ATOM *   ap;
  float         phi;
  float         dx, dy, dz, rab, r, ntemp, rs, re;
  float         s1, s2, sign;
  int           i, j, k, m, n, no, na;
  ORBITAL       *op, *op1;


  phi = 0.0f;

/* do the nuclear terms */
	na = a_number();
	if( na <= 0 ) return phi;
	for( i=0; i< na; i++)
	{
	ap = a_next(i);
	if( ap->na != 0)
	{
		dx = ap->x - x;
		dy = ap->y - y;
		dz = ap->z - z;
		r = sqrt(dx*dx + dy*dy + dz*dz)*INVBOHR;
		if( r < 1.e-1) r = 1.e-1; /* keep the map in bounds */
		phi += ap->na/r;
	}}
/* now the electrons */
	no = o_number();
/* return the potential == (by def) -(integral)E */
	if( no <=0 ) return -phi;
	op = o_next(0);
	for( i=0; i< no; i++)
	{
/*
		for( l=0; l < no; l++)
*/
		{
/*
		op1 = o_next(l);
*/
		op1 = op;
		for( j=0; j< op->n; j++)
		{
		for( m=0; m< op1->n; m++)
		{
		rs = (op->r[j] + op1->r[m]);
		r = op->r[j]*op1->r[m]/rs;
		ntemp = op->a[j]*op1->a[m]*TWOPI/rs;
/*
		if( op->ipair == 2 || op1->ipair == 2) ntemp += ntemp;
*/
		s1 = 1.;
		for( k=0; k< op->ncenter; k++)
		{
		if( op->type == Or4p) s1 = -s1;
		s2 = 1.;
		for( n=0; n< op1->ncenter; n++)
		{
		if( op1->type == Or4p) s2 = -s2;
		sign = s1*s2;
		dx = (op->rx[k] - op1->rx[n]);
		dy = (op->ry[k] - op1->ry[n]);
		dz = (op->rz[k] - op1->rz[n]);
		rab = sqrt(dx*dx + dy*dy + dz*dz)*INVBOHR;
		re = exp(-r*rab);
		dx = (op->r[j]*op->rx[k] + op1->r[m]*op1->rx[n])/rs;
		dy = (op->r[j]*op->ry[k] + op1->r[m]*op1->ry[n])/rs;
		dz = (op->r[j]*op->rz[k] + op1->r[m]*op1->rz[n])/rs;
		dx -= x;
		dy -= y;
		dz -= z;
		rab = sqrt(rs*(dx*dx + dy*dy + dz*dz))*INVBOHR;
		if( rab < 1.e-4) rab = 1.e-4;


/*
	only if rab is not the sqrt
	in phiH4phi ... rs*rab is the square of here
		phi -= ntemp*Fzero( rs*rab)*re;
*/
		phi -= sign*2*ntemp * 0.5 *ROOTPI/(rab)*erf(rab)*re;
/* the above sign is + this gives the same values as others
* but is not neccesarily correct */
		}
		}
		}
		} } /*l */
		 op = op->next;
	}
/* return the potential == (by def) -(integral)E */
return -phi;
}


float AMMP_FASTCALL dscf_map_empirical(float x, float y, float z)
{
  AMMP_ATOM *   ap;
  float         phi;
  float         dx, dy, dz, r;
  int           i, na;

  phi = 0.0f;

  /**** Do the nuclear terms only use the fit charges ****/

  na = a_number();
  if (na <= 0) return phi;

  for(i = 0; i < na; i++) {
    ap = a_next(i);
    if (ap -> na) {
      dx = ap -> x - x;
      dy = ap -> y - y;
      dz = ap -> z - z;
      r  = sqrt(dx * dx + dy * dy + dz * dz) * INVBOHR;
      if (r < 1.e-2f) r = 1.e-2f; /* keep the map in bounds */
      phi += ap -> q / r;
    }
  } /* End of for (i) */

  return phi;
}


#define Kollman

/* fit the charges total charge = total */

int AMMP_FASTCALL dscf_fit_q(float total)
{
  AMMP_ATOM     *ap, *(*todo)[];
  float         (*radii)[];
  float         x, y, z, xc, yc, zc, r, t;
  float         xmax, ymax, zmax, xmin, ymin, zmin;
  float         weight;
  int           na;
  int           i, j;
  int           ncharge;
  int           ix, iy, iz;

  const char *  Routine = "dscf_fit_q()";
  float         (*matrix)[] = NULL;
  float         (*vector)[] = NULL;

  na = a_number();
  if( na == 0 ) return 0 ;

/* first figure out how many atoms and get their addresses */
	ncharge = 0;
	xc = 0.;
	yc = 0.;
	zc = 0.;
	xmax = -10e10;
	ymax = -10e10;
	zmax = -10e10;
	xmin = 10e10;
	ymin = 10e10;
	zmin = 10e10;
	for( i=0; i< na; i++)
	{ ap = a_next(i);
	if( ap->na != 0. ){ ncharge += 1;
		xc += ap->x;
		yc += ap->y;
		zc += ap->z;
		if( ap->x > xmax ) xmax = ap->x;
		if( ap->y > ymax ) ymax = ap->y;
		if( ap->z > zmax ) zmax = ap->z;
		if( ap->x < xmin ) xmin = ap->x;
		if( ap->y < ymin ) ymin = ap->y;
		if( ap->z < zmin ) zmin = ap->z;
			}
	}/* i */
	xc /= ncharge;
	yc /= ncharge;
	zc /= ncharge;
	if (((todo   = Alloca(ncharge * sizeof(AMMP_ATOM *), Routine)) == NULL) ||
            ((matrix = Alloca((ncharge + 1) * (ncharge + 1) * sizeof(float), Routine)) == NULL) ||
            ((vector = Alloca((ncharge + 1) * sizeof(float), Routine)) == NULL) ||
            ((radii  = Alloca(ncharge * sizeof(float), Routine)) == NULL)) {
          if (todo  ) free(todo  );
          if (matrix) free(matrix);
          if (vector) free(vector);
          return FALSE;
        }

	for( i=0; i< na; i++)
	{ ap = a_next(i);
	if( ap->na != 0. ) (* todo)[i] = ap ;
	}/* i */
/* setup storage with constraint equations */
	for( i=0; i< ncharge; i++)
	{

	for( j=0; j< ncharge; j++)
			(*matrix)[i*ncharge + i  + j ] = 0.;

#ifdef Kollman
	(*matrix)[i*(ncharge+1 ) + ncharge] = 1.;
#else
	(*matrix)[i*(ncharge+1 ) + ncharge] = 1.;
#endif
	(*matrix)[ncharge*(ncharge+1)  + i] = 1.;
	(*vector)[i] = 0.;
	}
	(*vector)[ncharge] = total;
#ifdef Kollman
	(*matrix)[(ncharge+1)*(ncharge+1) -1 ] = 0.;
#else
	(*matrix)[(ncharge+1)*(ncharge+1) -1 ] = 1.;
#endif

/*
	for( i= 0; i< ncharge+1; i++){
	for( j=0; j< ncharge+1; j++)
		printf("%f ",(*matrix)[i*(ncharge+1) + j]);
	printf("\n");}
*/

	dscf_map_setup();
/*
	for( k=0; k< ncharge*20; k++)
	{
*/
/* pick a point */
/*
REPICK:	rand3(&x,&y,&z);
	r = randf()*20.;
	x = x*r + xc;
	y = y*r + yc;
	z = z*r + zc;
*/
	for( iz = (int)zmin-5; iz< 6+(int)zmax;iz++)
	for( iy = (int)ymin-5; iy< 6+(int)ymax;iy++)
	for( ix = (int)xmin-5; ix< 6+(int)xmax;ix++)
	{
	x = (float)ix + xc;
	y = (float)iy + yc;
	z = (float)iz + zc;
	for( i=0; i< ncharge; i++)
	{ ap = (*todo)[i];
		t = x-ap->x;
		r = t*t;
		t = y-ap->y;
		r += t*t;
		t = z-ap->z;
		r += t*t;
/*
		if( r < 3.0 ) goto REPICK;
		if( r < 2.5 ) goto SKIP;
*/
		if( r < 1  ) goto SKIP;
/*
		(*radii)[i] = one/sqrt(r)*INVBOHR;
		(*radii)[i] = one/sqrt(r);
*/
		(*radii)[i] = one/sqrt(r);
	} /* i */
/* if here we have a good point */
	t = dscf_map_field(x,y,z)*BOHR;
/*
	if( fabs(t) > 0.2) goto SKIP;
	if( fabs(t) > .1) goto SKIP;
*/
	weight = exp(-fabs(t)*10);
	for( i=0;i< ncharge; i++)
	{
	for( j=0; j< ncharge; j++)
		(*matrix)[i*ncharge + i  + j] += weight*(*radii)[i]*(*radii)[j];
	(*vector)[i] += weight*(*radii)[i]*t;
	}
SKIP: ;
	}/*k */
/*
	for( i= 0; i< ncharge+1; i++){
	for( j=0; j< ncharge+1; j++)
		printf("%f ",(*matrix)[i*ncharge + i + j]);
	printf("\n");}
*/

	mom_solve((float (*)[])matrix, (float (*)[])vector, ncharge + 1, ncharge + 1);

	for( i=0; i< ncharge; i++)
	{ ap = (*todo)[i];
#ifdef Kollman
	ap->q = (*vector)[i] ;
#else
	ap->q = (*vector)[i] + (*vector)[ncharge]/ncharge ;
#endif
	}
/* testing */
 	r = 0.;
	t = 0.;
	for( i= 0; i< 100; i++)
	{
	rand3(&x,&y,&z);
	x = 2*(x-.5) + xc;
	y = 2*(y-.5) + yc;
	z = 2*(z-.5) + zc;
	(*vector)[0] = dscf_map_field(x,y,z)*BOHR;
	(*vector)[1] = dscf_map_empirical(x,y,z);
	r = r + fabs((*vector)[0]-(*vector)[1]);
	t = t + fabs((*vector)[0])+fabs((*vector)[1]);

	printf("%f %f %f %f %f\n",(*vector)[0],(*vector)[1],
		(*vector)[0]-(*vector)[1],r,t);
	}

	printf("%f\n",r/t);
	free(radii);
	free(vector);
	free(matrix);
	free(todo);
	return 0;
} /* end of dscf_fit_q() */
