/* grasp.c
*  search a space of torsion's using the
*  current potentials and greedy algorithms
*
* SINCE AMMP ONLY HAS ONE COORDINATE SET
* ONLY THE BEST IS KEPT
*
* uses the routines in tset.c and random.c
* these routines require atom dot notation (x.ca)
* and use the pdb mode
*
*
*/


/*
*  copyright 1993,1995,1996 Robert W. Harrison
*
*  This notice may not be removed
*  This program may be copied for scientific use
*  It may not be sold for profit without explicit
*  permission of the author(s) who retain any
*  commercial rights including the right to modify
*  this notice
*/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#  include <fastmath.h>
#else
#  include <math.h>
#endif

#include "ammp.h"


int AMMP_FASTCALL grasp(FILE *op, int echo, AMMP_VFUNC vfs[], AMMP_FFUNC ffs[],
                        int nfs, int nstep, int nkeep, int nsearch, int imin,
                        int imax, char *whom)
{
  AMMP_ATOM     *(*apa)[],*ap;
  char          *cp;
  float         delta;
  float         the_best_energy;
  float         (*the_best_xyz)[];
  int           natom, i, j, k, l, lmax;
  int           run;

  const char *  Routine = "grasp()";

  if (!CheckAtoms()) return FALSE;

  /**** Check the parameters ****/

  if (imax <= 0) imax = a_number();
  if (imax < imin) {
    j    = imax;
    imax = imin;
    imin = j;
  }

  the_best_energy = 1.e10;
  j = imax - imin;
  if ((j < 4) || (a_number() < 4)) {
    aaerror("You need at least four atoms for grasp");
    return FALSE;
  }

  if (((apa          = Alloca(j * sizeof(AMMP_ATOM *), Routine)) == NULL) ||
      ((the_best_xyz = Alloca(3 * a_number() * sizeof(float), Routine)) == NULL)) {
    SafeFree(apa);
    return FALSE;
  }

  /* Loop through the atoms and find all in the range
   * from imin to imax which are of type *whom
   */

  for(i = 0; i < j; i++) (*apa)[i] = NULL;

  ap    = a_next(-1);
  natom = 0;
  lmax  = a_number();
  for(i = 0; i < j; i++) {
    (*apa)[natom] = NULL;
    for(l = 0; l < lmax; l++) {
      k = ap -> serial / 100;
      if (k == (i + imin)) {
        cp = ap -> name;
        while((*cp != '.') && (*cp != '\0')) cp++;
        if (*cp == '.') cp++;
        if (!strcmp(cp, whom)) {
          (*apa)[natom] = ap;
	  natom++;
          break;
        }
      }

      /**** The residue is the right one ****/

      if ((ap -> next == ap) || (ap == NULL) || (ap -> next == NULL))
        ap = a_next(-1);
      else
        ap = ap -> next;
    } /* End of for (l) */
  } /* End of for (i) */


  /* Now the array apa has the atom pointers, in order and
   * natom is the number of atoms
   */

  for(i = 0; i < nstep; i++) {
    for(j = 0; j < (natom - 3);) {
      run = 10 * randf() + 1;

/*
	 delta = 2*3.141592653589793*randf()  ;
*/
    delta = 3.141592653589793f * (2.0f * randf() - 1.0f) / 10.0f;
/*
	for( l=0; l< run; l++)
	{
*/
    if ((*apa)[j    ] == NULL) break;
    if ((*apa)[j + 1] == NULL) break;
    if ((*apa)[j + 2] == NULL) break;
    if ((*apa)[j + 3] == NULL) break;
/*
	x = get_torsion_value( (*apa)[j],(*apa)[j+1],(*apa)[j+2],(*apa)[j+3]);
	tset_bond_build( (*apa)[j],(*apa)[j+1],(*apa)[j+2],(*apa)[j+3]);
	set_torsion( (*apa)[j],(*apa)[j+1],(*apa)[j+2],(*apa)[j+3],delta-x);
*/
	tset_bond_build( (*apa)[j],(*apa)[j+1],(*apa)[j+2],(*apa)[j+3]);
	set_torsion( (*apa)[j],(*apa)[j+1],(*apa)[j+2],(*apa)[j+3],delta);
	j += run;
/*
	j += 1;
	if( j > natom-4) break;

	}*//*l*/
	}/*j*/

    if (!grasp_valid_coordinate()) continue ;
    cngdel(vfs, ffs, nfs, nsearch, nsearch, 0.0f, FALSE, GetNupdat());
    delta = 0.0f;
    for(j = 0; j< nfs; j++) (*vfs[j])(&delta, 0.0f);
    if (echo)
      fprintf(op, "  Grasp %6d: the best energy is %f %f\n",
              i, the_best_energy, delta);

    if (delta < the_best_energy) {
      if (echo) fprintf(op, "  Grasp %6d: the best energy is %f\n", i, delta);
      the_best_energy = delta;
      for(l = 0; l < lmax; l++) {
        ap                         = a_next(l);
        (*the_best_xyz)[3 * l    ] = ap -> x;
        (*the_best_xyz)[3 * l + 1] = ap -> y;
        (*the_best_xyz)[3 * l + 2] = ap -> z;
      } /* End of for (l) */
    }
  }

  for(l = 0; l < lmax; l++) {
    ap      = a_next(l);
    ap -> x = (*the_best_xyz)[3 * l    ];
    ap -> y = (*the_best_xyz)[3 * l + 1];
    ap -> z = (*the_best_xyz)[3 * l + 2];
  } /* End of for (l) */

  free(the_best_xyz);
  free(apa);

  return TRUE;
}


int AMMP_FASTCALL grasp_valid_coordinate(void)
{

	int na;
	AMMP_ATOM *ap1,*ap2;
	int i,j;
	float x,y,z;

	na = a_number();
	if( na < 1) return 1==0;

	ap1 = a_next(-1);
	ap1 = ap1->next;
	for( i=1; i< na; i++)
	{
	for( j=0; j< i; j++)
	{
	ap2 = a_next(j);

	x = fabs(ap1->x -ap2->x);
	if( x < 1.e-1)
	{
	y = fabs(ap1->y -ap2->y);
	if( y < 1.e-1)
	{
	z = fabs(ap1->z -ap2->z);
	if( z< 1.e-1)
	{
	return 1==0;
	}}}
	}
	ap1 = ap1->next;
	}

	return 1==1;
}
