
/********************************************
****            AMMP - Inlines           ****
**** Copyright 2006, Alessandro Pedretti ****
********************************************/


/**** Global variables ****/

extern const char cb64[];


/**** Change the endian of a float ****/

AMMP_INLINE float AMMP_FASTCALL AmmpSwapf(float Val)
{
  register char         T;

  T = ((char *)&Val)[0];
  ((char *)&Val)[0] = ((char *)&Val)[3];
  ((char *)&Val)[3] = T;
  T = ((char *)&Val)[1];
  ((char *)&Val)[1] = ((char *)&Val)[2];
  ((char *)&Val)[2] = T;

  return Val;
}


/**** Encode 3 8-bit binary bytes as 4 '6-bit' characters ****/

AMMP_INLINE void AMMP_FASTCALL Base64EncodeBlock(unsigned char *in, unsigned char *out, int len)
{
  out[0] = cb64[in[0] >> 2 ];
  out[1] = cb64[((in[0] & 0x03) << 4) | ((in[1] & 0xf0) >> 4) ];
  out[2] = (unsigned char)(len > 1 ? cb64[ ((in[1] & 0x0f) << 2) | ((in[2] & 0xc0) >> 6) ] : '=');
  out[3] = (unsigned char)(len > 2 ? cb64[ in[2] & 0x3f ] : '=');
}
