
/*************************************************
****          AMMP - List management          ****
**** Copyright 2006-2012, Alessandro Pedretti ****
*************************************************/


#include <malloc.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#endif

#include "ammp.h"


/**** Add a list item ****/

void * AMMP_FASTCALL ListAdd(void **BegList, void **LastList, int Size)
{
  AMMP_LIST *           Item;

  if ((!BegList) || (!LastList) || (!Size)) return NULL;

  if ((Item = Alloca(Size, "LiastAdd()")) != NULL) {
    Item -> next = NULL;
    Item -> prev = NULL;
    ListLinkAtEnd(BegList, LastList, Item);
  }

  return Item;
}


/**** Free a list ****/

void AMMP_FASTCALL ListFree(void **BegList, void **LastList)
{
  void *        Ptr;
  void *        Tmp;

  if ((!BegList) || (!*BegList)) return;

  Ptr = *BegList;
  while(Ptr) {
    Tmp = *(void **)Ptr;
    free(Ptr);
    if (Ptr == Tmp) break;
    Ptr = Tmp;
  }

  if (LastList) *LastList = NULL;
  *BegList  = NULL;
}


/**** Link a list item ****/

void AMMP_FASTCALL ListLinkAtEnd(void **BegList, void **LastList, void *Item)
{
  if ((!BegList) || (!LastList) || (!Item)) return;

  if (*BegList) {
    ((AMMP_LIST *)*LastList) -> next = Item;
    ((AMMP_LIST *)Item) -> prev      = *LastList;
    *LastList                        = Item;
  } else {
    ((AMMP_LIST *)Item) -> prev = NULL;
    *BegList = *LastList = Item;
  }
  ((AMMP_LIST *)Item) -> next = NULL;
}


/**** Remove a list item ****/

void AMMP_FASTCALL ListRemove(void **BegList, void **LastList, void *Item)
{
  if (ListUnlink(BegList, LastList, Item))
    free(Item);
}


/**** Unlink a list item ****/

int AMMP_FASTCALL ListUnlink(void **BegList, void **LastList, void *Item)
{
  if ((!BegList) || (!LastList) || (!Item)) return FALSE;

  if (((AMMP_LIST *)Item) -> prev) {
    ((AMMP_LIST *)Item) -> prev -> next = ((AMMP_LIST *)Item) -> next;
    if (((AMMP_LIST *)Item) -> next)
      ((AMMP_LIST *)Item) -> next -> prev = ((AMMP_LIST *)Item) -> prev;
  } else {
    *BegList = ((AMMP_LIST *)Item) -> next;
    if (*BegList) ((AMMP_LIST *)*BegList) -> prev = NULL;
  }
  if ((AMMP_LIST *)Item == *LastList) *LastList = ((AMMP_LIST *)Item) -> prev;

  return TRUE;
}
