
/**********************************************************
**** AMMP 2.4.0  - Another Molecular Mechanics Program ****
****      Copyright 1992-2012, Robert W. Harrison      ****
****        VEGA edition by Alessandro Pedretti        ****
**********************************************************/


#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>

#ifdef WIN32
#  include <windows.h>
#  include <float.h>
#  include <time.h>

#  ifndef MCW_EM
#    define MCW_EM              0x003f
#  endif
#else
#  include <sys/types.h>
#  include <sys/ipc.h>
#  include <sys/shm.h>
#  include <unistd.h>
#  include <sys/time.h>
#  include <sys/poll.h>
#endif

#ifdef __BORLANDC__
#  pragma hdrstop
#  include <fastmath.h>
#else
#  include <math.h>
#endif

#include "ammp.h"
#include "mthread.h"

#ifdef GRAMMP
#  include "dsc.h"

void graphic_do();
#endif

/**** Global variables ****/

AMMP_FFUNC              forces[10];
AMMP_VFUNC              potentials[10];
int                     AmmpEndian;
int                     nused;

AMMP_ABC *              abc_first       = NULL;
AMMP_ABC *              abc_last        = NULL;
ANGLE *                 angle_first     = NULL;
ANGLE *                 angle_last      = NULL;
AMMP_ATOM *             atomfirst       = NULL;
AMMP_ATOM *             atomlast        = NULL;
AMMP_ATOM **            mom_list        = NULL;
AV5  *                  av5_first       = NULL;
AV5  *                  av5_last        = NULL;
BOND *                  bond_first      = NULL;
BOND *                  bond_last       = NULL;
CLONE *                 clone_first     = NULL;
CLONE *                 clone_last      = NULL;
DATATABLE *             first_datatable = NULL;
DATATABLE *             last_datatable  = NULL;
int                     atomNUMBER      = 0;
int                     atomUPDATE      = FALSE;
int                     in_mom_list     = 0;
HYBRID  *               hybrid_first    = NULL;
HYBRID  *               hybrid_last     = NULL;
MORSE *                 morse_first     = NULL;
MORSE *                 morse_last      = NULL;
NOEL *                  noel_first      = NULL;
NOEL *                  noel_last       = NULL;
RESTRAIN *              restrain_first  = NULL;
RESTRAIN *              restrain_last   = NULL;
STEP *                  STEP_first      = NULL;
STEP *                  STEP_last       = NULL;
SWARM *                 SWARM_first     = NULL;
SWARM *                 SWARM_last      = NULL;
TBOND *                 first_tbond     = NULL;
TBOND *                 last_tbond      = NULL;
TETHER *                tether_first    = NULL;
TETHER *                tether_last     = NULL;
TGROUP *                tg_first        = NULL;
TGROUP *                tg_last         = NULL;
TORSION *               torsion_first   = NULL;
TORSION *               torsion_last    = NULL;
TTARGET *               ttarget_first   = NULL;
TTARGET *               ttarget_last    = NULL;
VARIABLE *              variableFIRST   = NULL;
VARIABLE *              variableLAST    = NULL;

#ifdef WIN32
HANDLE                  ApiStdOut;
#endif


/**** Main code ****/

int main(int argc, char *argv[])
{
#ifdef GRAMMP
  pid_t         x = 0;  /* process id integer comparison is OK */
#else
  FILE *        hIn = stdin;
#endif

  AmmpEndian = CheckEndian();

#ifdef WIN32
  _control87(MCW_EM, MCW_EM);
#endif

  Default();


#ifdef GRAMMP

  /**** Create the pipes ****/

  if (pipe(ammp_to_grfx_pipe) == -1) {
    fprintf(stderr, "Unable to build ammp_to_grfx_pipe\n");
    exit(1);
  }

  if (pipe(grfx_to_ammp_pipe) == -1) {
    fprintf(stderr,"Unable to build grfx_to_ammp_pipe\n");
    exit(1);
  }

  /**** Spawn the graphics process ****/

  x = fork();
  if (x == (pid_t)-1) {
    aaerror("Can't fork");
    exit(0);
  }

  if (x == 0) graphic_do(&argc, argv);
  else read_eval_do(stdin, stdout);

#else

  /**** VEGA ZZ initialization ****/

#  ifdef VEGAZZ
  setvbuf(stdout, NULL, _IONBF, 0);
#    ifdef WIN32
  ApiStdOut = GetStdHandle(STD_OUTPUT_HANDLE);
#    endif

  printf("AMMP " AMMP_VERSTR " - (c) " AMMP_COPYRIGHT ", Robert W. Harrison\n"
         "VEGA edition by Alessandro Pedretti\n\n");
#  endif

  if (argc > 1) {
    if ((hIn = fopen(argv[1], "r")) == NULL) {
      aaerror("Input file not found");
      return 0;
    }
  }

  read_eval_do(hIn, stdout);
#endif
  Reset();

#ifndef GRAMMP
#  ifdef WIN32
  CloseHandle(ApiStdOut);
#  endif
  if (hIn != stdin) fclose(hIn);
#endif


  return 0;
}


#ifdef GRAMMP

/**** Poll the ammp_to_grfx_pipe for input ****/

int PipePoller(void)
{
  fd_set                rfds;
  int                   retval;
  struct timeval        tv;

  FD_ZERO(&rfds);
  FD_SET(ammp_to_grfx_pipe[0], &rfds);
  tv.tv_sec = 0;
  tv.tv_usec = 0;

  retval = select(ammp_to_grfx_pipe[0] + 1, &rfds, NULL, NULL, &tv);

  if (retval < 0)  fprintf(stderr, "PipePoller(): Error returned from select()\n");

  return retval;
}


/**** Read from the ammp_to_grfx_pipe ****/

ssize_t ReadFromAmmp(void *buf, size_t count)
{
  int           retval = read(ammp_to_grfx_pipe[0], buf, count);

  if (retval == -1) {
    fprintf(stderr, "ReadFromAmmp(): Error\n");
    exit(1);
  }

  return retval;
}


/**** Read from the grfx_to_ammp_pipe ****/

ssize_t ReadFromGrfx(void *buf, size_t count)
{
  int           retval = read(grfx_to_ammp_pipe[0], buf, count);

  if (retval == -1) {
    fprintf(stderr,"ReadFromGrfx(): Error\n");
    exit(1);
  }

  return retval;
}


/**** Write to the grfx_to_ammp_pipe ****/

ssize_t WriteToAmmp(void *buf, size_t count)
{
  int           retval = write(grfx_to_ammp_pipe[1], buf, count);

  if (retval == -1) {
    fprintf(stderr, "WriteToAmmp(): Error\n");
    exit(1);
  }

  return retval;
}


/**** Write to the ammp_to_grfx_pipe ****/

ssize_t WriteToGrfx(void *buf, size_t count)
{
  int           retval = write(ammp_to_grfx_pipe[1], buf, count);

  if (!count) printf("WriteToGrfx(): buf = %s\n", (char *)buf);
  if (retval == -1) {
    fprintf(stderr, "WriteToGrfx(): Error\n");
    exit(1);
  }

  return retval;
}
#endif
