/* map.c
*
* routines to use floating gaussian orbitals for QM calculations
*
*/
/*
*  copyright 1993,1994,1995 Robert W. Harrison
*  
*  This notice may not be removed
*  This program may be copied for scientific use
*  It may not be sold for profit without explicit
*  permission of the author(s) who retain any
*  commercial rights including the right to modify 
*  this notice
*/

#include <assert.h>

#define ANSI 1
/* misc includes - ANSI and some are just to be safe */
#include <stdio.h>
#include <ctype.h>

#ifdef ANSI
#  include <stdlib.h>
#endif

#ifdef __BORLANDC__
#  pragma hdrstop
#  include <fastmath.h>
#else
#  include <math.h>
#endif

#include "ammp.h" /* this includes numeric.h */

#include "orbit.h" 

/* do the map */

void AMMP_FASTCALL dscf_make_map(int type, FILE *where, float grid, float guard)
{
ATOM *ap;
int i,j,k,na;
int ix,imin,imax;
int jx,jmin,jmax;
int kx,kmin,kmax;
int irow;
float xa,ya,za,xmax,xmin,ymax,ymin,zmax,zmin;

na = a_number();
if( na <= 0){ fprintf(where,"No atoms - No map\n"); return ;}

xmax = -10e10;
ymax = -10e10;
zmax = -10e10;
xmin =  10e10;
ymin =  10e10;
zmin =  10e10;
for( i=0; i< na; i++)
{
	ap = a_next(i);
	if( ap->na > 0.) {
	if( xmax > ap->x) xmax = ap->x;
	if( ymax > ap->y) ymax = ap->y;
	if( zmax > ap->z) zmax = ap->z;
	if( xmin < ap->x) xmin = ap->x;
	if( ymin < ap->y) ymin = ap->y;
	if( zmin < ap->z) zmin = ap->z;
			}
}
/* add guard box */
xmax += guard;
ymax += guard;
zmax += guard;
xmin -= guard;
ymin -= guard;
zmin -= guard;
/* force to integer grids */
i = xmax/grid + 1; imax = i; xmax = i*grid;
i = ymax/grid + 1; jmax = i; ymax = i*grid;
i = zmax/grid + 1; kmax = i; zmax = i*grid;
i = xmin/grid - 1; imin = i; xmin = i*grid;
i = ymin/grid - 1; jmin = i; ymin = i*grid;
i = zmin/grid - 1; kmin = i; zmin = i*grid;
/* figure out the fake cell (we'll keep it 90 90 90 ) */
ix = imax -imin; jx = jmax -jmin; kx = kmax -kmin;
/* write the header */
fprintf(where,"\n       2 !NTITLE\nREMARKS AMMP dscf map\nREMARKS\n\n");
fprintf(where,"%8i%8i%8i%8i%8i%8i%8i%8i%8i\n\n",
	ix,imin,imax,jx,jmin,jmax,kx,kmin,kmax);
fprintf(where,"%12.5e%12.5e%12.5e%12.5e%12.5e%12.5e\nZXY\n\n",
	xmax-xmin,ymax-ymin,zmax-zmin,90.,90.,90.);
/* now do the work we loop with z outer then x then y
* and fake a FORTRAN implied do */
	dscf_map_setup();
	for( k=0; k< kx; k++)
	{
	fprintf(where,"%8d\n",k);
	irow = 0;
	za = k*grid + zmin;
	for( i=0; i< ix; i++)
	for( j=0; j< jx; j++)
	{
	xa = i*grid + xmin;
	ya = j*grid + ymin;
	if(irow ==6) fprintf(where,"\n");
	if( type == 0 ) fprintf(where,"%12.5e",dscf_map_ED(xa,ya,za));
	if( type == 1 ) fprintf(where,"%12.5e",dscf_map_field(xa,ya,za));
	}}
}/* end of routine */


/*
* prepare normalizers so that the electrostatic potential can be 
* calculated
*/
void AMMP_FASTCALL dscf_map_setup(void)
{
/* simply update the orbital coefficients and normalize
* so that phiphi(op,op) = 1. 
*/
	o_update_normals();
	renormalize();
}
/* generate the electron density as a function of x,y,z */
float dscf_map_ED( x,y,z )
float x,y,z; /* where to map */
{
float ED;
ORBITAL *op,*o_next();
int i,j,no,o_number();
float dx,dy,dz,r,accum;

	ED = 0.;
	no = o_number();
	if( no <= 0 ) return ED;
	for( i=0; i< no; i++)
	{
	op = o_next(i);
	dx = op->rx -x;
	dy = op->ry -y;
	dz = op->rz -z;
	r = dx*dx + dy*dy + dz*dz;
	r = (r+r)*INVBOHR*INVBOHR;
	accum = 0.;
	for( j=0; j< op->n; j++)
	{
/* must check, might be r/op->r[j] also factor of two */
	accum += op->a[j]*op->a[j]*exp( -op->r[j]*r);
	}

	if( op->ipair == 2) ED += accum;
	ED += accum;
	}

return ED;
}

float dscf_map_field( x,y,z)
float x,y,z;
{
float phi;
ATOM *ap,*a_next();
ORBITAL *op,*o_next();
int i,j,no,o_number(),na,a_number();
float dx,dy,dz,rab,r,ntemp,rs,re;
float Fzero();

	phi = 0.;
/* do the nuclear terms */
	na = a_number();
	if( na <= 0 ) return phi;
	for( i=0; i< na; i++)
	{
	ap = a_next(i);
	if( ap->na != 0)
	{
		dx = ap->x - x;
		dy = ap->y - y;
		dz = ap->z - z;
		r = sqrt(dx*dx + dy*dy + dz*dz)*INVBOHR;
		if( r < 1.e-4) r = 1.e-4;
		phi += ap->na/r;
	}}
/* now the electrons */
	no = o_number();
	if( no <=0 ) return phi;
	for( i=0; i< no; i++)
	{
		op = o_next(i);
		dx = op->rx - x;
		dy = op->ry - y;
		dz = op->rz - z;
		rab = sqrt(dx*dx + dy*dy + dz*dz)*INVBOHR;
		if( rab < 1.e-4) rab = 1.e-4;
		for( j=0; j< op->n; j++)
		{

		rs = (op->r[j] + op->r[j]);
		ntemp = op->a[j]*op->a[j]*TWOPI/rs;
		re = ntemp*Fzero( rs*rab);
		if( op->ipair == 2) phi += re;
		phi += re;

		}
	}
return phi;
}


