/* morse.c
*
* collection of routines to service morse length potentials
*
* POOP (Poor-mans Object Oriented Programming) using scope rules
*
* these routines hold a data base (in terms of array indeces)
* of morse bonds, with the associated length and force constants
*
* (this could be table driven but what the hell memories cheap)
*
* the routines for potential value, force and (eventually) second
* derivatives are here also
*
* force and 2nd derivative routines assume zero'd arrays for output
* this allows for parralellization if needed (on a PC?)
*
* forces are bond wise symmetric - so we don't have to fuck around with
* s matrices and the like.
*/
/*
*  copyright 1992 Robert W. Harrison
*  
*  This notice may not be removed
*  This program may be copied for scientific use
*  It may not be sold for profit without explicit
*  permission of the author(s) who retain any
*  commercial rights including the right to modify 
*  this notice
*/

#include <stdio.h>
#include <ctype.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#  include <fastmath.h>
#else
#  include <math.h>
#endif

#include "ammp.h"


/**** Dump the morses ****/

void AMMP_FASTCALL dump_morse(FILE *where)
{
  MORSE         *b = morse_first;

  while(b) {
    fprintf(where, "morse %d %d %f %f %f;\n",
            b -> atom1 -> serial, b -> atom2 -> serial, b -> length,
            b -> k, b -> order);
    if (b -> next == b) break;
    b = b -> next;
  } /* End of while */
}


/**** Add a new morse record ****/

int AMMP_FASTCALL morse(int p1, int p2, float bl, float fk, float order)
{
  MORSE *       new;

  /**** Get the atom pointers for the two serial numbers ****/

  AMMP_ATOM *   ap1 = a_m_serial(p1);
  AMMP_ATOM *   ap2 = a_m_serial(p2);

  if ((!ap1) || (!ap2)) {
    aaerror("Undefined atom in morse %d %d", p1, p2);
    return FALSE;
  }

  if ((new = (MORSE *)Alloca(sizeof(MORSE), "morse()")) == NULL)
    return FALSE;

  /**** Initialize the pointers ****/

  if (morse_first == NULL) morse_first = new;
  if (morse_last == NULL) morse_last = new;

  new -> atom1       = ap1;
  new -> atom2       = ap2;
  new -> length      = bl;
  new -> k           = fk;
  new -> order       = order;
  new -> next        = new;
  morse_last -> next = new;
  morse_last         = new;

  return TRUE;
}


/* v_morse()
* this function sums up the potentials
* for the atoms defined in the MORSE data structure.
*/
/* standard returns 0 if error (any) 1 if ok
* V is the potential */

int AMMP_FASTCALL v_morse(float *V, float lambda)
{
  AMMP_ATOM     *a1,*a2;
  float         r, xt, yt, zt;

  MORSE *       bp = morse_first;

  if (!bp) return TRUE;

  while(bp) {
    a1 = bp -> atom1;
    a2 = bp -> atom2;
    if ((a1 -> active) || (a2 -> active)) {
      if (lambda) {
        xt = a1 -> x - a2 -> x + lambda * (a1 -> dx - a2 -> dx);
        yt = a1 -> y - a2 -> y + lambda * (a1 -> dy - a2 -> dy);
        zt = a1 -> z - a2 -> z + lambda * (a1 -> dz - a2 -> dz);
      } else {
        xt = a1 -> x - a2 -> x;
        yt = a1 -> y - a2 -> y;
        zt = a1 -> z - a2 -> z;
      }
      r  = xt*xt+yt*yt+zt*zt;
      r = sqrt(r);
/* *V += bp->k*( r - bp->length)*(r - bp->length);
*/
	xt = 1.- exp( -(bp->order)*(r - bp->length)) ;
	*V += bp->k*xt*xt;
	}
	if( bp == bp->next ) return 1;
	bp = bp->next;
       }

  return FALSE;
}

/* f_morse()
*
* f_morse increments the forces in the atom structures by the force
* due to the morse components.  NOTE THE WORD increment.
* the forces should first be zero'd.
* if not then this code will be invalid.  THIS IS DELIBERATE.
* on bigger (and better?) machines the different potential terms
* may be updated at random or in parrellel, if we assume that this routine
* will initialize the forces then we can't do this.
*/

int AMMP_FASTCALL f_morse(float lambda)
/*  returns 0 if error, 1 if OK */
{
	MORSE *bp;
	float r,k,ux,uy,uz;
	AMMP_ATOM *a1,*a2;


	bp = morse_first;
       if( bp == NULL ) return 1;
       while(1)
       {
	if( bp == NULL) return 0;
	a1 = bp->atom1; a2 = bp->atom2;
	if( a1->active || a2->active){
	if( lambda == 0.)
	{
	ux = (a2->x - a1->x);
	uy = (a2->y - a1->y);
	uz = (a2->z - a1->z);
	}else{
	ux = (a1->x -a2->x +lambda*(a1->dx-a2->dx));
	uy = (a1->y -a2->y +lambda*(a1->dy-a2->dy));
	uz = (a1->z -a2->z +lambda*(a1->dz-a2->dz));
	}
	r = ux*ux + uy*uy + uz*uz;
	 /* watch for FP errors*/
	 if( r <= 1.e-5)
	 { r = 0; ux = 1.; uy = 0.; uz = 0.; }else{
	r = sqrt(r); ux = ux/r; uy = uy/r; uz = uz/r;
	}
	k =  exp( -(bp->order)*(r - bp->length)) ;
	k = -2*bp->order *(1.-k)*k* bp->k;
	ux = 2*k*(r-bp->length)*ux; 
	uy = 2*k*(r-bp->length)*uy; 
	uz = 2*k*(r-bp->length)*uz;
	if( a1->active){
	a1->fx += ux; 
	a1->fy += uy; 
	a1->fz += uz; 
	}
	if( a2->active){ 
	a2->fx -= ux; 
	a2->fy -= uy; 
	a2->fz -= uz; 
	}
	}
	if( bp == bp->next ) return 1;
	bp = bp->next;
       }
}
/* function get_morse( a1,morseed,10,inmorse);
* check the MORSES list for atoms morseed to a1
*/

void AMMP_FASTCALL get_morse(AMMP_ATOM *a1, AMMP_ATOM *morseed[], int mmorse, int *inmorse)
{
	MORSE *mine;
	mine = morse_first;
	*inmorse = 0;
	while(1)
	{
	if( (mine == NULL) )
	{
		return;
	}
	if( mine->atom1 == a1)
	{
		morseed[(*inmorse)++] = mine->atom2;
	}
	if( mine->atom2 == a1)
	{
		morseed[(*inmorse)++] = mine->atom1;
	}
	if( mine == mine->next) return;
	mine = mine->next;
	if( *inmorse == mmorse ) return;
	}		
}

