
/*************************************************
**** Universal Multithreading Control Library ****
****       (c) 2003 Alessandro Pedretti       ****
*************************************************/

#ifndef __MCL_H

/**** Amiga definitions ****/

#  ifdef AMIGA
#    define  MCL_AMIGA
#    define  MCL_MAX_CPU        1
#  endif

/**** Linux definitions ****/

#  ifdef linux
#    define  MCL_LINUX
#    define  MCL_PTHREAD
#    define  MCL_MAX_CPU        256
#  endif

/**** SGI definitions ****/

#  ifdef sgi
#    define  MCL_SGI
#    define  MCL_MAX_CPU        256
#  endif

/**** Sun definitions ****/

#  ifdef _sun
#    define  MCL_SUN
#    define  MCL_PTHREAD
#    define  MCL_MAX_CPU        256
#  endif

/**** Windows definitions ****/

#  if defined(__WIN32__) || defined(WIN32)
#    define  MCL_WIN32
#    define  MCL_MAX_CPU        32
#  endif

/**** Flags for create threads ****/

#  define  MCL_THREADS_SYNC     1       /* Synchronized start */
#  define  MCL_THREADS_WAIT     2       /* Wait all threads   */

#  ifdef MCL_WIN32
#    define  MCL_THREAD         int WINAPI
#  else
#    define  MCL_THREAD         int
#  endif

#  ifndef MCL_MAX_CPU
#    define  MCL_MAX_CPU        1
#  endif

/**** Macros ****/

#  define  MCL_BEGIN            typedef struct {unsigned int ThreadID; unsigned int Threads;
#  define  MCL_END              } MCL_GLOBVARS;
#  define  MCL_ALLOCGLOBVARS    MCL_GLOBVARS HdtGlobVars;

#  define  MCL_GetVar(X)        HdtGlobVars.X
#  define  MCL_GetVarTh(X)      ((MCL_GLOBVARS *)HdtGlobVars) -> X
#  define  MCL_GetVarThEx(X, Y) MCL_MutexOn(); \
                                X = ((MCL_GLOBVARS *)HdtGlobVars) -> Y; \
                                MCL_MutexOff()

#  define  MCL_SetVar(X, Y)     HdtGlobVars.X = Y
#  define  MCL_SetVarThEx(X, Y) MCL_MutexOn(); \
                                HdtGlobVars.Y = X; \
                                MCL_MutexOff()

#  define  MCL_ObtainThID(X)    MCL_MutexOn(); \
                                X = ++((MCL_GLOBVARS *)HdtGlobVars) -> ThreadID; \
                                MCL_MutexOff()

/**** Types ****/

typedef int (*MCL_START_ROUTINE)(void *ThreadParameter);

/**** Prototypes ****/

#  ifdef __cplusplus
extern "C" {
#  endif

void    MCL_CloseMutex(void);
int     MCL_CreateMutex(void);
int     MCL_CreateThreads(int, int (*)(void *), void *, int);
int     MCL_GetCPUs(void);
void    MCL_MutexOff(void);
void    MCL_MutexOn(void);
void    MCL_StartWait(void);

#  ifdef __cplusplus
}
#  endif
#endif

