
/*************************************************
**** Universal Multithreading Control Library ****
****       (c) 2003 Alessandro Pedretti       ****
*************************************************/

#ifndef __MCL_H

/**** Amiga definitions ****/

#  ifdef AMIGA
#    define  MCL_AMIGA
#    define  MCL_MAX_CPU        1
#  endif

/**** Linux definitions ****/

#  ifdef linux
#    define  MCL_LINUX
#    define  MCL_PTHREAD
#    define  MCL_MAX_CPU        256
#  endif

/**** SGI definitions ****/

#  ifdef sgi
#    define  MCL_SGI
#    define  MCL_MAX_CPU        256
#  endif

/**** Sun definitions ****/

#  ifdef _sun
#    define  MCL_SUN
#    define  MCL_PTHREAD
#    define  MCL_MAX_CPU        256
#  endif

/**** Windows definitions ****/

#  if defined(__WIN32__) || defined(WIN32)
#    define  MCL_WIN32
#    define  MCL_MAX_CPU        256
#  endif

/**** Flags for create threads ****/

#  define  MCL_THREADS_SYNC     1       /* Synchronized start */
#  define  MCL_THREADS_WAIT     2       /* Wait all threads   */

#  ifdef MCL_WIN32
//#    define  MCL_THREAD         int WINAPI
#  else
//#    define  MCL_THREAD         int
#  endif

#  ifndef MCL_MAX_CPU
#    define  MCL_MAX_CPU        1
#  endif

/**** Macros ****/

#  define  MCL_BEGIN            typedef struct {unsigned int ThreadID; unsigned int Threads;
#  define  MCL_END              } MCL_GLOBVARS;
#  define  MCL_ALLOCGLOBVARS    MCL_GLOBVARS HdtGlobVars;

#  define  MCL_GetVar(X)        HdtGlobVars.X
#  define  MCL_GetVarTh(X)      ((MCL_GLOBVARS *)HdtGlobVars) -> X
#  define  MCL_GetVarThEx(X, Y) MCL_MutexOn(); \
                                X = ((MCL_GLOBVARS *)HdtGlobVars) -> Y; \
                                MCL_MutexOff()

#  define  MCL_SetVar(X, Y)     HdtGlobVars.X = Y
#  define  MCL_SetVarThEx(X, Y) MCL_MutexOn(); \
                                HdtGlobVars.Y = X; \
                                MCL_MutexOff()

#  define  MCL_ObtainThID(X)    MCL_MutexOn(); \
                                X = ++((MCL_GLOBVARS *)HdtGlobVars) -> ThreadID; \
                                MCL_MutexOff()

/**** Burst thread flags ****/

#  define  MCL_BTFLAG_NONE              0       /* None                       */
#  define  MCL_BTFLAG_DESTROYING        1       /* Destroying thread          */
#  define  MCL_BTFLAG_RUNNING           2       /* Running thread             */

typedef void *          MCL_BARRIER;
typedef void *          MCL_EVENT;
typedef void *          MCL_MUTEX;
typedef void *          MCL_THREAD;

/**** Burst thread structure ****/

struct __mcl_burstthread {
  int           SetSignal;
  int           Flags;                          /* Flags                      */
  int           NumThreads;                     /* Number of threads          */
  int           (*Routine)(void *);             /* Code to call               */
  void *        Args;                           /* Code arguments             */
  MCL_BARRIER   hSyncBar;                       /* Synch barrier              */
  MCL_EVENT     hEnd;                           /* End event                  */
  MCL_EVENT     hStart;                         /* Start event                */
  MCL_MUTEX     hMutex;                         /* Mutex                      */
  MCL_THREAD *  Threads;                        /* Thread handles             */
};

typedef struct __mcl_burstthread *      MCL_BURSTTHREAD;

/**** Types ****/

typedef int (*MCL_START_ROUTINE)(void *ThreadParameter);

/**** Global variables ****/

extern int                              MthThreads;
extern MCL_BURSTTHREAD                  BtEne;

/**** Prototypes ****/

#  ifdef __cplusplus
extern "C" {
#  endif

void                    AMMP_FASTCALL MCL_BarrierClose(MCL_BARRIER Bh);
MCL_BARRIER             AMMP_FASTCALL MCL_BarrierCreate(int Count);
void                    AMMP_FASTCALL MCL_BarrierWait(MCL_BARRIER Bh);
void                    AMMP_FASTCALL MCL_BurstThreadClose(MCL_BURSTTHREAD hCtx);
MCL_BURSTTHREAD         AMMP_FASTCALL MCL_BurstThreadCreate(int Cpus);
void                    AMMP_FASTCALL MCL_BurstThreadRun(MCL_BURSTTHREAD hCtx, int (*Routine)(void *), void *Args);
void                    AMMP_FASTCALL MCL_CloseMutex(void);
int                     AMMP_FASTCALL MCL_CreateMutex(void);
int                     AMMP_FASTCALL MCL_CreateThreads(int, int (*)(void *), void *, int);
void                    AMMP_FASTCALL MCL_EventClose(MCL_EVENT hEvent);
MCL_EVENT               AMMP_FASTCALL MCL_EventCreate(int ManualReset, int InitialState);
void                    AMMP_FASTCALL MCL_EventReset(MCL_EVENT hEvent);
void                    AMMP_FASTCALL MCL_EventSet(MCL_EVENT hEvent);
void                    AMMP_FASTCALL MCL_EventWait(MCL_EVENT hEvent);
int                     AMMP_FASTCALL MCL_GetCPUs(void);
void                    AMMP_FASTCALL MCL_MutexClose(MCL_MUTEX Mtx);
MCL_MUTEX               AMMP_FASTCALL MCL_MutexCreate(void);
void                    AMMP_FASTCALL MCL_MutexOff(void);
void                    AMMP_FASTCALL MCL_MutexOffEx(MCL_MUTEX Mtx);
void                    AMMP_FASTCALL MCL_MutexOn(void);
void                    AMMP_FASTCALL MCL_MutexOnEx(MCL_MUTEX Mtx);
void                    AMMP_FASTCALL MCL_StartWait(void);
void                    AMMP_FASTCALL MCL_ThreadClose(MCL_THREAD ThreadHandle);

#  ifdef __cplusplus
}
#  endif
#endif

