/* nonbon.c
*
* collection of routines to service nonbonded potentials
*
* POOP (Poor-mans Object Oriented Programming) using scope rules
*
* the routines for potential value, force and (eventually) second
* derivatives are here also
*
* force and 2nd derivative routines assume zero'd arrays for output
* this allows for parralellization if needed (on a PC?)
*
* forces are symmetric - so we don't have to fuck around with
* s matrices and the like.
*
* note that the non-bonded information is in the ATOM structures 
*
*/
/*
*  copyright 1992 Robert W. Harrison
*  
*  This notice may not be removed
*  This program may be copied for scientific use
*  It may not be sold for profit without explicit
*  permission of the author(s) who retain any
*  commercial rights including the right to modify 
*  this notice
*/

#define ANSI 1
/* misc includes - ANSI and some are just to be safe */
#include <stdio.h>
#include <ctype.h>
#include <math.h>
#ifdef ANSI
#include <stdlib.h>
#endif
#include "ammp.h"
/* ATOM structure contains a serial number for indexing into
* arrays and the like (a Hessian)
* but otherwise is self-contained. Note the hooks for Non-nonboned potentials
*/

/* v_nonbon()
* this function sums up the potentials
* for the atoms defined in the nonbon data structure.
*/
/* standard returns 0 if error (any) 1 if ok
* V is the potential */
int v_nonbon( V, lambda )
	float *V,lambda;
{
	float r,r0,xt,yt,zt;
	float lcutoff,cutoff,get_f_variable();
	int inbond,inangle,i;
	ATOM *a1,*a2,*bonded[10],*angled[10];
	ATOM *a_next( ); /* returns first ATOM when called with -1 */

/* nonbonded potentials 
* do a double loop starting from the first atom to the 
* last 
* then from the second to the last 
* etc
*
* also check to avoid bonded and 1-3 bonded atoms
*/
	cutoff = get_f_variable("cutoff");
	if( cutoff < 1.) cutoff = 1.e10;
	lcutoff = -cutoff;
	a1 = a_next(-1);
	while( (a1->next != a1) && (a1->next != NULL))
	{
	a1 = a1->next;
	get_bond( a1,bonded,10,&inbond);
	get_angle( a1,angled,10,&inangle);
/*	a2 = a1->next; */
	a2 = a_next(-1);
	while(  (a2->next != a2) && (a2->next != NULL))
	{
/* goto SKIP is used because this is one case where it makes sense */
	for(i = 0; i< inbond; i++)
		if( a2 == bonded[i]) goto SKIP;
	for(i = 0; i< inangle; i++)
		if( a2 == angled[i]) goto SKIP;
/* non - bonded are only used when the atoms arent bonded */

	if( lambda == 0.)
	{
	xt = (a1->x - a2->x);
	if( (xt > cutoff) || (xt < lcutoff) ) goto SKIP;
	yt =  (a1->y - a2->y);
	if( (yt > cutoff) || (yt < lcutoff) ) goto SKIP;
	zt =  (a1->z - a2->z);
	if( (zt > cutoff) || (zt < lcutoff) ) goto SKIP;
	} else
	{
	xt = (a1->x - a2->x +lambda*(a1->dx - a2->dx));
	if( (xt > cutoff) || (xt < lcutoff) ) goto SKIP;
	yt = (a1->y - a2->y +lambda*(a1->dy - a2->dy));
	if( (yt > cutoff) || (yt < lcutoff) ) goto SKIP;
	zt = (a1->z - a2->z +lambda*(a1->dz - a2->dz));
	if( (zt > cutoff) || (zt < lcutoff) ) goto SKIP;
	}
	r = xt*xt+yt*yt+zt*zt;
	if( r < 1.) r = 1.; 
	r0 = sqrt(r); r = r*r*r ;
/* debugging
*	printf(" %d %d %f %f %f \n", a1->serial,a2->serial,a1->q,a2->q,
*	332.17752*a1->q*a2->q/r0);
*/
	 *V += 332.17752*a1->q*a2->q/r0; 
	*V -= a1->a*a2->a/r;
	*V += a1->b*a2->b/r/r; 
SKIP:
	if( a2->next == a1) break;
	a2 = a2->next;
	}
	}
	return 1;

}
/* f_nonbon()
*
* f_nonbon increments the forces in the atom structures by the force
* due to the nonbon components.  NOTE THE WORD increment.
* the forces should first be zero'd.
* if not then this code will be invalid.  THIS IS DELIBERATE.
* on bigger (and better?) machines the different potential terms
* may be updated at random or in parrellel, if we assume that this routine
* will initialize the forces then we can't do this.
*/
int f_nonbon(lambda)
float lambda;
/*  returns 0 if error, 1 if OK */
{
	float ux,uy,uz;
	float k,r,r0,xt,yt,zt;
	float lcutoff,cutoff,get_f_variable();
	int inbond,inangle,i;
	ATOM *a1,*a2,*bonded[10],*angled[10];
	ATOM *a_next( ); /* returns first ATOM when called with -1 */

/* nonbonded potentials 
* do a double loop starting from the first atom to the 
* last 
* then from the second to the last 
* etc
*
* also check to avoid bonded and 1-3 bonded atoms
*/
	cutoff = get_f_variable("cutoff");
	if( cutoff < 1.) cutoff = 1.e10;
	lcutoff = -cutoff;
	a1 = a_next(-1);
	while( (a1->next != a1) && (a1->next != NULL))
	{
	a1 = a1->next;
	get_bond( a1,bonded,10,&inbond);
	get_angle( a1,angled,10,&inangle);
	a2 = a_next(-1);
	while( (a2->next != a2) && (a2->next != NULL))
	{
/* goto SKIP is used because this is one case where it makes sense */
	for(i = 0; i< inbond; i++)
		if( a2 == bonded[i]) goto SKIP;
	for(i = 0; i< inangle; i++)
		if( a2 == angled[i]) goto SKIP;
/* non - bonded are only used when the atoms arent bonded */

	if( lambda == 0.)
	{
	ux = (a2->x - a1->x);
	if( (ux > cutoff) || (ux < lcutoff) ) goto SKIP;
	uy = (a2->y - a1->y);
	if( (uy > cutoff) || (uy < lcutoff) ) goto SKIP;
	uz = (a2->z - a1->z);
	if( (uz > cutoff) || (uz < lcutoff) ) goto SKIP;
	}else{
	ux = (a2->x -a1->x +lambda*(a2->dx-a1->dx));
	if( (ux > cutoff) || (ux < lcutoff) ) goto SKIP;
	uy = (a2->y -a1->y +lambda*(a2->dy-a1->dy));
	if( (uy > cutoff) || (uy < lcutoff) ) goto SKIP;
	uz = (a2->z -a1->z +lambda*(a2->dz-a1->dz));
	if( (uz > cutoff) || (uz < lcutoff) ) goto SKIP;
	}
	r = ux*ux + uy*uy + uz*uz;
	 /* watch for FP errors*/
	 if( r <= 1.)
	 { r = 1.; }
	r0 = sqrt(r); ux = ux/r0; uy = uy/r0; uz = uz/r0;
	 k = -332.17752*a1->q*a2->q/r; 
	r = r*r*r;
	k += a1->a*a2->a/r/r0*6;
	k -= a1->b*a2->b/r/r/r0*12;

	a1->fx += ux*k; 
	a1->fy += uy*k; 
	a1->fz += uz*k; 
	a2->fx -= ux*k; 
	a2->fy -= uy*k; 
	a2->fz -= uz*k;
SKIP:

	if( a2->next == a1) break;
	a2 = a2->next;
	}
	}
	return 1;

}
