
/***************************************
**** AMMP - Math constants & macros ****
***************************************/


#ifndef __AMMP_NUMERIC_H
#  define  __AMMP_NUMERIC_H

#  define  PI_DP                        3.1415926535897932384626433

#  ifdef AMMP_DOUBLE_PRECISION

#    define  zero                       0.0
#    define  one                        1.0
#    define  two                        2.0
#    define  three                      3.0
#    define  four                       4.0
#    define  five                       5.0
#    define  six                        6.0
#    define  seven                      7.0
#    define  eight                      8.0
#    define  nine                       9.0
#    define  twelve                     12.0
#    define  hundred                    100.0

#    define  half                       0.5
#    define  third                      (1.0 / 3.0)
#    define  fourth                     0.25
#    define  eightth                    (1.0 / 8.0)
#    define  fourteenth                 (1.0 / 14.0)

/**** Constants ****/

#    define  BOHR                       0.5291771
#    define  DIEL_MAX                   1.e10
#    define  ROOTHALF                   0.7071067811865475244008444
#    define  ROOT2                      1.4142135623730950488016887
#    define  PI                         3.1415926535897932384626433
#    define  Q_CONST                    332.17752
#    define  TWOPI                      6.2831853071795864769252866
#    define  ROOTPI                     1.7724538509055160272981674
#    define  HARTREE                    627.725
#    define  INVBOHR                    1.8897265
#    define  TOO_SMALL                  1.e-8

/**** Macros ****/

#    define  AMMP_DEG_TO_RAD(X)         (((X) * PI) / 180.0)
#    define  AMMP_RAD_TO_DEG(X)         (((X) * 180.0) / PI)

#  else

#    define  zero                       0.0f
#    define  one                        1.0f
#    define  two                        2.0f
#    define  three                      3.0f
#    define  four                       4.0f
#    define  five                       5.0f
#    define  six                        6.0f
#    define  seven                      7.0f
#    define  eight                      8.0f
#    define  nine                       9.0f
#    define  twelve                     12.0f
#    define  hundred                    100.0f

#    define  half                       0.5f
#    define  third                      (1.0f / 3.0f)
#    define  fourth                     0.25f
#    define  eightth                    (1.0f / 8.0f)
#    define  fourteenth                 (1.0f / 14.0f)

/**** Constants ****/

#    define  BOHR                       0.52917710f
#    define  DIEL_MAX                   1.e10f
#    define  ROOTHALF                   0.70710678f
#    define  ROOT2                      1.41421356f
#    define  PI                         3.14159265f
#    define  Q_CONST                    332.177520f
#    define  TWOPI                      6.28318530f
#    define  ROOTPI                     1.77245385f
#    define  HARTREE                    627.725000f
#    define  INVBOHR                    1.88972650f
#    define  TOO_SMALL                  1.e-8f

/**** Macros ****/

#    define  AMMP_DEG_TO_RAD(X)         (((X) * PI) / 180.0f)
#    define  AMMP_RAD_TO_DEG(X)         (((X) * 180.0f) / PI)
#  endif
#endif

