
#ifndef __AMMP_ORBITAL_H
#  define  __AMMP_ORBITAL_H


#  define  Or1          0       /* 1 center 1s */
#  define  Or1o         1       /* 1 center 1s arbitrary origin */
#  define  Or2          2       /* 2 center (on a bond) 1s */
#  define  Or3          3       /* 3 center (on an angle diagonal) 1s */
#  define  Or4s         4       /* 4 center unsymmetric (one sided) on a plane normal (ie nitrogen) */
#  define  Or4p         6       /* 4 center symmetric (one sided) on a plane normal  */
#  define  Orm          5       /* multicentered on atoms (i.e. pi orbital for benzene) */

typedef struct {
  int                   osn;            /* Orbital serial number              */
  int                   type;           /* Orbital type (see above)           */
  int                   ncenter;
  AMMP_ATOM *           myatom;
  AMMP_ATOM *           a1;             /* Orbits to define geometry          */
  AMMP_ATOM *           a2;
  AMMP_ATOM *           a3;
  AMMP_ATOM *           a4;
  AMMP_ATOM *           a5;
  float                 normal;         /* Self-term in the normalization         */
  float                 along;          /* Fraction along geometry direction      */
  float                 along2;
  float                 x, y, z;        /* Origin offset or normal direction      */
  float                 rx[6];          /* My origin in full space                */
  float                 ry[6];
  float                 rz[6];
  float                 rx1, ry1, rz1;  /* Second origin in full space (for Or4p) */
  int                   spin;           /* Spin (any)                             */
  int                   phase;          /* Phase of Or4p only                     */
  int                   ipair;
  int                   n;              /* How many terms                         */
  int                   active;
  float                 a[6], r[6];     /* My weights and radii for gaussians     */
  float                 rl[6];
  void *                next;
  void *                gang;
} ORBITAL ;

/**** Function types ****/

typedef float (AMMP_FASTCALL *AMMP_OFUNC)(ORBITAL *);

/**** Protptypes ****/

float           AMMP_FASTCALL Basic_INDO_Ritz_product(ORBITAL *odummy);
float           AMMP_FASTCALL Basic_Ritz_product(ORBITAL *odummy);
int             AMMP_FASTCALL dscf_fit_q(float total);
void            AMMP_FASTCALL dscf_krymin(float *where[], int n, float is, AMMP_OFUNC what, AMMP_OFUNC forgrad, FILE *output, int nstep);
float           AMMP_FASTCALL dscf_line(float search[], float *where[], float params[], int n, AMMP_OFUNC what, void *whom);
void            AMMP_FASTCALL dscf_make_map(int type, FILE *where, float grid, float guard);
float           AMMP_FASTCALL dscf_map_ED(float x, float y, float z);
float           AMMP_FASTCALL dscf_map_empirical(float x, float y, float z);
float           AMMP_FASTCALL dscf_map_field(float x, float y, float z);
void            AMMP_FASTCALL dscf_map_setup(void);
void            AMMP_FASTCALL dump_orbit(FILE *outp);
int             AMMP_FASTCALL expand(int osn, int n, float a1, float b1, float a2, float b2, float a3, float b3, float a4, float b4, float a5, float b5, float a6, float b6);
float           AMMP_FASTCALL Fzero(float x);
float           AMMP_FASTCALL Just_Ritz_product(ORBITAL *odummy);
float           AMMP_FASTCALL INDOphiH4phi(ORBITAL *o1, ORBITAL *o4, float prenorm, float cutoff);
float           AMMP_FASTCALL INDO_Ritz_product(ORBITAL *odummy);
float           AMMP_FASTCALL Loose_Ritz_product(ORBITAL *odummy);
float           AMMP_FASTCALL nuclear(void);
int             AMMP_FASTCALL orbital(int type, int i1, int i2, int i3, int i4, int i5, int i6, int osn, float along, float x, float y, float z , int spin, int pair);
ORBITAL *       AMMP_FASTCALL o_next(int flag);
int             AMMP_FASTCALL o_number(void);
ORBITAL *       AMMP_FASTCALL o_m_serial(int serial);
void            AMMP_FASTCALL o_update_normals(void);
float           AMMP_FASTCALL phiH2phi(ORBITAL *o1, ORBITAL *o2, float prenorm);
float           AMMP_FASTCALL phiH4phi(ORBITAL *o1, ORBITAL *o4, float prenorm);
float           AMMP_FASTCALL phiphi(ORBITAL *o1, ORBITAL *o2);
float           AMMP_FASTCALL QandDphiH4phi(ORBITAL *o1, ORBITAL *o4, float prenorm);
void            AMMP_FASTCALL renormalize(void);
int             AMMP_FASTCALL report(FILE *out);
float           AMMP_FASTCALL Ritz_product(ORBITAL *odummy);
float           AMMP_FASTCALL tight_INDO_Ritz_product(ORBITAL *odummy);
float           AMMP_FASTCALL total_orbit_norm(void);

#endif



