/* pipeio.c
*  write messages to the iopipe
*
* general format
* nmessage, (type, params),...
*
* exit message (type -1)
*  exit grfx
*
* atom message (type 0)
*  id,x,y,z   (int,float,float,float) id == serial number 
*
* color message (type 1)
*  id,red,green,blue  int,float,float,float  
*
* connect message (type 2)
*  id1,id2       int,int
*
* label message (type 3)
* id,length,c1,...,cn (truncated if too long )
*
* eof message (type 4)
* tell grfx that entire molecule has been loaded
*
*  exit message (any undefined message ) will use type -1
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>

#include "ammp.h"

/* defined in grammp.c */
#include "dsc.h"
void send_terminate(void);
void send_xyz( ATOM *);
void send_color( ATOM *);
void send_label( ATOM *);
void send_connect( int,int);
void send_tether(int,float,float,float,float);
void send_noel(int,int,float,float,float,float,float);

void send_terminate()
{
	int i; 
	i = -1;
	WriteToGrfx(&i,sizeof(int));
}

void send_xyz(ATOM *ap)
{
	int j;
	j = 0;
	WriteToGrfx(&j,sizeof(int));
	WriteToGrfx(&ap->serial,sizeof(int));
	WriteToGrfx(&ap->x,sizeof(float));
	WriteToGrfx(&ap->y,sizeof(float));
	WriteToGrfx(&ap->z,sizeof(float));
}


void send_color(ATOM *ap)
{
	int j;
	float rmsf,x;

	j = 1;
	WriteToGrfx(&j,sizeof(int));
	WriteToGrfx(&ap->serial,sizeof(int));
	rmsf = sqrt(ap->fx*ap->fx + ap->fy*ap->fy + ap->fz*ap->fz);
/* atom will be white when no force and blend to red */
	x = 1.;
	WriteToGrfx(&x,sizeof(float));
	x = 10./(10. + rmsf);
	WriteToGrfx(&x,sizeof(float));
	x = 1./(1.+rmsf);
	WriteToGrfx(&x,sizeof(float));
}


void send_connect(int i1,int i2)
{
	int j;

	j = 2;
	WriteToGrfx(&j,sizeof(int));
	j = i1;
	WriteToGrfx(&j,sizeof(int));
	j = i2;
	WriteToGrfx(&j,sizeof(int));
}


void send_label(ATOM *ap)
{  	int j;
	int k;
	char message[10];

	j = 3;
	WriteToGrfx(&j,sizeof(int));

	for(k=0; k< 9;k++)
	{
		message[k] = ap->name[k];
		if( message[k] == '\0' ) break;	
	}
	message[10] = '\0';
	WriteToGrfx(&ap->serial,sizeof(int));
	WriteToGrfx(&k,sizeof(int));
	for( j = 0; j< k; j++)
		WriteToGrfx(&message[j],sizeof(char));
}


void send_eof()
{
	int i;

	i=1;
	WriteToGrfx(&i,sizeof(int));
	i=4;
	WriteToGrfx(&i,sizeof(int));
}


void send_tether(int id,float k, float x, float y, float z)
{
    int j;
	float junk;

	j=1;
	WriteToGrfx(&j,sizeof(int));
    j = 5;
    WriteToGrfx(&j,sizeof(int));
    j = id;
    WriteToGrfx(&j,sizeof(int));
    junk = k;
    WriteToGrfx(&junk,sizeof(float));
    junk = x;
    WriteToGrfx(&junk,sizeof(float));
    junk = y;
    WriteToGrfx(&junk,sizeof(float));
    junk = z;
    WriteToGrfx(&junk,sizeof(float));
#ifdef DEBUG
	printf("send_tether(%d,%f,%f,%f,%f)\n",id,fk,x,y,z);
#endif
}

void send_noel(int id1,int id2,float d,float dm,float dh,float km,float kh)
{
    int j;
    float junk;

    j=1;
    WriteToGrfx(&j,sizeof(int));
    j = 6;
    WriteToGrfx(&j,sizeof(int));
    j = id1;
    WriteToGrfx(&j,sizeof(int));
    j = id2;
    WriteToGrfx(&j,sizeof(int));
    junk = d;
    WriteToGrfx(&junk,sizeof(float));
    junk = dm;
    WriteToGrfx(&junk,sizeof(float));
    junk = dh;
    WriteToGrfx(&junk,sizeof(float));
    junk = km;
    WriteToGrfx(&junk,sizeof(float));
    junk = kh;
    WriteToGrfx(&junk,sizeof(float));
#ifdef DEBUG
    printf("send_noel(%d,%d,%f,%f,%f,%f,%f)\n",id1,id2,d,dm,dh,km,kh);
#endif
}
