/* random number generators for ammp
*
*  randf() returns float in the range from 0 - 1.
*  randg() returns float gaussian distr sigma = 1
*  rand3( float *x1,*x2,*x3)  returns random unit 3vector
*/
/*
*  copyright 1992 Robert W. Harrison
*  
*  This notice may not be removed
*  This program may be copied for scientific use
*  It may not be sold for profit without explicit
*  permission of the author(s) who retain any
*  commercial rights including the right to modify 
*  this notice
*/

#include <math.h>
#include "ammp.h"

/**** Local variables ****/

static int      randf_ip = 0;
static int      randf_jp = 0;


/**** Reset local variables ****/

void AMMP_FASTCALL ResetRandom(void)
{
  randf_ip = 0;
  randf_jp = 0;
}


/**** Generate a random number ****/

float AMMP_FASTCALL randf(void)
{
  float         xva;
  int           i, seed;
  static float  buff[55];
  static int    kp;

  if ((randf_ip == 0) && (randf_jp == 0)) {
    seed = get_i_variable("seed");
    for(i = 0; i < 55; i++) {
      seed    = (seed * 2349 + 14867) % 32767;
      buff[i] = (float)seed / 32767.0f;
      if (buff[i] > one ) buff[i] = buff[i] - one;
      if (buff[i] < zero) buff[i] = buff[i] + one;
    } /* End of for (i) */
    randf_ip = 24;
//    randf_jp = 55 - randf_ip;
    randf_jp = 54;
    kp       = 0;
  }
  i   = kp;
  xva = buff[randf_jp] + buff[randf_ip];
  if (xva > one) xva = xva - one;
  buff[kp] = xva;
  kp       = (kp       + 1) % 55;
  randf_ip = (randf_ip + 1) % 55;
  randf_jp = (randf_jp + 1) % 55;

  return buff[i];
}


/* randg()
* return random guassian with unit sigma 
*
* use the polar method (see knuth) with a slight twist.
*
* rwh 5792
*/

float AMMP_FASTCALL randg(void)
{
  float         x1, x2;

  float         norm = two;

  while(norm > one) {
    x1   = two * randf() - one;
    x2   = two * randf() - one;
    norm = x1 * x1 + x2 * x2;
  } /* End of while */

  if (norm < 1.e-9) norm = 1.e-9;
  return (x1 * sqrt(-two * log(norm) / norm ));
}

/* rand3( float *x,*y,*z)
*
* return a random unit three vector
* use knop's method (knuth v.2,p131)
*
* rwh 5/7/92
*/

void AMMP_FASTCALL rand3(float *x, float *y, float *z)
{
  float         alpha, x1, x2;

  float         norm = 2.;

  while(norm > 1.0f) {
    x1   = 2.0f * randf() - 1.0f;
    x2   = 2.0f * randf() - 1.0f;
    norm = x1 * x1 + x2 * x2;
  } /* End of while */

  alpha = 2.0f * sqrt(1.0f - norm);
  *x = x1 * alpha;
  *y = x2 * alpha;
  *z = 2.0f * norm - 1.0f;
}

