
/********************************************
****          Ammp  Starter 1.2          ****
**** (c) 2006-2012, Alessandro Pedretti  ****
********************************************/


#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <sys\stat.h>

#define  DXWCPU_C
#include <dxwcpu.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#  pragma argsused
#endif

/**** Types ****/

typedef BOOL (WINAPI *LPFN_ISWOW64PROCESS)(HANDLE, PBOOL);

/**** Prototypes ****/

void            Error(const char *Msg);
int             Exists(const char *FileName);
int             IsWow64(void);


/**** Main code ****/

int main(int argc, char* argv[])
{
  char *                        Env;
  char *                        Ptr;
  char *                        Sep;
  char                          PrgPath[MAX_PATH];
  DXWCPU                        Cpu;
  STARTUPINFO                   Si;
  PROCESS_INFORMATION           Pi;
  int                           Exe64;

  DXWCPU_GetInfo(&Cpu);
  printf("%d %s detected\n", Cpu.m_CPU_Number, Cpu.m_ProcName, Ptr);

  if ((Env = getenv("VEGADIR")) == NULL) {
    GetModuleFileName(GetModuleHandle(NULL), PrgPath, MAX_PATH);
    Sep = NULL;
    for(Ptr = PrgPath; *Ptr; ++Ptr)
      if (*Ptr == '\\') Sep = Ptr;
    if (Sep) Sep[1] = 0;
  } else strcpy(PrgPath, Env);

  Ptr = PrgPath + strlen(PrgPath) - 1;
  if (*Ptr != '\\') {
    *++Ptr = '\\';
    *++Ptr = 0;
  } else ++Ptr;

  if (!Env) {
    strcat(PrgPath, "..\\..\\");
    Ptr += 6;
  }
  strcat(PrgPath, "Bin\\Win64\\Ammp.exe");

  if (IsWow64()) {
    if (Exists(PrgPath)) {
      Exe64 = 1;
      goto Ready;
    }
  }

  Ptr[7] = '3';
  Ptr[8] = '2';
  if (!DXWCPU_FindFile(&Cpu, PrgPath))
    Error("Can't find the Ammp executable");
  Exe64 = 0;

Ready:

  printf("Using %d bit version\n\n", Exe64 ? 64 : 32);

  /**** Create the new process ****/

  ZeroMemory(&Si, sizeof(STARTUPINFO));
  Si.cb          = sizeof(STARTUPINFO);
  Si.dwFlags     = STARTF_USESHOWWINDOW|STARTF_USESTDHANDLES;
  Si.wShowWindow = SW_HIDE;
  Si.hStdInput   = GetStdHandle(STD_INPUT_HANDLE);
  Si.hStdOutput  = GetStdHandle(STD_OUTPUT_HANDLE);
  Si.hStdError   = GetStdHandle(STD_ERROR_HANDLE);

  if (!CreateProcess(NULL, PrgPath, NULL, NULL, true, 0, NULL,
                     NULL, &Si, &Pi))
    Error("Can't create the process");

  SetPriorityClass(Pi.hProcess, BELOW_NORMAL_PRIORITY_CLASS);
  WaitForSingleObject(Pi.hProcess, INFINITE);
  CloseHandle(Pi.hProcess);
  CloseHandle(Pi.hThread );

  return 0;
}


/**** Print an error message ****/

void Error(const char *Msg)
{
  fprintf(stderr, "ERROR: %s.\n\n", Msg);

  exit(0);
}


/**** Check if the file exists ****/

int Exists(const char *FileName)
{
  struct stat           St;

  if (stat(FileName, &St)) return FALSE;

  return (St.st_mode & S_IFREG);
}


/**** Check if it's WoW64 ****/

int IsWow64(void)
{
  BOOL                  bIsWow64         = FALSE;
  LPFN_ISWOW64PROCESS   fnIsWow64Process = (LPFN_ISWOW64PROCESS)GetProcAddress(
                                            GetModuleHandle("kernel32"), "IsWow64Process");

  if ((fnIsWow64Process) &&
      (fnIsWow64Process(GetCurrentProcess(), &bIsWow64)))
    return bIsWow64;

  return FALSE;
}

