/* swarm.c
*
*
*  A set of distances is restrained to the mean value
*  not quite sure yet wether to use sigma weights
*
*  this is another way of enforcing regularity in polymers
*  and may well be easier and better than the SPIN ideas.
*  It is mathematically a similar concept, but a rather
*  different implementation.
*
*
* collection of routines to service SWARM length potentials
*
* POOP (Poor-mans Object Oriented Programming) using scope rules
*
* these routines hold a data base (in terms of array indeces)
* of SWARM bonds, with the associated length and force constants
*
* (this could be table driven but what the hell memories cheap)
*
* the routines for potential value, force and (eventually) second
* derivatives are here also
*
* force and 2nd derivative routines assume zero'd arrays for output
* this allows for parralellization if needed (on a PC?)
*
* forces are bond wise symmetric - so we don't have to fuck around with
* s matrices and the like.
*/
/*
*  copyright 1999 Robert W. Harrison
*
*  This notice may not be removed
*  This program may be copied for scientific use
*  It may not be sold for profit without explicit
*  permission of the author(s) who retain any
*  commercial rights including the right to modify
*  this notice
*/

#include <stdio.h>
#include <stdlib.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#  include <fastmath.h>
#else
#  include <math.h>
#endif

#include "ammp.h"


/**** Add a new swarm ****/

int AMMP_FASTCALL swarm(float k, int n, int p1, int p2, int p3, int p4, int p5, int p6, int p7, int p8)
{
  SWARM         *new_p;
  int           i, ip[8];

  /**** Get the atom pointers for the two serial numbers ****/

  if ((new_p =(SWARM *)Alloca(sizeof(SWARM), "swarm()") ) == NULL)
    return FALSE;

  ip[0] = p1;
  ip[1] = p2;
  ip[2] = p3;
  ip[3] = p4;
  ip[4] = p5;
  ip[5] = p6;
  ip[6] = p7;
  ip[7] = p8;

  for(i = 0; i < n; i++) {
    new_p -> atoms[i] = a_m_serial(ip[i]);
    if (new_p -> atoms[i] == NULL) {
      aaerror("Undefined atom in SWARM term");
      free(new_p);
      return FALSE;
    }
  } /* End of for (i) */


  /**** Initialize the pointers ****/

  if (SWARM_first == NULL) SWARM_first = new_p;
  if (SWARM_last  == NULL) SWARM_last = new_p;

  new_p -> k         = k;
  new_p -> n         = n;
  new_p -> next      = new_p;
  SWARM_last -> next = new_p;
  SWARM_last         = new_p;

  return TRUE;
}


/* v_swarm()
* this function sums up the potentials
* for the atoms defined in the SWARM data structure.
*/
/* standard returns 0 if error (any) 1 if ok
* V is the potential */

int AMMP_FASTCALL v_swarm(float *V, float lambda)
{
	SWARM *bp;
	float r;
/*        float xt,yt,zt; */
	float rmean;
	float dx,dy,dz;
	AMMP_ATOM *a1,*a2;
	int i;


	bp = SWARM_first;
       if( bp == NULL ) return 1;
       while(1)
       {
	if( bp == NULL) return 0;
/*	xt = 0.; yt = 0.; zt = 0.; */
	rmean = 0.;
	for( i=0; i< bp->n; i+=2)
	{
	a1 = bp->atoms[i];
	a2 = bp->atoms[i+1];
	if( lambda == 0.)
	{
	dx = a2->x - a1->x;
	dy = a2->y - a1->y;
	dz = a2->z - a1->z;
	} else	{
	dx = (a2->x -a1->x +lambda*(a2->dx-a1->dx));
	dy = (a2->y -a1->y +lambda*(a2->dy-a1->dy));
	dz = (a2->z -a1->z +lambda*(a2->dz-a1->dz));
	}
	rmean = rmean+ sqrt(dx*dx + dy*dy + dz*dz);
	}/* for i */
	rmean = (rmean+rmean)/bp->n;
	for( i=0; i< bp->n ; i+= 2)
	{
			a1 = bp->atoms[i];
			a2 = bp->atoms[i+1];
			if( lambda == 0.)
			{
				dx = a2->x - a1->x;
				dy = a2->y - a1->y;
				dz = a2->z - a1->z;
			} else	{
				dx = (a2->x -a1->x +lambda*(a2->dx-a1->dx));
				dy = (a2->y -a1->y +lambda*(a2->dy-a1->dy));
				dz = (a2->z -a1->z +lambda*(a2->dz-a1->dz));
			}

		r = sqrt(dx*dx +dy*dy + dz*dz);
		*V += bp->k*(rmean-r)*(rmean -r);
	}/* i */
	if( bp == bp->next ) return 1;
	bp = bp->next;
	  }
}

/* f_swarm()
*
* f_swarm increments the forces in the atom structures by the force
* due to the SWARM components.  NOTE THE WORD increment.
* the forces should first be zero'd.
* if not then this code will be invalid.  THIS IS DELIBERATE.
* on bigger (and better?) machines the different potential terms
* may be updated at random or in parrellel, if we assume that this routine
* will initialize the forces then we can't do this.
*/

int AMMP_FASTCALL f_swarm(float lambda)
/*  returns 0 if error, 1 if OK */
{
	SWARM *bp;
	float xt,yt,zt,dx,dy,dz;
	float r,k,ux,uy,uz,dV,rmean;
	AMMP_ATOM *a1,*a2;
	int i;


	bp = SWARM_first;
       if( bp == NULL ) return 1;
       while(1)
       {
	if( bp == NULL) return 0;




/*	xt = 0.; yt = 0.; zt = 0.; */
	rmean = 0.0f;
	for( i=0; i< bp->n; i+=2)
	{
	a1 = bp->atoms[i];
	a2 = bp->atoms[i+1];
	if( lambda == 0.)
	{
	dx = a2->x - a1->x;
	dy = a2->y - a1->y;
	dz = a2->z - a1->z;
	} else	{
	dx = (a2->x -a1->x +lambda*(a2->dx-a1->dx));
	dy = (a2->y -a1->y +lambda*(a2->dy-a1->dy));
	dz = (a2->z -a1->z +lambda*(a2->dz-a1->dz));
	}
	rmean += sqrt(dx*dx + dy*dy + dz*dz);
	}/* i */
	rmean = (rmean + rmean )/bp->n;
	k = 2.*bp->k*(1.-1./(float)bp->n);
	for( i=0; i < bp->n; i+= 2)
	{
	a1 = bp->atoms[i];
	a2 = bp->atoms[i+1];
	if( lambda == 0.)
	{
	dx = a2->x - a1->x;
	dy = a2->y - a1->y;
	dz = a2->z - a1->z;
	} else	{
	dx = (a2->x -a1->x +lambda*(a2->dx-a1->dx));
	dy = (a2->y -a1->y +lambda*(a2->dy-a1->dy));
	dz = (a2->z -a1->z +lambda*(a2->dz-a1->dz));
	}
	xt = dx; yt = dy; zt = dz;
/*	*V += bp->k*( target -r)*(target -r); */
	r = sqrt(xt*xt + yt*yt + zt*zt);
	dV = k *(r-rmean );
	if( r > 1.e-7) r = 1./r;
	ux = dV*xt*r;
	uy = dV*yt*r;
	uz = dV*zt*r;

	if( a1->active){
	a1->fx += ux;
	a1->fy += uy;
	a1->fz += uz;
	}
	if( a2->active){
	a2->fx -= ux;
	a2->fy -= uy;
	a2->fz -= uz;
	}

	}/* i */

	if( bp == bp->next ) return 1;
	bp = bp->next;
	}
}


/**** Dump swarms ****/

void AMMP_FASTCALL dump_swarms(FILE *where)
{
  int           i;

  SWARM         *b = SWARM_first;

  while(b) {
    fprintf(where, "swarm %f %d ", b -> k, b -> n);
    for(i = 0; i < b -> n; i++)
      fprintf(where, "%d ", b -> atoms[i] -> serial);

    fprintf(where, ";\n");
    if (b == b -> next) break;
    b = b -> next;
  } /* End of while */
}


int AMMP_FASTCALL a_swarm(float *V, float lambda, int ilow, int ihigh, FILE *op)
{
  AMMP_ATOM     *a1, *a2;
  float         xt, yt, dx, dy, dz, rmean, r;
  int           i, j;

  SWARM         *bp = SWARM_first;

  if (!bp) return TRUE;

  while(1) {
    if( bp == NULL) return FALSE;
    j = FALSE;
    for(i = 0; i < bp -> n; i++) {
      a1 = bp -> atoms[i];
      if ((a1 -> serial >= ilow) && (a1 -> serial <= ihigh)) {
        j = TRUE;
        break;
      }
    } /* End of for (i) */

    if (j) {
      xt    = 0.0f; /* yt = 0.; zt = 0.; */
      rmean = 0.0f;
      for(i = 0; i < bp -> n; i += 2) {
        a1 = bp -> atoms[i    ];
        a2 = bp -> atoms[i + 1];
        if (lambda) {
          dx = a2 -> x - a1 -> x + lambda * (a2 -> dx - a1 -> dx);
	  dy = a2 -> y - a1 -> y + lambda * (a2 -> dy - a1 -> dy);
	  dz = a2 -> z - a1 -> z + lambda * (a2 -> dz - a1 -> dz);
        } else {
          dx = a2 -> x - a1 -> x;
          dy = a2 -> y - a1 -> y;
          dz = a2 -> z - a1 -> z;
	}
	rmean += sqrt(dx * dx + dy * dy + dz * dz);
      } /* End of for (i) */

      rmean = (rmean + rmean) / bp -> n;
      for(i = 0; i < bp -> n; i += 2) {
        a1 = bp -> atoms[i    ];
        a2 = bp -> atoms[i + 1];
        if (lambda) {
          dx = a2 -> x - a1 -> x + lambda * (a2 -> dx - a1 -> dx);
	  dy = a2 -> y - a1 -> y + lambda * (a2 -> dy - a1 -> dy);
	  dz = a2 -> z - a1 -> z + lambda * (a2 -> dz - a1 -> dz);
        } else {
          dx = a2 -> x - a1 -> x;
          dy = a2 -> y - a1 -> y;
          dz = a2 -> z - a1 -> z;
	}
	r   = sqrt(dx * dx + dy * dy + dz * dz);
	yt  = bp -> k * (r - rmean) * (r - rmean);
	*V += yt;
	xt += yt;
      } /* End of for (i) */

      fprintf(op, "SWARM ");
      for(i = 0; i < bp -> n; i++) {
        a1 = bp -> atoms[i];
        fprintf(op, "%d ", a1 -> serial);
      } /* End of for (i) */
      fprintf(op, "Mean distance %f energy %f\n", rmean, xt);
    }

    if (bp == bp -> next) return TRUE;
    bp = bp -> next;
  } /* End of while */
}
