/* tailor.c
*
* collection of routines to service atom memory storage
*
* POOP (Poor-mans Object Oriented Programming) using scope rules
*
* these routines hold a data base (in terms of array indeces)
* of atoms, with the associated forces, and misc consts
*
* routines for tailoring nonbonded parameters during a run
*  tailor_qab
*  tailor_include
*  tailor_exclude
*
*/
/*
*  copyright 1992 1993 Robert W. Harrison
*  
*  This notice may not be removed
*  This program may be copied for scientific use
*  It may not be sold for profit without explicit
*  permission of the author(s) who retain any
*  commercial rights including the right to modify 
*  this notice
*/

#include <stdio.h>
#include <ctype.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#  include <fastmath.h>
#else
#  include <math.h>
#endif

#include "ammp.h"


void AMMP_FASTCALL tailor_qab(int who, float q, float a, float b)
{
AMMP_ATOM *ap;

ap = a_m_serial( who );
if( ap == NULL ) {aaerror("Undefined atom in tailor_qab()"); return;}
ap->q = q; ap->a = a; ap->b = b;
return;
}


void AMMP_FASTCALL tailor_include(int from, int to)
{
AMMP_ATOM *ap1,*ap2;
int i;
ap1 = a_m_serial( from );
if( ap1 == NULL ) {aaerror("Undefined atom in tailor_include()"); return;}
ap2 = a_m_serial( to );
if( ap2 == NULL ) {aaerror("Undefined atom in tailor_include()"); return;}

for( i=0; i< ap1->dontuse; i++)
{ if( ap1->excluded[i] == ap2) break; }
if( i < ap1->dontuse-1 ) 
{
	for(; i< ap1->dontuse-1; i++)
		{
		ap1->excluded[i] = ap1->excluded[i+1];
		ap1->exkind[i] = ap1->exkind[i+1];
		}
}
ap1->exkind[(ap1->dontuse)] = 0;
ap1->dontuse -= 1;
for( i=0; i< ap2->dontuse; i++)
{ if( ap2->excluded[i] == ap1) break; }
if( i < ap2->dontuse-1 ) 
{
	for(; i< ap2->dontuse-1; i++)
		{
		ap2->excluded[i] = ap2->excluded[i+1];
		ap2->exkind[i] = ap2->exkind[i+1];
		}
}
ap2->exkind[(ap2->dontuse)] = 0;
ap2->dontuse -= 1;

}

void AMMP_FASTCALL tailor_exclude(int from, int to)
{
  int           i;

  AMMP_ATOM *   ap1 = a_m_serial(from );
  AMMP_ATOM *   ap2 = a_m_serial(to   );

  if ((!ap1) || (!ap2)) {
    aaerror("Undefined atom in tailor_exclude()");
    return;
  }

  if (ap1 -> dontuse == NEXCLUDE) {
    aaerror("Can't add an atom to the exclude list");
    return;
  }

  for(i = 0; i < ap1->dontuse; i++) {
    if(ap1 -> excluded[i] == ap2) goto FOUND;
  } /* End of for (i) */

  ap1 -> exkind[ap1 -> dontuse]       = 1;
  ap1 -> excluded[(ap1 -> dontuse)++] = ap2;

FOUND:
  if (ap2 -> dontuse == NEXCLUDE) {
    aaerror("Can't add an atom to the exclude list");
    return;
  }

  for(i = 0; i < ap2->dontuse; i++) {
    if( ap2 -> excluded[i] == ap1) return;
  } /* End of for (i) */

  ap2 -> exkind[ap2 -> dontuse]     = 1;
  ap2 -> excluded[(ap2->dontuse)++] = ap1;

  i = get_i_variable("numtail");
  i = i + 1;
  set_i_variable("numtail", i);
}

