
/*******************************************
****     DxwCpuLib test application     ****
**** (c) 2002-2012, Alessandro Pedretti ****
*******************************************/


#include <stdio.h>

#ifdef __BORLANDC__
#  include <condefs.h>
#  pragma hdrstop
#  pragma argsused
#endif

#include "dxwcpu.h"


/**** Main code ****/

int main(int argc, char* argv[])
{
  char          **Suff;
  DXWCPU        Cpu;

  printf("Processors            : %d\n", Cpu.GetNumberOfCPUs());
  printf("Virtual CPU per proc. : %d\n", Cpu.GetNumberOfLogicalCPUs());
  printf("Vendor                : %s\n", Cpu.GetVendorString());
  printf("Name                  : %s\n", Cpu.GetCPUName());
  printf("Type                  : %d\n", Cpu.GetType());
  printf("Family                : %d\n", Cpu.GetFamily());
  printf("Model                 : %d\n", Cpu.GetModel());
  printf("Stepping              : %d\n", Cpu.GetStepping());
  printf("3DNow!                : %d\n", Cpu.CPU_Has_AMD3DNOW());
  printf("Enhanced 3DNow!       : %d\n", Cpu.CPU_Has_AMD3DNOWEXT());
  printf("SSE                   : %d\n", Cpu.CPU_Has_SSE());
  printf("SSE2                  : %d\n", Cpu.CPU_Has_SSE2());
  printf("HyperThreading        : %d\n", Cpu.CPU_Has_HT());

  /**** DLL suffixes ****/

  printf("DLL suffixes: ");

  Suff = Cpu.GetSuffix();
  while(*Suff) {
    printf("\"%s\" ", *Suff++);
  }
  printf("\n");


  return 0;
}
