#include "brk.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

#define BRKINFO 31
const float raggio_wdw[17]={1.55,0,0,0,0,0,0,0,0,0,0,1.4,1.35,1.88,0,0,1.81};

const char *amino[21]={"ALA","CYS","ASP","GLU","PHE","GLY","HIS",
                "ILE","LYS","LEU","MET","ASN","PRO","GLN",
                "ARG","SER","THR","VAL","TRP","TYR","PCA"};

struct tipo tab[19]={
        {14,14,"NH1",1},{14,14,"NH2",1},{8,8,"NZ ",1},
        {2,2,"OD1",2},{2,2,"OD2",2},{3,3,"OE1",2},
        {3,3,"OE2",2},{0,20,"N  ",3},{14,14,"NE ",3},
        {11,11,"ND2",3},{13,13,"NE2",3},{0,20,"O  ",4},
        {11,11,"OD1",4},{13,13,"OE1",4},{15,15,"OG ",5},
        {16,16,"OG1",5},{19,19,"OH ",5},{6,6,"ND1",5},{6,6,"NE2",5}
};

struct tipo_carica{char car,val;}car[7]=
        {{0,0},{1,2},{3,2},{1,1},{3,1},{2,1},{0,0}};

struct Brk* BrkNew(void)
{
	struct Brk* brk=(struct Brk*)malloc(sizeof(struct Brk));	
	brk->n_atoms=0;
}

void brk_copy(struct Brk* dest,const struct Brk* source)
{
   dest->n_atoms=source->n_atoms;
   dest->atom=(struct Atom*)calloc(dest->n_atoms,sizeof(struct Atom));
   if (dest->atom==NULL) {fprintf(stderr,"brk_copy\n");exit(1);}
   
   dest->mem=(char*)malloc(dest->n_atoms*BRKINFO);
   if (dest->mem==NULL) {fprintf(stderr,"brk_copy\n");exit(1);}
   memcpy(dest->atom,source->atom,dest->n_atoms*sizeof(struct Atom));
   memcpy(dest->mem,source->mem,dest->n_atoms*BRKINFO);
}

void brk_delete(struct Brk* brk)
{
   free(brk->mem);
   free(brk->atom);
}

void brk_read(char* name,struct Brk* brk)
{
	int i,j,k;
	int aminoacido,carica,found,ok;  
	char temp[32];
	char line [100];
	FILE *f; 

	f=fopen(name,"rb");
	if (f==NULL) {fprintf(stderr,"brk_read\n");exit(1);}   
	brk->n_atoms=0;
	while (!feof(f))
	{ 
		fgets(line,100,f);
		if (line[0]=='A') brk->n_atoms++;
		if (line[0]=='T') break;
	}
	brk->atom=(struct Atom*)calloc(brk->n_atoms,sizeof(struct Atom));
	if (brk->atom==NULL) {fprintf(stderr,"brk_read\n");exit(1);}
	brk->mem=malloc(brk->n_atoms*BRKINFO);
	if (brk->mem==NULL) {fprintf(stderr,"brk_read\n");exit(1);}
	
	rewind(f);
	for (i=0;i<brk->n_atoms;i++)
	{
		fgets(line,100,f);
		memcpy((brk->mem)+BRKINFO*i,line,BRKINFO);
	
		sscanf(line,"%31c %f %f %f",
			temp,&brk->atom[i].x,&brk->atom[i].y,&brk->atom[i].z);
		brk->atom[i].r=raggio_wdw[temp[13]-67];
        	for(found=0,j=0;j<21;j++)
		{
			for(ok=0,k=0;k<3;k++) 
				if(amino[j][k]==*(line+17+k)) ok++;
		        if (ok==3) {aminoacido=j;found=1;}
		}
		if (found==0) 
			{printf("Amino??? alla linea %d\n",i);aminoacido=5;}
		for (found=0,j=0;j<19;j++)
			if ((tab[j].i<=aminoacido)&&(tab[j].f>=aminoacido))
			{
				for(ok=0,k=0;k<3;k++) 
					if (tab[j].t[k]==*(line+13+k)) ok++;
				if (ok==3) {carica=tab[j].c;found=1;}
			}
		if (found==0) carica=6;
		brk->atom[i].carica=car[carica].car;
		brk->atom[i].valore=car[carica].val;
	} 
	fclose(f);
}

void brk_write(char* name,struct Brk* brk)
{
   int i;   
   FILE* f;
   char buffer[BRKINFO+1];

   f=fopen(name,"wb");
   for (i=0;i<brk->n_atoms;i++)
   {
	memcpy(buffer,(brk->mem)+i*BRKINFO,BRKINFO);	
	buffer[BRKINFO]='\0';
	fprintf(f,"%s%7.3f %7.3f %7.3f \n",buffer,brk->atom[i].x,brk->atom[i].y,brk->atom[i].z);
   }
   fprintf(f,"TER\n");	
   fclose(f);
}

void brk_translate(struct Brk* brk,float x,float y,float z)
{
   int i;
   for (i=0;i<brk->n_atoms;i++)
   {
      brk->atom[i].x+=x;brk->atom[i].y+=y;brk->atom[i].z+=z;
   }
}

void brk_x_rotate(struct Brk* brk,float rx)
{
   int i;
   float raggio,angolo;
   for (i=0;i<brk->n_atoms;i++)
   {
      raggio=sqrtf(brk->atom[i].z*brk->atom[i].z+brk->atom[i].y*brk->atom[i].y);
      angolo=rx+atan2f(brk->atom[i].y,brk->atom[i].z);
      brk->atom[i].z=raggio*cosf(angolo);
      brk->atom[i].y=raggio*sinf(angolo);
   }
}

void brk_y_rotate(struct Brk* brk,float ry)
{
   int i;
   float raggio,angolo;
   for (i=0;i<brk->n_atoms;i++)
   {
      raggio=sqrtf(brk->atom[i].z*brk->atom[i].z+brk->atom[i].x*brk->atom[i].x);
      angolo=ry+atan2f(brk->atom[i].x,brk->atom[i].z);
      brk->atom[i].z=raggio*cosf(angolo);
      brk->atom[i].x=raggio*sinf(angolo);
   }
}

void brk_z_rotate(struct Brk* brk,float rz)
{
   int i;
   float raggio,angolo;
   for (i=0;i<brk->n_atoms;i++)
   {
      raggio=sqrtf(brk->atom[i].x*brk->atom[i].x+brk->atom[i].y*brk->atom[i].y);
      angolo=rz+atan2f(brk->atom[i].y,brk->atom[i].x);
      brk->atom[i].x=raggio*cosf(angolo);
      brk->atom[i].y=raggio*sinf(angolo);
   }
}

float brk_rms(struct Brk* b1,struct Brk* b2)
{
   float rms=0;
   int i,j;

   if (b1->n_atoms!=b2->n_atoms)
      { printf("Errore Rms con differente n di atomi\n");exit(1);}
   for (i=0;i<b1->n_atoms;i++)
      rms+=sqrtf(powf(b1->atom[i].x-b2->atom[i].x,2.)+
                 powf(b1->atom[i].y-b2->atom[i].y,2.)+
                 powf(b1->atom[i].z-b2->atom[i].z,2.));
   return (rms/b1->n_atoms);
}

float brk_contacts(struct Brk* b1,struct Brk* b2,float maxdist)
{
   register float r1,dist,contacts=0;
   register int i,j;
   register float dx,dy,dz;
   register struct Atom* a1=b1->atom;
   register struct Atom* a2=b2->atom;

   for (i=0;i<b1->n_atoms;i++)
   {
      r1=a1[i].r+maxdist;
      j=0;
      do
      {
          dx=a1[i].x-a2[j].x;
          dy=a1[i].y-a2[j].y;
          dz=a1[i].z-a2[j].z;
          dist=dx*dx+dy*dy+dz*dz;
          if (dist<(r1+a2[j].r)*(r1+a2[j].r)) contacts+=1;
          j++;
      }   while (j<b2->n_atoms);
   }
   return contacts;
}  
