#include "my_macros.h"
#include "escher.h"
#include "prot.h"
#include "sol.h"
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "shapes.h"

#define MAX_HASH 2000 

extern float lunghezza_lato;
extern float spessore_sezione;
extern int col_attivo;

float LUR=120;
float lut=3.15;
float lungmin1=5;
float lungmin2=5;
float area=1.6;
float mincurv=0.45;

struct point centro1,centro2;
float raggio1,raggio2;
int maxr,maxt,cubo_size;
float gsin[3600*3],gcos[3600*3];
struct Cubo *c,*cl;

void inizializza (struct surf *s1, struct surf *s2, float lunghezza_lato,struct Solutions*s)
{
   int i;
   for(i=0;i<3600*3;i++)
      {
          gcos[i]=lunghezza_lato*cosf((M_PI/1800.0)*(float)i);
          gsin[i]=lunghezza_lato*sinf((M_PI/1800.0)*(float)i);
      }
   centro1=surf_center(s1);
   centro2=surf_center(s2);
   raggio1=surf_radius_max(s1,centro1);
   raggio2=surf_radius_max(s2,centro2);
   maxr=3600/LUR;
   maxt=1+(2*raggio1+2*raggio2)/lut;
   cubo_size=(maxr+1)*maxt*maxt;
   c=(struct Cubo*)calloc(cubo_size,sizeof(struct Cubo));  
   cl=(struct Cubo*)calloc(cubo_size,sizeof(struct Cubo));
   if (cl==NULL) {printf("cubo out of memory");exit(1);}
   s->centrox=centro2.x;s->centroy=centro2.y;s->centroz=centro2.z;	
}

void analizza(struct Proteina *p1, struct Proteina *p2, struct Solutions *s)
{ 
	int i,k,nf1,nf2,ok;
	int rxtxt=maxr*maxt*maxt; 
	int txt=maxt*maxt;
   
	for(i=p2->n_poligonali;i>=-p1->n_poligonali;i--)
	{	
		ok=0;
		for (nf1=0,nf2=i;nf1<p1->n_poligonali;nf1++,nf2++)
		{
			if ((nf2>=0)&&(nf2<p2->n_poligonali))
			if ((p1->poligonale[nf1].n_vertici)&&(p2->poligonale[nf2].n_vertici))
			{  
				if (ok==0) cubo_azzera(c,cubo_size); 
				ok++;
				cubo_azzera(cl,cubo_size);
				confronta(p1,nf1,p2,nf2);
				for (k=0;k<txt;k++) if (cl[rxtxt+k].val>cl[k].val)
				{
					c[k].val+=cl[rxtxt+k].val-cl[k].val;
					c[k].tx+=cl[rxtxt+k].tx-cl[k].tx;
					c[k].ty+=cl[rxtxt+k].ty-cl[k].ty;
					c[k].az+=cl[rxtxt+k].az-cl[k].az-3600;
					c[k].n+=cl[rxtxt+k].n-cl[k].n;
				}
			}
		}
		if(ok) cerca(i,p1,p2,s);
	}
}

void cubo_azzera(struct Cubo* c,int dim)
{
	memset(c,0,dim*sizeof(struct Cubo));
}

void confronta(struct Proteina* p1,short nf1,struct Proteina* p2, short nf2) 
{
   register int i,j,k; 
   register float dx,dy;
   register int a1,a2,del,val1,val2;
   int dot1=p1->poligonale[nf1].n_vertici;
   int dot2=p2->poligonale[nf2].n_vertici;
   register float areaxarea=area*area;
   register struct Vertice* v1=p1->poligonale[nf1].vertice;
   register struct Vertice* v2=p2->poligonale[nf2].vertice;
   register float* gc=gcos,*gs =gsin; 

   for (j=dot1;j<dot1*2;j++) 
   {  
      for (i=dot2;i<dot2*2;i++) 
	 if((v1[j+i].col==col_attivo)&&(v2[i].col==col_attivo))  
      {
          del=v1[j+i].a-v2[i].a+3600;
          k=i;dx=0;dy=0;
          do { k++;
             a1=v1[j+k].a;a2=v2[k].a+del;
             dx+=gc[a1]-gc[a2];dy+=gs[a1]-gs[a2];
          }  while(dx*dx+dy*dy<=areaxarea);
          val1=1+(k-i)-1;/*+1 aggiunto*/
          k=i;dx=0;dy=0;
          do { k--;
             a1=v1[j+k].a;a2=v2[k].a+del; 
             dx+=gc[a1]-gc[a2];dy+=gs[a1]-gs[a2];
          }  while(dx*dx+dy*dy<=areaxarea); 
          val2=(i-k)+1;
          if(val1+val2>=lungmin1) inserisci(p1,p2,nf1,nf2,i+j,i,val1,val2,del);
      }
   }
}

void inserisci(struct Proteina* p1,struct Proteina* p2,int nf1,int nf2,
              int pos1,int pos2,int forw,int back,int del)   
{
   float val=forw+back;
   int dot1=p1->poligonale[nf1].n_vertici;
   int dot2=p2->poligonale[nf2].n_vertici;

   float corr1,ix1,iy1,fx1,fy1,x2,x1,y2,y1,angolo,r;
   float corr,corr2,iy2,ix2,fx2,fy2;
   int a,x,y,ia,ix,iy;

   ix1=p1->poligonale[nf1].vertice[pos1-back].x;
   fx1=p1->poligonale[nf1].vertice[pos1+forw].x;   
   iy1=p1->poligonale[nf1].vertice[pos1-back].y;
   fy1=p1->poligonale[nf1].vertice[pos1+forw].y;
   corr1=sqrtf((ix1-fx1)*(ix1-fx1)+(iy1-fy1)*(iy1-fy1))/(lunghezza_lato*val); 
   ix2=p2->poligonale[nf2].vertice[pos2-back].x;
   fx2=p2->poligonale[nf2].vertice[pos2+forw].x;
   iy2=p2->poligonale[nf2].vertice[pos2-back].y;
   fy2=p2->poligonale[nf2].vertice[pos2+forw].y;
   corr2=sqrtf((ix2-fx2)*(ix2-fx2)+(iy2-fy2)*(iy2-fy2))/(lunghezza_lato*val);
   corr=(corr1+corr2)/2.;
   val=val/corr;
   if ((corr>mincurv)&&(val>lungmin2)) 
   {
      x2=p2->poligonale[nf2].vertice[pos2%dot2].x-centro2.x;
      y2=p2->poligonale[nf2].vertice[pos2%dot2].y-centro2.y;
      x1=p1->poligonale[nf1].vertice[pos1%dot1].x;
      y1=p1->poligonale[nf1].vertice[pos1%dot1].y;
      r=sqrtf(x2*x2+y2*y2);
      angolo=(float)(del%3600)*(M_PI/1800.0)+atan2f(y2,x2);
      x2=r*cosf(angolo)+centro2.x;
      y2=r*sinf(angolo)+centro2.y;
      x=maxt*(int)((x1-x2-centro1.x+centro2.x+raggio1+raggio2)/lut);
      y=(y1-y2-centro1.y+centro2.y+raggio1+raggio2)/lut;
      a=maxt*maxt*(int)((del%3600)/LUR);
     
      for (ia=a;ia<=a+maxt*maxt;ia+=maxt*maxt)
      {
         for (ix=ia+x;ix<=ia+x+maxt;ix+=maxt)
         {
            for(iy=ix+y;iy<=ix+y+1;iy++) if(cl[iy].val<val) 
            {
               c[iy].n+=1-cl[iy].n;
               c[iy].val+=val-cl[iy].val;
               c[iy].tx+=x1-x2-cl[iy].tx;
               c[iy].ty+=y1-y2-cl[iy].ty;
               c[iy].az+=del%3600-cl[iy].az;
               cl[iy].val=val;
               cl[iy].tx=x1-x2;
               cl[iy].ty=y1-y2;
               cl[iy].az=del%3600;
               cl[iy].n=1;
            }
         }
      }  
   }
}

void cerca (int shift,struct Proteina*p1,struct Proteina*p2,struct Solutions*s)
{ 
	int i,j=0,val,solfree;
	static int minval=100000,n_ele=0;
	struct element 
	{
		int sol;
		struct element *next;
	} *nuovo, *old, *prev;
	static struct element ele[MAX_HASH];	

	if (n_ele==0) for (i=0;i<MAX_HASH;i++) ele[i].next=NULL;
	for (i=0;i<maxr*maxt*maxt;i++) if ((val=c[i].val)>0)
		if ((n_ele<s->n_sol)||(val>minval))
	{
		solfree=n_ele;
		if (n_ele==s->n_sol)
		{
			while ((old=ele[minval].next)==NULL) minval++;
			ele[minval].next=old->next;
			solfree=old->sol; 
			free(old);
			n_ele--;
		}
		n_ele++;
		minval=min(val,minval);
		nuovo=(struct element*)malloc(sizeof(struct element));
		nuovo->sol=solfree;
		nuovo->next=ele[val].next;
		ele[val].next=nuovo;		
		s->sol[nuovo->sol].ax=s->angolox;
		s->sol[nuovo->sol].ay=s->angoloy;
		s->sol[nuovo->sol].val=c[i].val; 
		s->sol[nuovo->sol].az=(int)(c[i].az/(float)c[i].n)/10.;
		s->sol[nuovo->sol].tx=c[i].tx/c[i].n;
		s->sol[nuovo->sol].ty=c[i].ty/c[i].n;
		s->sol[nuovo->sol].tz=p1->z_min-p2->z_min-shift*spessore_sezione;
	} 

}
