#include "sol.h"
#include "brk.h"
#include <stdio.h>
#include <math.h>

struct Solutions* SolutionsNew(int Size)
{
	struct Solutions* s=(struct Solutions*)malloc(sizeof(struct Solutions));
	int i;

	s->sol=(struct Solution*)calloc(Size,sizeof(struct Solution));
	s->n_sol=Size;
	s->centrox=0;
	s->centroy=0;
	s->centroz=0;
	for(i=0;i<s->n_sol;i++)
	{
		s->sol[i].val=0;
		s->sol[i].ax=0;
		s->sol[i].ay=0;
		s->sol[i].az=0;
		s->sol[i].tx=0;
		s->sol[i].ty=0;
		s->sol[i].tz=0;
		s->sol[i].rms=0;
		s->sol[i].bumps=0;
		s->sol[i].charge=0;
		s->sol[i].pos_neg=0;
		s->sol[i].apo_apo=0;
		s->sol[i].pos_pos=0;
		s->sol[i].apo_pos=0;
	}
	return s;
}

void SolutionsDelete(struct Solutions* s)
{
	free(s->sol);
	free(s);
}

struct Solutions* SolutionsCopy(struct Solutions* s)
{
	int i;	
	struct Solutions* s2=SolutionsNew(s->n_sol);
	
	s2->n_sol=s->n_sol;
	s2->centrox=s->centrox;
	s2->centroy=s->centroy;
	s2->centroz=s->centroz;
	for(i=0;i<s->n_sol;i++) SolutionCopy(&s2->sol[i],&s->sol[i]);
	return s2;
} 

void SolutionCopy(struct Solution* dest,struct Solution* source)
{
	dest->val=source->val;
	dest->ax=source->ax;
	dest->ay=source->ay;
	dest->az=source->az;
	dest->tx=source->tx;
	dest->ty=source->ty;
	dest->tz=source->tz;
	dest->rms=source->rms;
	dest->bumps=source->bumps;
	dest->charge=source->charge;
	dest->pos_neg=source->pos_neg;
	dest->apo_apo=source->apo_apo;
	dest->pos_pos=source->pos_pos;
	dest->apo_pos=source->apo_pos;
}

void SolutionsWrite(struct Solutions* s,char* FileName)
{
	int i;
	FILE *File;

	File=fopen(FileName,"w");
	fprintf(File,"%d %f %f %f\n",s->n_sol,s->centrox,s->centroy,s->centroz);
	for (i=0;i<s->n_sol;i++)
	{	
		fprintf(File,"%3d r %4.1f b %3.0f c %4.0f s %3d"
			  " (+)%-3.0f(-)%-3.0f(a)%-3.0f(p)%-3.0f "
		          "(%4d %4d %4d) (%5.1f %5.1f %5.1f)\n",		
			i,s->sol[i].rms,s->sol[i].bumps,s->sol[i].charge,s->sol[i].val,
			s->sol[i].pos_neg,s->sol[i].pos_pos,
			s->sol[i].apo_apo,s->sol[i].apo_pos,	
			s->sol[i].ax,s->sol[i].ay,s->sol[i].az,
			s->sol[i].tx,s->sol[i].ty,s->sol[i].tz);
	}
	fclose(File);
}

struct Solutions* SolutionsRead(char* FileName)
{
	int i;
	int Size;
	FILE* File;
	struct Solutions* s;

	File=fopen(FileName,"r");
	fscanf(File,"%d",&Size);
	s=SolutionsNew(Size);
	fscanf(File,"%f %f %f\n",&s->centrox,&s->centroy,&s->centroz);
	for (i=0;i<s->n_sol;i++)
	{	
		fscanf(File,"%*d r %f b %f c %f s %d"
			  " (+) %f (-) %f (a) %f (p) %f "
		          "(%d %d %d) (%f %f %f)",		
			&(s->sol[i].rms),&(s->sol[i].bumps),&(s->sol[i].charge),&(s->sol[i].val),
			&(s->sol[i].pos_neg),&(s->sol[i].pos_pos),
			&(s->sol[i].apo_apo),&(s->sol[i].apo_pos),	
			&(s->sol[i].ax),&(s->sol[i].ay),&(s->sol[i].az),
			&(s->sol[i].tx),(&s->sol[i].ty),&(s->sol[i].tz));
	}
	fclose(File);
	return s;
}

struct Solutions* SolutionsSort(struct Solutions* s)
{
	int i,j,best;
	float maxcharge;
	struct temp{int a,b;}*t;	
	struct Solutions* s2=SolutionsCopy(s);

	t=(struct temp*)calloc(s->n_sol,sizeof(struct temp));
	for(i=0;i<s->n_sol;i++) t[i].b=0;
	for(i=0;i<s->n_sol;i++)
	{	
		maxcharge=-100000.;
		for(j=0;j<s->n_sol;j++) if (t[j].b==0)
		{			
          		if (s->sol[j].charge>maxcharge)
			{
				maxcharge=s->sol[j].charge;
				best=j;
			}
		}
		t[best].b=1;
		t[i].a=best;
	}
	for(i=0;i<s->n_sol;i++) SolutionCopy(&s2->sol[i],&s->sol[t[i].a]);
	free(t);
	return s2;	
}

struct Brk* BrkSolutions(struct Brk* Source,struct Solutions* s,int NSol)
{
	struct Brk* BrkSol=BrkNew();
	
	brk_copy(BrkSol,Source);
	brk_translate(BrkSol,-s->centrox,-s->centroy,-s->centroz);
	brk_x_rotate(BrkSol,(float)s->sol[NSol].ax*M_PI/180.);
	brk_y_rotate(BrkSol,(float)s->sol[NSol].ay*M_PI/180.);
	brk_z_rotate(BrkSol,(float)s->sol[NSol].az*M_PI/180.);
	brk_translate(BrkSol,s->sol[NSol].tx+s->centrox,
		s->sol[NSol].ty+s->centroy,s->sol[NSol].tz+s->centroz);
	return BrkSol;
}
