#include "prot.h"
#include "surf.h"
#include "my_macros.h"

struct Proteina* surf2prot (struct surf *surf,float spessore)
{
   int i,j,dot;
   struct Proteina *p;
   int* n_vertici;
   struct point smax,smin;
   
   surf_max_min(surf,&smax,&smin);
   p=proteina_new(1+(int)((smax.z-smin.z)/spessore));
   p->spessore=spessore;
   p->z_min=smin.z;
  
   n_vertici=(int*)calloc(p->n_poligonali,sizeof(int));
   for (i=0;i<p->n_poligonali;i++) n_vertici[i]=0;

   for (dot=0,i=0;i<surf->n_atoms;i++)
      for (j=0;j<surf->atom[i].atom_dots;j++,dot++)    
         n_vertici[(int)((surf->z[dot]-p->z_min)/spessore)]++;

   for (i=0;i<p->n_poligonali;i++)
   {
      poligonale_new(&p->poligonale[i],n_vertici[i]);
      p->poligonale[i].n_vertici=0;
   }  
   for (dot=0,i=0;i<surf->n_atoms;i++)
      for (j=0;j<surf->atom[i].atom_dots;j++,dot++)            
      {
         int sezione=(unsigned)((surf->z[dot]-p->z_min)/spessore);
         int punto_sezione=p->poligonale[sezione].n_vertici++; 
         p->poligonale[sezione].vertice[punto_sezione].x=surf->x[dot]; 
         p->poligonale[sezione].vertice[punto_sezione].y=surf->y[dot];
         p->poligonale[sezione].vertice[punto_sezione].col=surf->col[dot];
      } 
   return p;
}
