
/*********************************************************************
****         ESCHER Next Generation - Molecule routines           ****
**** (c) 1997-2012, G. Ausiello, G. Cesareni, M. Helmer Citterich ****
****               NG version by Alessandro Pedretti              ****
*********************************************************************/


#ifndef __ES_BRK
#  define __ES_BRK

/**** Atom type ****/

typedef struct {
  int           i;      /* First residue name (number) in the residues array */
  int           f;      /* Last residue name (number) in the residues array  */
  ES_QCHAR      t;      /* Atom name                                         */
  int           c;      /* Charge                                            */
} ES_ATMTYPE;

/**** Prototypes ****/

ES_BRK          *BrkNew(void);
ES_BOOL         BrkRead(char *, ES_BRK *);
ES_BOOL         BrkWrite(char *, ES_BRK*);
void            brk_translate(ES_BRK *, float, float, float);
void            brk_x_rotate(ES_BRK *, float);
void            brk_y_rotate(ES_BRK *, float);
void            brk_z_rotate(ES_BRK *, float);
void            brk_copy(ES_BRK *,const ES_BRK *);
void            BrkDelete(ES_BRK *);
float           brk_rms(ES_BRK *, ES_BRK *);
float           brk_contacts(ES_BRK *, ES_BRK*, float);

#endif
