
/*********************************************************************
****             ESCHER Next Generation - Cpu detection           ****
**** (c) 1997-2012, G. Ausiello, G. Cesareni, M. Helmer Citterich ****
****               NG version by Alessandro Pedretti              ****
*********************************************************************/


#ifndef _MYCPU_H
#  define  _MYCPU_H

/**** Intel/AMD x86 CPU ****/

#  ifdef WIN64
#    define  MYCPU_TYPE                   "AMD Phenom/Opteron/Athlon 64"
#  else
#  if (defined(__WIN32__) && defined(__BORLANDC__))
#    ifdef _M_IX86
#      if _M_IX86 == 300
#        define  MYCPU_TYPE               "Intel 386"
#      else
#        if _M_IX86 == 400
#          define  MYCPU_TYPE             "Intel 486"
#        else
#          if _M_IX86 == 500
#            define  MYCPU_TYPE           "Intel Pentium"
#          else
#            if _M_IX86 == 600
#              define  MYCPU_TYPE         "Intel Pentium Pro"
#            endif
#          endif
#        endif
#      endif
#    endif
#  else
#    if (defined WIN32 || defined _WIN32 || defined _WINDOWS || defined WINDOWS || defined(linux))
#      ifdef __tune_pentium__
#        define MYCPU_TYPE                "Intel Pentium"
#      else
#        ifdef __tune_pentiumpro__
#          define MYCPU_TYPE              "Intel Pentium Pro"
#        else
#          ifdef __tune_pentium3__
#            define MYCPU_TYPE            "Intel Pentium 3"
#          else
#            ifdef __tune_pentium4__
#              define MYCPU_TYPE          "Intel Pentium 4"
#            else
#              ifdef __tune_k6__
#                define MYCPU_TYPE        "AMD K6"
#              else
#               ifdef __tune_athlon_sse__
#                  define MYCPU_TYPE      "AMD Athlon 4/XP/MP"
#                else
#                  ifdef __tune_athlon__
#                    define MYCPU_TYPE    "AMD Athlon/Duron"
#                  else
#                    ifdef __tune_k8__
#                    define MYCPU_TYPE    "AMD Opteron/Athlon 64"
#                    endif
#                  endif
#                endif
#              endif
#            endif
#          endif
#        endif
#      endif
#    endif
#    ifdef SSE
#      define MYCPU_OPTIM                 " SSE"
#    endif
#  endif
#  endif

/**** Amiga Motorola CPU ****/

#  ifdef AMIGA
#    ifdef   mc68020
#      define  MYCPU_TYPE                 "68020/68881"
#    endif
#    ifdef   mc68030
#      define  MYCPU_TYPE                 "68030/68881"
#    endif
#    ifdef   mc68040
#      define  MYCPU_TYPE                 "68040"
#    endif
#  endif

/**** Silicon Graphics ****/

#  ifdef sgi
#    define  MYCPU_TYPE                   "R4000"
#  endif

/**** Generic CPU ****/

#  ifndef MYCPU_TYPE
#    define  MYCPU_TYPE
#  endif

#  ifndef MYCPU_OPTIM
#    define MYCPU_OPTIM
#  endif

#  define MYCPU                           MYCPU_TYPE MYCPU_OPTIM
#endif

