
/***************************************
**** ESCHER NG - Global definitions ****
***************************************/


#ifndef __ES_MYMACROS
#  define __ES_MYMACROS

#  include <stdio.h>
#  include <string.h>
#  include <stdlib.h>
#  include <math.h>
#  include <malloc.h>

#  define  ES_COPYRIGHT                 "1997-2012"
#  define  ES_VER                       "1.2.1"
#  define  ES_DATE                      "05.01.2012"
#  define  ES_CAT_FILE                  "ESCHER.catalog"
#  define  ES_CAT_VERSION               1
#  define  ES_OUT_VERSTR                "1"
#  define  ES_PRF_FILE                  "esprefs"
#  define  ES_PRF_LANGLEN               31

#  define  ES_DEFPRAD                   1.8f
#  define  ES_DEFDOTS                   420
#  define  ES_LINELEN                   127
#  define  ES_MINSRFDOTS                200

#  ifdef M_PI
#    undef  M_PI
#  endif

#  ifdef M_PI_2
#    undef  M_PI_2
#  endif

#  define  M_PI                         3.14159265f
#  define M_PI_2                        1.57079632f

#  ifdef max
#    undef max
#  endif

#  ifdef min
#    undef min
#  endif

#  define  cube(x)            ((x) * (x) * (x))
#  define  max(a, b)          (a<b ? b : a)
#  define  min(a, b)          (a>b ? b : a)
#  define  my_abs(x)          (x>=0 ? x : -(x))
#  define  square(x)          ((x) * (x))

#  define  array(name,type,size) {name=(type*)calloc(size,sizeof(type));\
    if (name==NULL){printf("Out of mem in array "#name" in file "__FILE__ "\n");exit(1);} memset(name,0,(long)((size)*sizeof(type)));}

/**** Memory mamagment ****/

#  define  ALLOC(X)           calloc((X), 1)
#  define  FREE               free

/**** AmigaOS definitions ****/

#  ifdef AMIGA
#    define  ES_VERSION         "Amiga"
#  endif

/**** HP-UX definitions ****/

#  ifdef HPUX
#    define  ES_VERSION         "HP/UX"
#  endif

/**** Linux definitions ****/

#  ifdef linux
#    define  ES_VERSION         "Linux"
#  endif

/**** Silicon Graphics definitions ****/

#  ifdef sgi
#    define  ES_VERSION         "Silicon Graphics"
#  endif

/**** Windows 9x/NT definitions ****/

#  if defined(__WIN32__) && !defined(WIN32)
#    define  WIN32
#  endif

#  ifdef WIN32
#    ifdef WIN64
#      define  ES_VERSION       "Windows 64 bit"
#    else
#      define  ES_VERSION       "Windows 32 bit"
#    endif
#  endif

/**** Generic definitions ****/

#  ifndef ES_VERSION
#    define  ES_VERSION         "Generic"
#  endif

/**** Math functions ****/

#  ifndef sgi
#    define  fsqrt              (float)sqrt
#  endif

#  if defined(__BORLANDC__) || defined(AMIGA)
#    define  atan2f             (float)atan2
#    define  cosf               (float)cos
#    define  powf               (float)pow
#    define  sinf               (float)sin
#    define  sqrtf              (float)sqrt
#  endif

/**** Boolean costants ****/

#  ifndef FALSE
#    define  FALSE              0
#  endif
#  ifndef TRUE
#    define  TRUE               1
#  endif

/**** Max path lenght ****/

#  ifndef MAX_PATH
#    define  MAX_PATH           256
#  endif

/********************************
**** Bit values of the Flags ****
****     ATOMO structure     ****
********************************/

#  define  ES_ATMF_NONE         0
#  define  ES_ATMF_HETATM       1
#  define  ES_ATMF_SEGEND       2


/**** Types ****/

typedef short           ES_BOOL;
typedef char            ES_BYTE;
typedef float           ES_FLOAT;
typedef int             ES_LONG;
typedef short           ES_WORD;
typedef unsigned char   ES_UBYTE;
typedef unsigned int    ES_ULONG;
typedef void            ES_VOID;
typedef unsigned short  ES_UWORD;

/**** Special two bytes type ****/

typedef union {
  char          C[2];
  ES_WORD       S;
} ES_DCHAR;

typedef union {
  char      C[4];
  ES_LONG   L;
} ES_QCHAR;

/**** Atom table ****/

typedef struct {
  ES_DCHAR    Elem;                   /* Element        */
  ES_UWORD    Num;                    /* Atomic number                          */
  float       Mass;                   /* Mass         */
  float       CovRad;                 /* Covalent radius      */
  float       VdwRad;                 /* Van Der Waals radius     */
} ES_ATMTAB;

/**** Atom ****/

typedef struct {
  ES_ULONG          Num;            /* Atom number                 */
  ES_QCHAR          Name;           /* Atom name                   */
  ES_DCHAR          Elem;           /* Element                     */
  ES_QCHAR          ResName;        /* Residue name                */
  ES_QCHAR          ResSeq;         /* Number of residue           */
  float             x, y, z;        /* X, Y, Z coodinates          */
  float             r;              /* Van Der Waal radius         */
  int               carica;
  int               valore;
  ES_BYTE           ChainID;        /* Chain indicator             */
  ES_BYTE           Flags;          /* Flags                       */
} ES_ATOM;

/**** Molecule ****/

typedef struct {
  ES_ATOM       *atom;
  ES_ULONG      n_atoms;
} ES_BRK;

/**** Global preferences ****/

typedef struct {

  /* Strings */

  char              Language[ES_PRF_LANGLEN + 1];  /* Default language            */

} ES_PREFS;

/**** Buffer definition for molecule reading ****/

typedef union {
  char              Line[ES_LINELEN + 1];
  ES_LONG           Hdr;
} ES_RECORD;

/**** Surface data structure ****/

typedef struct __es_surface {
  struct __es_surface   *Ptr;       /* Pointer to next element */
  ES_ULONG              AtmNum;     /* Atom number             */
  float                 x, y, z;    /* Coordinates             */
  ES_UBYTE              Color;      /* Color                   */
} ES_SURFACE;

#endif
