#include "my_macros.h"

#include "prot.h"
#include "utils.h"


extern int col_attivo;


/**** Copy a vertex ****/

void vertice_copy(struct Vertice *dest, struct Vertice* source)
{
   dest -> x   = source -> x;
   dest -> y   = source -> y;
   dest -> a   = source -> a;
   dest -> col = source -> col;
}


/**** Creates a new poligonal ****/

void poligonale_new(struct Poligonale *p, int vertici)
{
  if (vertici) {
    p -> vertice = Alloca(sizeof(struct Vertice) * vertici);
    if (p -> vertice == NULL) {
      exit(1);
    }
    p -> n_vertici = vertici;
  }
}

void poligonale_copy(struct Poligonale* dest,struct Poligonale* source)
{
   int i;
   poligonale_new(dest,source->n_vertici);
   for (i=0;i<source->n_vertici;i++)
      vertice_copy(&dest->vertice[i],&source->vertice[i]);
}

void poligonale_delete(struct Poligonale *p)
{
   if (p -> n_vertici > 0) FREE(p->vertice);
}


/**** Allocate a new protein ****/

struct Proteina *proteina_new(int poligonali)
{
  struct Proteina       *nuova = NULL;

  if (poligonali) {
    if ((nuova = (struct Proteina *)Alloca(sizeof(struct Proteina))) != NULL) {
      if ((nuova -> poligonale = (struct Poligonale *)Alloca(sizeof(struct Poligonale) * poligonali)) != NULL) {
        nuova -> n_poligonali = poligonali;
      } else {
        FREE(nuova);
        nuova = NULL;
      }
    }
  }

  return nuova;
}


struct Proteina *proteina_copy(struct Proteina* source)
{
  int                   i;
  struct Proteina       *nuova = proteina_new(source -> n_poligonali);

  for (i=0;i<source->n_poligonali;i++)
    poligonale_copy(&nuova->poligonale[i],&source->poligonale[i]);

  nuova -> spessore = source -> spessore;
  nuova -> z_min    = source -> z_min;

  return nuova;
}


/**** Delete a protein ****/

void proteina_delete(struct Proteina *p)
{
  int           i;

  for(i = 0; i < p -> n_poligonali; i++)
    poligonale_delete(&p -> poligonale[i]);
  if (p -> poligonale) FREE(p -> poligonale);
  FREE(p);
}


void prot_ordina (struct Proteina *p,float larghezza_maglie,float perimetro_min) {
   int* griglia_col;
   float *griglia_x;
   float *griglia_y;
   int *ordine_x;
   int *ordine_y;
   const int dot_min=2;
   int lun_x,lun_y;
   int start[4];
   const int angolo_iniziale[4]={2,6,0,4};
   struct direzione {int x,y;} const dir[8]=
           {{0,1},{1,1},{1,0},{1,-1},{0,-1},{-1,-1},{-1,0},{-1,1}};
   int i,j,n_maglie;

   for (i=0;i<p->n_poligonali;i++)
   {
      if(p->poligonale[i].n_vertici<dot_min)
      {
         poligonale_delete(&p->poligonale[i]);
         p->poligonale[i].n_vertici=0;
      }
      else
      {
         float x_min=p->poligonale[i].vertice[0].x;
         float y_min=p->poligonale[i].vertice[0].y;
         float x_max=x_min,y_max=y_min;
         n_maglie=0;
         for (j=0;j<p->poligonale[i].n_vertici;j++)
         {
            if (p->poligonale[i].vertice[j].x<=x_min)
               {x_min=p->poligonale[i].vertice[j].x;start[0]=j;}
            if (p->poligonale[i].vertice[j].x>=x_max)
               {x_max=p->poligonale[i].vertice[j].x;start[1]=j;}
            if (p->poligonale[i].vertice[j].y<=y_min)
               {y_min=p->poligonale[i].vertice[j].y;start[2]=j;}
            if (p->poligonale[i].vertice[j].y>=y_max)
               {y_max=p->poligonale[i].vertice[j].y;start[3]=j;}
         }
		 lun_x = 1 + (int)((x_max-x_min) / larghezza_maglie);
		 lun_y = 1 + (int)((y_max-y_min) / larghezza_maglie);
		 array(griglia_col,int  ,lun_x * lun_y);
		 array(griglia_x  ,float,lun_x * lun_y);
		 array(griglia_y  ,float,lun_x * lun_y);

		 for (j=0;j<p->poligonale[i].n_vertici;j++)
         {
            int posizione=(int)((p->poligonale[i].vertice[j].x-x_min)
                                /larghezza_maglie)*lun_y+
                          (int)((p->poligonale[i].vertice[j].y-y_min)
                                /larghezza_maglie);
            if (griglia_col[posizione]!=col_attivo)
            {
                /*p->poligonale[i].vertice[j].col=1;da togliere */
                griglia_col[posizione]=p->poligonale[i].vertice[j].col;
            }
            griglia_x[posizione]=p->poligonale[i].vertice[j].x;
            griglia_y[posizione]=p->poligonale[i].vertice[j].y;
         }
         array(ordine_x,int,p->poligonale[i].n_vertici);
         array(ordine_y,int,p->poligonale[i].n_vertici);
         for (j=0;(j<4)&&(perimetro_min>(float)n_maglie*larghezza_maglie);j++)
         {
			int x_start = (int)((p -> poligonale[i].vertice[start[j]].x - x_min) / larghezza_maglie);
			int y_start = (int)((p -> poligonale[i].vertice[start[j]].y - y_min) / larghezza_maglie);
            int x_q=x_start,y_q=y_start;
            int ultimo_angolo=angolo_iniziale[j];
            int nuovo_angolo;
            n_maglie=0;
            do
            {
               int nx_q,ny_q;
               int angolo=0;
               ordine_x[n_maglie]=x_q;ordine_y[n_maglie]=y_q;
               n_maglie++;
               do
               {
                  do
                  {
                     nuovo_angolo=(ultimo_angolo+4+1+angolo++)%8;
                     nx_q=x_q+dir[nuovo_angolo].x;
                     ny_q=y_q+dir[nuovo_angolo].y;
                     if (angolo>8) {nx_q=x_q;ny_q=y_q;} /*partenza da un punto isolato*/
                  }
                  while ((nx_q<0)||(ny_q<0)||(nx_q>=lun_x)||(ny_q>=lun_y));
               }
               while (griglia_col[nx_q*lun_y+ny_q]==0);
               ultimo_angolo=nuovo_angolo;
               x_q=nx_q;y_q=ny_q;
            }
            while ((x_q!=x_start)||(y_q!=y_start));
         }
         poligonale_delete(&p->poligonale[i]);
         if (perimetro_min>(float)n_maglie*larghezza_maglie)
            p->poligonale[i].n_vertici=0;
         else
         {
            n_maglie++;
            poligonale_new(&p->poligonale[i],n_maglie);
            for (j=0;j<n_maglie-1;j++)
            {
               p->poligonale[i].vertice[j].x=
                  griglia_x[ordine_x[j]*lun_y+ordine_y[j]];
               p->poligonale[i].vertice[j].y=
                  griglia_y[ordine_x[j]*lun_y+ordine_y[j]];

               /*   Alternativa: nuove coordinate = al centro del quadretto
               =ordine_x[j]*larghezza_maglie+larghezza_maglie/2.;
               =ordine_y[j]*larghezza_maglie+larghezza_maglie/2.;
               */
               p->poligonale[i].vertice[j].col=
                  griglia_col[ordine_x[j]*lun_y+ordine_y[j]];
            }
            p->poligonale[i].vertice[n_maglie-1]=p->poligonale[i].vertice[0];
         }
         free(griglia_col);free(griglia_x);free(griglia_y);
         free(ordine_x);free(ordine_y);
      }
   }
}

void prot_lati(struct Proteina* p, float lunghezza_lato)
{
   int i,j,k,endflag,col;
   double dist,x1,x2,y1,y2,m,n,a,b,A,B,C;
   double sox1,sox2,soy1,soy2;
   struct Vertice *vtemp;
   int dot_max=0;

   for (i=0;i<p->n_poligonali;i++)
      dot_max=max(dot_max,p->poligonale[i].n_vertici);
   array(vtemp,struct Vertice,dot_max);

   for (i=0;i<p->n_poligonali;i++) if(p->poligonale[i].n_vertici)
   {
      k=0;
      a=p->poligonale[i].vertice[k].x;
      b=p->poligonale[i].vertice[k].y;
      col=p->poligonale[i].vertice[k].col;

      for(j = 0,endflag = 0; endflag == 0; j++)
      {
		 vtemp[j].x = (float)a; vtemp[j].y = (float)b; vtemp[j].col = col;
         do
         {
            k++;
            x2=p->poligonale[i].vertice[k].x;
            y2=p->poligonale[i].vertice[k].y;
            dist=sqrt((a-x2)*(a-x2)+(b-y2)*(b-y2));
            if (k==p->poligonale[i].n_vertici-1)
               if (dist<lunghezza_lato)
                  {dist=lunghezza_lato;endflag=1;}
         }
         while(dist<lunghezza_lato);
         x1=p->poligonale[i].vertice[k-1].x;
         y1=p->poligonale[i].vertice[k-1].y;
         col=p->poligonale[i].vertice[k-1].col;
         if (x2==x1)
         {
            A=1;B=(-2)*b;
            C=a*a+b*b-lunghezza_lato*lunghezza_lato+x1*x1-2*a*x1;
            soy1=(-B+sqrt(B*B-4*A*C))/(2*A);
            soy2=(-B-sqrt(B*B-4*A*C))/(2*A);
            if ((soy1>min(y1,y2))&&(soy1<max(y1,y2))) b=soy1;
            else b=soy2;
            a=x1;
         }
         else
         {
            m=(y2-y1)/(x2-x1);n=(x1*y2-x2*y1)/(x1-x2);
            A=1+m*m;B=2*(m*n-a-b*m);
            C=n*n-2*b*n+a*a+b*b-lunghezza_lato*lunghezza_lato;
            sox1=(-B+sqrt(B*B-4*A*C))/(2*A);
            sox2=(-B-sqrt(B*B-4*A*C))/(2*A);
            if((sox1>=min(x1,x2))&&(sox1<=max(x1,x2)))
               if((sox2>=min(x1,x2))&&(sox2<=max(x1,x2)))
                  if(fabs(sox2-vtemp[j-1].x)>fabs(sox1-vtemp[j-1].x)) a=sox2;
                  else a=sox1;
               else a=sox1;
            else
               if((sox2>=min(x1,x2))&&(sox2<=max(x1,x2))) a=sox2;
                   else a=min(x1,x2)+(x1-x2)/2;
               b=m*a+n;
         }
         k--;
      }
      poligonale_delete(&p->poligonale[i]);
      poligonale_new(&p->poligonale[i],j);
      for (k=0;k<j;k++) p->poligonale[i].vertice[k]=vtemp[k];
   }
   free((struct vertice*)vtemp);
}

void prot_inverti(struct Proteina *p)
{
  int                   i, j, dotnum;
  struct Vertice        *vtemp;

   for(i = 0; i < p->n_poligonali;i++) {
     if ((dotnum = p -> poligonale[i].n_vertici) != 0) {
       array(vtemp, struct Vertice, dotnum);
       for(j = 0; j < dotnum; j++) vtemp[j] = p -> poligonale[i].vertice[dotnum - j - 1];
       for(j = 0; j < dotnum; j++) p -> poligonale[i].vertice[j] = vtemp[j];
       free((struct Vertice *)vtemp);
     }
   } /* End of for (i) */
}

void prot_angoli(struct Proteina *p)
{
  int           i, j, k, dotnum;
  float         ang;

  for(i = 0; i < p -> n_poligonali; i++) {
    if ((dotnum = p->poligonale[i].n_vertici) != 0) {
      for (j = 0, k = 1; j < dotnum; j++, k++) {
         if (k == dotnum) k = 0;
		 ang = atan2f((p -> poligonale[i].vertice[k].y - p -> poligonale[i].vertice[j].y),
					  (p -> poligonale[i].vertice[k].x - p -> poligonale[i].vertice[j].x));
		 if (ang < 0) ang += 2.0f * M_PI;
		 p -> poligonale[i].vertice[j].a = (short)((1800.0f / M_PI) * ang);
         if (p -> poligonale[i].vertice[j].a < 0) printf("errore\n");
      }
    }
  } /* End of for (i) */
}

void prot_estendi(struct Proteina *p,int newdot)
{
  int                   i, j, olddot;
  struct Vertice        *vtemp;

  for(i = 0; i < p -> n_poligonali; i++) {
    if ((olddot = p -> poligonale[i].n_vertici) != 0) {
      array(vtemp, struct Vertice, olddot);
      for(j = 0; j < olddot; j++) vtemp[j] = p -> poligonale[i].vertice[j];
      poligonale_delete(&p->poligonale[i]);
      poligonale_new(&p->poligonale[i], newdot);
      for(j = 0; j < newdot; j++) p -> poligonale[i].vertice[j] = vtemp[j % olddot];
      p -> poligonale[i].n_vertici = olddot;
      FREE((struct Vertice*)vtemp);
    }
  } /* End of for */
}

int estensione(struct Proteina* p1, struct Proteina *p2)
{
   int i,max1=0,max2=0;
   for(i=0;i<p1->n_poligonali;i++)
      if (p1->poligonale[i].n_vertici>max1) max1=p1->poligonale[i].n_vertici;
   for(i=0;i<p2->n_poligonali;i++)
      if (p2->poligonale[i].n_vertici>max2) max2=p2->poligonale[i].n_vertici;
   return max1*3+max2*3;
}
