#ifndef __ES_PROT
#  define __ES_PROT

#  include "surf.h"

/**** Definitions ****/

struct Proteina
{
   struct Poligonale* poligonale;
   int n_poligonali;
   float z_min;
   float spessore;
};

struct Poligonale
{
   struct Vertice* vertice;
   int n_vertici;
};

struct Vertice
{
  int col;
  int a;
  float x;
  float y;
};

/**** Prototypes ****/

void vertice_copy(struct Vertice* dest, struct Vertice* source);
void poligonale_new(struct Poligonale*, int vertici);
void poligonale_copy(struct Poligonale* dest,struct Poligonale* source);
void poligonale_delete(struct Poligonale* p);
struct Proteina* proteina_new(int poligonali);
struct Proteina* proteina_copy(struct Proteina* source);
void proteina_delete(struct Proteina*);
void prot_ordina (struct Proteina*,float larghezza_maglie,float perim_min); 
void prot_lati(struct Proteina*, float lunghezza_lato);
void prot_inverti(struct Proteina*);
void prot_angoli(struct Proteina*);
void prot_estendi(struct Proteina*,int newmax);
int estensione(struct Proteina*,struct Proteina*);

#endif
