#ifndef __ES_SOL
#  define __ES_SOL

/**** Definitions ****/

typedef struct {
  int           val, ax, ay, az;
  float         tx, ty, tz;
  float         rms, bumps;
  float         charge, pos_neg, apo_apo, pos_pos, apo_pos;
} ES_SOLUTION;

typedef struct {
  ES_ULONG      n_sol;
  ES_SOLUTION   *sol;
  float         centrox, centroy, centroz;
  int           angolox, angoloy;
} ES_SOLUTIONS;

/**** Prototypes ****/

ES_BRK          *BrkSolutions(ES_BRK *, ES_SOLUTIONS *, ES_ULONG);
ES_SOLUTIONS    *SolutionsNew(ES_ULONG);
void            SolutionsDelete(ES_SOLUTIONS **);
ES_SOLUTIONS    *SolutionsCopy(ES_SOLUTIONS *);
void            SolutionCopy(ES_SOLUTION *, ES_SOLUTION *);
ES_BOOL         SolutionsWrite(ES_SOLUTIONS *,char *);
ES_SOLUTIONS    *SolutionsRead(char *);
ES_SOLUTIONS    *SolutionsSort(ES_SOLUTIONS *);


#endif

