
/*********************************************************************
****               ESCHER Next Generation - Surface               ****
**** (c) 1997-2012, G. Ausiello, G. Cesareni, M. Helmer Citterich ****
****               NG version by Alessandro Pedretti              ****
*********************************************************************/


#ifndef __ES_SURF
#  define __ES_SURF

struct point {
  float x,y,z;
};

struct surf
{
   struct atom_ref* atom;
   float* x;
   float* y;
   float* z;
   int* col;
   int n_atoms;
   int n_dots;
   struct point org;
};

struct atom_ref
{
   char label[30];
   int atom_dots;
};

ES_BOOL SrfCalc(char *, ES_BRK *, ES_ULONG, float);
ES_BOOL SrfCopy(struct surf *, const struct surf *);
void    SrfDelete(struct surf *);
void    SrfFree(ES_SURFACE *);
ES_BOOL SrfRead(char *, struct surf *);
void    SrfRotX(struct surf *, float);
void    SrfRotY(struct surf *, float);
/* void    SrfRotZ(struct surf *, float); */
void    SrfSortByAtm(ES_SURFACE **, ES_ULONG);
void    SrfTranslate(struct surf *, float, float, float);
ES_BOOL SrfWrite(char *, ES_SURFACE *, ES_BRK *);

struct point surf_center(struct surf*);
void surf_max_min(struct surf*,struct point *max, struct point *min);
float surf_radius_max(struct surf*,struct point centro);

#endif
