
/*******************************************
****     DxwCpuLib test application     ****
****         Standard C version         ****
**** (c) 2002-2012  Alessandro Pedretti ****
*******************************************/


#include <stdio.h>

#ifdef __BORLANDC__
#  include <condefs.h>
#  pragma hdrstop
#  pragma argsused
#endif

#define  DXWCPU_C
#include "dxwcpu.h"


/**** Main code ****/

int main(int argc, char* argv[])
{
  char **       Suff;
  DXWCPU        Cpu;

  DXWCPU_GetInfo(&Cpu);

  printf("Processors             : %d\n", Cpu.m_CPU_Number);
  printf("Virtual CPU per proc.  : %d\n", Cpu.m_CPU_LogicalPerPhysical);
  printf("Vendor                 : %s\n", Cpu.m_ProcVendorString);
  printf("Name                   : %s\n", Cpu.m_ProcName);
  printf("Type                   : %d\n", Cpu.m_ProcType);
  printf("Family                 : %d\n", Cpu.m_ProcFamily);
  printf("Model                  : %d\n", Cpu.m_ProcModel);
  printf("Stepping               : %d\n", Cpu.m_ProcStepping);
  printf("3DNow!                 : %d\n", (Cpu.m_CPU_ExtendedFeatures & EAMD_3DNOW_FLAG) == EAMD_3DNOW_FLAG);
  printf("Enhanced 3DNow!        : %d\n", (Cpu.m_CPU_ExtendedFeatures & EAMD_3DNOWEXT_FLAG) == EAMD_3DNOWEXT_FLAG);
  printf("SSE                    : %d\n", (Cpu.m_CPU_Features & INTEL_SSE_FLAG) == INTEL_SSE_FLAG);
  printf("SSE2                   : %d\n", (Cpu.m_CPU_Features & INTEL_SSE2_FLAG) == INTEL_SSE2_FLAG);
  printf("HyperThreading         : %d\n", (Cpu.m_CPU_Features & INTEL_HT_FLAG) == INTEL_HT_FLAG);

  /**** DLL suffixes ****/

  printf("DLL suffixes: ");

  Suff = Cpu.m_CPU_Suffix;
  while(*Suff) {
    printf("\"%s\" ", *Suff++);
  }
  printf("\n");


  return 0;
}
