#include <stdio.h>  
#include <string.h>
#include <stdlib.h> 
#include <math.h>
#include "charges.h" 

float brk_surfatoms(struct Brk *p1,struct Brk *p2,float maxdist)
{
        int i,j;
        float dist,sommaraggi;
        float score=0;

        for (i=0;i<p1->n_atoms;i++)
                for (j=i;j<p2->n_atoms;j++)
                {
                        dist=distanza(p1->atom[i],p2->atom[j]);
                        sommaraggi=p1->atom[i].r+p2->atom[j].r+0.3;
			if (dist<sommaraggi+0.6)
			{
				printf("%3d %3d %4.1f\n",
				p1->atom[i].carica,p2->atom[j].carica,j,dist-sommaraggi);
			}
			if (dist<sommaraggi)
			{
				score+=(dist-sommaraggi)*20;
			}
 			else 
			{
				if(dist<sommaraggi+0.6) 
					score+=1/*5*(0.7-(dist-sommaraggi))*/;	
			}
		}	
		printf("                 %f\n",score);
	return score;
}

float brk_bumps(struct Brk *p1,struct Brk *p2,float overlap) 
{
	int i,j;
	float dist,mindist;
	float score=0;	

	for (i=0;i<p1->n_atoms;i++) p1->atom[i].bf=0;
	for (j=0;j<p2->n_atoms;j++) p2->atom[j].bf=0;

	for (i=0;i<p1->n_atoms;i++)
		for (j=0;j<p2->n_atoms;j++)
		{
 			dist=distanza(p1->atom[i],p2->atom[j]);
          		mindist=p1->atom[i].r+p2->atom[j].r-overlap;
          		if (dist<mindist)
			{ 
             			p1->atom[i].bf=1;
				p2->atom[j].bf=1;
             			score+=mindist-dist;
			}
		}
	return score;
}

float brk_pos_neg(struct Brk *p1,struct Brk *p2,float maxdist)
{
	int i,j;
	float score=0; 

	for (i=0;i<p1->n_atoms;i++) p1->atom[i].cf=0;
	for (j=0;j<p2->n_atoms;j++) p2->atom[j].cf=0;

	for (i=0;i<p1->n_atoms;i++) 
		if (p1->atom[i].carica>0)
		if (p1->atom[i].bf==0)
		if (p1->atom[i].cf==0)			
		for (j=0;j<p2->n_atoms;j++) 
			if(p2->atom[j].carica>0)
			if(p2->atom[j].bf==0)				
			if(p2->atom[j].cf==0)
			if(((p1->atom[i].carica>=2)&&(p2->atom[j].carica<=2))||
			   ((p1->atom[i].carica<=2)&&(p2->atom[j].carica>=2)))
			if (distanza(p1->atom[i],p2->atom[j])<maxdist) 
			{
				p1->atom[i].cf=1;
				p2->atom[j].cf=1;
				score+=p1->atom[i].valore+p2->atom[j].valore;
			}
	return score;
}

float brk_apo_apo(struct Brk *p1,struct Brk *p2, float maxdist)
{
	int i,j;
	float score=0;
	for (i=0;i<p1->n_atoms;i++) 
		if (p1->atom[i].carica==0)
		if (p1->atom[i].bf==0)
		for (j=0;j<p2->n_atoms;j++) 
			if (p2->atom[j].bf==0)
	       		if (p2->atom[j].carica==0)
               		if ((distanza(p1->atom[i],p2->atom[j])<maxdist))
                        	score+=1;
	return score;
}

float brk_pos_pos(struct Brk *p1,struct Brk *p2, float maxdist)
{
	int i,j;
	float score=0;

	for (i=0;i<p1->n_atoms;i++) 
		if (p1->atom[i].cf==0) 
			if ((p1->atom[i].carica==1)||(p1->atom[i].carica==1))
		for (j=0;j<p2->n_atoms;j++) if (p2->atom[j].cf==0)
			if ((distanza(p1->atom[i],p2->atom[j])<maxdist))
			if (((p1->atom[i].carica==1)&&(p2->atom[j].carica==1))||
				((p1->atom[i].carica==3)&&(p2->atom[j].carica==3)))
                   	score+=p1->atom[i].valore+p2->atom[j].valore;
	return score;
}

float brk_apo_pos(struct Brk *p1,struct Brk *p2,float maxdist)
{
	int i,j;
	float score=0;
	for (i=0;i<p1->n_atoms;i++) if (p1->atom[i].cf==0)
		for (j=0;j<p2->n_atoms;j++) if (p2->atom[j].cf==0)
			if ((p1->atom[i].carica!=p2->atom[j].carica)&&
			((p1->atom[i].carica==0)||(p2->atom[j].carica==0)))
			if ((distanza(p1->atom[i],p2->atom[j])<maxdist))
				score+=max(p1->atom[i].valore,p2->atom[j].valore);
	return score;
}
              
float distanza(struct Atom atomo1,struct Atom atomo2)
{
    return fsqrt(powf(atomo1.x-atomo2.x,2)+
                 powf(atomo1.y-atomo2.y,2)+
                 powf(atomo1.z-atomo2.z,2));        
}


