#include "sol.h"
#include "brk.h"
#include "escher.h"
#include "charges.h"
#include "surf.h"
#include "surf2prot.h"
#include "prot.h"
#include "shapes.h"
#include "my_macros.h"
#include <math.h>
#include <stdio.h>
#include <stdlib.h>

void input_err(char* string);
void read_param(int argc,char** argv);

/* parametri globali */

int f_shapes=1;		/*attiva shapes*/	
int only_charges=0;	/*se =1 fa solo la valutazione elettrostatica di due file brk*/
char nome_p1[100];	/*nomi delle proteine senza l'estensione .brk o .surf*/
char nome_p2[100];		
char nome_sol1[100];	/* nomi dei file soluzioni nel formato nomeprot1_nomeprot2.sol1 oppure .sol2 */
char nome_sol2[100];

int startx=-175;	/*angoli di inizio e fine delle rotazioni attorno a x e y*/
int endx=175;
int starty=-85;
int endy=85;

int stepx=10,stepy=10;	/*step in gradi delle rotazioni attorno a x e y*/

int col_attivo=120;		/* prima componente del colore rgb dei punti del file di superficie
					prodotti dalla nuova versione di insight*/
float spessore_sezione=1.5;	/* in Angstrom */
float larghezza_maglie=1.0;	/* della griglia dove cadono i punti delle superfici in Angstrom*/
float lunghezza_lato=1.5;	/* delle poligonali in Angstrom*/
float perimetro_min=20.0;	/* di una poligonale perche' venga considerata (in Angstrom)*/

int n_soluzioni=1000;		/* del file *.sol1 (prima del raggruppamento)*/
int sol_gen=-1;			/* se >=0 e' il numero della soluzione del file *.sol2 che si vuole generata in formato .brk*/

float maxdist_polar=3.4;	/*per charge: distanza massima di interazione fra atomi carichi con atomi carichi e/o apolari*/
float maxdist_apolar=4.0;	/*per charge: distanza massima di interazione fra atomi apolari*/
float overlap=0.1;		/*massima sovrapposizione permessa da bumps fra i raggi di vanderwalls di due atomi*/

float rms_rag=2.5;		/*rms di differenza massima per raggruppare insieme due soluzioni*/
float bu_max=200.;		/*soglia di bumps oltre la quale una soluzione viene scartata*/
float ca_max=-200.;		/*soglia di charge al di sotto della quale una soluzione viene scartata*/	

main(int argc, char* argv[])
{
	struct Solutions* s;
	struct Solutions* s2;
	struct Brk* BrkSol;
	struct Solutions* s3;
	char nome_brksol[100];
	char nome_brk2[100];
	struct Brk brk2;

	/*lettura dei parametri messi nella linea di comando*/
	read_param(argc,argv);

	/* creazione dei nomi dei file di soluzioni*/	
	sprintf(nome_sol1,"%s_%s.sol1",nome_p1,nome_p2);
	sprintf(nome_sol2,"%s_%s.sol2",nome_p1,nome_p2);

	/* codice da eseguire se si vuole produrre un file brk di una soluzione */
	if (sol_gen>=0)
	{
		sprintf(nome_brk2,"%s.brk",nome_p2); 
		brk_read(nome_brk2,&brk2);	/*legge la proteina probe*/
		s=SolutionsRead(nome_sol2);	/*legge il file *.sol2*/
		if (s->n_sol>sol_gen)
		{
			BrkSol=BrkSolutions(&brk2,s,sol_gen); /*crea la soluzione ruotando il probe come indicato nel file di Soluzioni*/
			sprintf(nome_brksol,"%s_%s.brk",nome_p1,nome_p2);	/*genera il nome per la soluzione target_probe.brk*/
			brk_write(nome_brksol,BrkSol);	/*scirve il file brk della soluzione*/ 
		}
		SolutionsDelete(s);	
		exit(1);
	}

	/*codice che genera il file *.sol1 */
	if (f_shapes==1) 
	{
		s=SolutionsNew(n_soluzioni); /*creazione di un vettore di soluzioni*/
		if (only_charges==0) shapes(s);	/* shapes inserisce le soluzioi nel vettore*/
		charges(s);			/* charges agiunge al vettore la loro valutazione elettrostatica*/
		SolutionsWrite(s,nome_sol1);	/*scrittura del file di soluzioni *.sol1*/	
		SolutionsDelete(s);
	}

	/*codice che genera il file *.sol2 partendo dal file *.sol1*/
	if (only_charges==0)
	{
		s=SolutionsRead(nome_sol1);	/* lettura del file *.sol1*/
		s2=SolutionsSort(s);			/* le soluzioni sono ordinate per valore di charges */
		s3=raggruppa(s2,rms_rag,bu_max,ca_max);	/* le soluzioni sono raggruppate */
		SolutionsWrite(s3,nome_sol2);		/*scrittura del file *.sol2*/
		SolutionsDelete(s);			
		SolutionsDelete(s2);
		SolutionsDelete(s3);
	}
}

void read_param(int argc,char** argv)	/* lettura dei parametri nella linea di comando*/
{
	int i;
	int param; 

	if (argc<3) input_err("Too few parameters");
	strcpy(nome_p1,argv[1]);	/* lettura dei nomi delle due proteine*/
	strcpy(nome_p2,argv[2]);

	for (i=3;i<argc;i++)	
	{
		sscanf(argv[i],"%*c%d",&param);
		switch (argv[i][0])
		{
			case 'z':startx=0;starty=0;endx=0;endy=0;break;
			case 'g':f_shapes=0;break;
			case 'e':only_charges=1;break;
			case 'r':stepx=param;stepy=param;break;
			case 'a':col_attivo=param;break;
			case 'l':n_soluzioni=param;break;
			case 'b':bu_max=param;break;
			case 'c':ca_max=param;break;
			case 's':sol_gen=param;break;
			default:input_err("Parameter not recognised");
		}
	}
}

void input_err(char* string)
{
	printf("\nError: %s\n\nFor a correct use read the file manual.txt\n",string);
	exit(1);
}

void shapes(struct Solutions *s)	/*genera le soluzioni geometriche e mette i loro valori di rot e trasl nella struct Solutions*/ 
{
	struct surf s1,s2,s2r;
	struct Proteina *p1,*p1ext,*p2;
	char nome_surf1[100],nome_surf2[100];

	/* processamento della proteina target*/

	sprintf(nome_surf1,"%s.surf",nome_p1);		/*  creazione del nome del file target.surf*/
 	surf_read(nome_surf1,&s1);			/*lettura del file target.surf*/
	p1=surf2prot(&s1,spessore_sezione);			/*trasformazione di target.surf in poligonali*/ 
	prot_ordina(p1,larghezza_maglie,perimetro_min);		/*ordinamento dei lati delle poligonali*/
	prot_lati(p1,lunghezza_lato);				/*omogeneizzazione della lunghezza dei lati delle poligonali*/ 
	prot_inverti(p1);					/*l'ordine dei lati del target viene invertito di senso
						per permettere il confronto con i lati del probe*/
	prot_angoli(p1);				/* calcolo degli angoli interni della poligonale (necessari per il confronto*/

	/*lettura della proteina probe*/

	sprintf(nome_surf2,"%s.surf",nome_p2);		/*  creazione del nome del file probe.surf*/
	surf_read(nome_surf2,&s2);			/*lettura del file probe.surf*/
	inizializza(&s1,&s2,lunghezza_lato,s);		/* settaggio delle matrici necessarie al confronto*/

	/*rotazioni*/

	for (s->angolox=startx;s->angolox<=endx;s->angolox+=stepx)
	{
		for (s->angoloy=starty;s->angoloy<=endy;s->angoloy+=stepy)
		{
			/* orientamento del probe*/

			surf_copy(&s2r,&s2); /*creazione di una copia del probe da ruotare liberamente*/
			printf("\nRot: X %4d Y %4d ",s->angolox,s->angoloy);
			surf_translate(&s2r,-s->centrox,-s->centroy,-s->centroz); /*sovrapposizione dei baricentri del target e del probe*/
			surf_x_rotate(&s2r,s->angolox*(M_PI/180));	/* orientamento del probe in x*/
			surf_y_rotate(&s2r,s->angoloy*(M_PI/180));	/* orientamento del probe in y*/
			surf_translate(&s2r,s->centrox,s->centroy,s->centroz); /*il probe ritorna nella posizione originale*/
		
			/* processamento della proteina probe*/

			p2=surf2prot(&s2r,spessore_sezione);   		 /*trasformazione di target.surf in poligonali*/
			prot_ordina(p2,larghezza_maglie,perimetro_min);	 /*ordinamento dei lati delle poligonali*/
			prot_lati(p2,lunghezza_lato);			/*omogeneizzazione della lunghezza dei lati delle poligonali*/
			prot_angoli(p2);		/* calcolo degli angoli interni della poligonale (necessari per il confronto*/
			
			p1ext=proteina_copy(p1);		/* copia del target da estendere mantenedo intatto l'originale*/
			prot_estendi(p1ext,estensione(p1,p2));	/*estensione dei lati del target necessario al confronto*/
			prot_estendi(p2,estensione(p1,p2));	/*estensione dei lati del probe necessario al confronto*/

			analizza(p1ext,p2,s); /*confronto delle proteine e salvataggio delle soluzionin nella struct 's' */
			proteina_delete(p1ext);
			surf_delete(&s2r);
			proteina_delete(p2);
		}
	}  
}

void charges(struct Solutions *s) /* aggiunge alla struct s (soluzioni) i dati elettrostatici edi bumps*/
{
	int i;
	struct Brk brk1,brk2;
	struct Brk* BrkSol;
	char nome_brk1[100],nome_brk2[100];
	
	/*legge le protine target e probe*/	

	sprintf(nome_brk2,"%s.brk",nome_p2);
	sprintf(nome_brk1,"%s.brk",nome_p1);
	brk_read(nome_brk2,&brk2);
	brk_read(nome_brk1,&brk1);

	/*per ognuna delle soluzioni presenti nella struct aggiunge i dati*/

	for (i=0;i<s->n_sol;i++)
	{
		BrkSol=BrkSolutions(&brk2,s,i); 		/* genera la soluzione iesima */
		s->sol[i].rms=brk_rms(&brk2,BrkSol);	       	 /*valuta l'rms il probe e la soluzione*/
		s->sol[i].bumps=brk_bumps(&brk1,BrkSol,overlap); /*valuta i bumps tra il target e la soluzione */
		s->sol[i].pos_neg=brk_pos_neg(&brk1,BrkSol,maxdist_polar);/* valuta le interazioni pos. neg. fra tar. e sol.*/
		s->sol[i].apo_apo=brk_apo_apo(&brk1,BrkSol,maxdist_apolar);/* valuta le interazioni apolari fra tar. e sol.*/
		s->sol[i].pos_pos=brk_pos_pos(&brk1,BrkSol,maxdist_polar);/* valuta le interazioni fra cariche uguali fra tar. e sol.*/
		s->sol[i].apo_pos=brk_apo_pos(&brk1,BrkSol,maxdist_polar);/* valuta le interazioni polare apolare fra tar. e sol.*/
		s->sol[i].charge=s->sol[i].pos_neg+s->sol[i].apo_apo;	/* calcola il punteggio totale di charge*/
		s->sol[i].charge-=s->sol[i].pos_pos+s->sol[i].apo_pos;
/* da togliere 
		s->sol[i].charge=brk_surfatoms(&brk1,BrkSol,0.5);*/
		brk_delete(BrkSol);		
	}
	brk_delete(&brk1);brk_delete(&brk2);
}

struct Solutions* raggruppa(struct Solutions* s,float rms_rag,float bu_max,float ca_max)
{
	int i,j,good;
	register int k;
        struct Brk brk;
	struct Brk* BrkSol;
        char nome_brk2[100];
	struct Solutions* s2;
	FILE* g;
        register float dx,dy,dz,val;
        register float *gab1,*gab2;
        
	s2=SolutionsCopy(s);
	s2->n_sol=0;
        sprintf(nome_brk2,"%s.brk",nome_p2);
        brk_read(nome_brk2,&brk);
	gab1=(float*)calloc(brk.n_atoms*3,sizeof(float));
	gab2=(float*)calloc(brk.n_atoms*3,sizeof(float));
	
	for (i=0;i<s->n_sol;i++) if ((s->sol[i].charge>ca_max)&&(s->sol[i].bumps<bu_max))
	{
		BrkSol=BrkSolutions(&brk,s,i);
               	for (j=0;j<BrkSol->n_atoms;j++)
		{
			gab1[j*3]=BrkSol->atom[j].x;
			gab1[j*3+1]=BrkSol->atom[j].y;
			gab1[j*3+2]=BrkSol->atom[j].z;
		}
		brk_delete(BrkSol);

		good=1;
		g=fopen("raggruppa.dat","rb");
		for (j=0;j<s2->n_sol;j++)
		{	
			fread(gab2,brk.n_atoms*3,sizeof(float),g);
                        val=0;
			for (k=0;k<brk.n_atoms*3;)
        		{               
				dx=gab1[k]-gab2[k];k++;
                		dy=gab1[k]-gab2[k];k++;
                        	dz=gab1[k]-gab2[k];k++;
                        	val+=dx*dx+dz*dz+dy*dy;
			}
			if (val/brk.n_atoms<(rms_rag*rms_rag)) {good=0;break;}
		} 
		fclose(g);
				
		if (good) 
		{
			SolutionCopy(&s2->sol[s2->n_sol++],&s->sol[i]);
			g=fopen("raggruppa.dat","ab");
			fwrite(gab1,brk.n_atoms*3,sizeof(float),g);
                	fclose(g);
		}
     	}
	free(gab1);
	free(gab2);
	system ("rm raggruppa.dat");
	return s2;
}
