#include "surf.h"
#include "my_macros.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>

void surf_read(char* name,struct surf* surf)
{
   int i,buffer_counter,atoms_counter;   
   FILE *f; 
   char buffer[100];

   f=fopen(name,"r");if (f==NULL) {fprintf(stderr,"surf_read\n");exit(1);}   
   surf->n_atoms=0;
   surf->n_dots=0;
   fscanf(f,"DOTS\n");
   while (!feof(f))
   {
      fgets(buffer,100,f); 
      	if (buffer[0]=='A') 
	{
		surf->n_atoms++;
	   	/* modifica per le nuove surf di insightII*/
		surf->n_dots--;
	}
      if (!feof(f)) surf->n_dots++;
   }
    
   surf->atom=(struct atom_ref*)calloc(surf->n_atoms,sizeof(struct atom_ref));
   surf->col=(int*)calloc(surf->n_dots,sizeof(int));
   surf->x=(float*)calloc(surf->n_dots,sizeof(float));
   surf->y=(float*)calloc(surf->n_dots,sizeof(float));
   surf->z=(float*)calloc(surf->n_dots,sizeof(float));
   if (surf->z==NULL) {fprintf(stderr,"surf_read\n");exit(1);}

   for(i=0;i<surf->n_atoms;i++) surf->atom[i].atom_dots=0;
   rewind(f);
   fscanf(f,"DOTS\n");
   atoms_counter=-1;
   for(i=0;i<surf->n_dots;i++) 
   {
      fgets(buffer,100,f); 
      if (buffer[0]=='A')
      {
       	atoms_counter++; 
	buffer_counter=0;  
	while (buffer[buffer_counter++]!=' '); 
       	while (buffer[buffer_counter++]!=' '); 
	memcpy(surf->atom[atoms_counter].label,buffer,30); 
     	surf->atom[atoms_counter].label[buffer_counter+1]='\0';
        surf->atom[atoms_counter].atom_dots=0;
       	/* modifiche per le nuove surf di insightII */ 
	i--;
	/* sscanf(buffer+buffer_counter,"%f %f %f",surf->x+i,surf->y+i,surf->z+i);
	surf->col[i]=0;*/
      }
      else 
      {
         sscanf(buffer,"%f %f %f %d",surf->x+i,surf->y+i,surf->z+i,surf->col+i);
         surf->atom[atoms_counter].atom_dots++;
      }
   }
   fclose(f);
   surf->org.x=0;surf->org.y=0;surf->org.z=0;   
}

void surf_write(char* name,struct surf* surf)
{
   int i,j,dots_counter;   
   FILE *f; 
   
   f=fopen(name,"w");if (f==NULL) {fprintf(stderr,"surf_read\n");exit(1);}   
   fprintf(f,"DOTS\n");
   dots_counter=0;
   for(i=0;i<surf->n_atoms;i++) 
   {
      fprintf(f,"%s\n",surf->atom[i].label); 
      for (j=0;j<surf->atom[i].atom_dots;j++)
      {
         fprintf(f,"%.6f %.6f %.6f %d\n",surf->x[dots_counter],
            surf->y[dots_counter],surf->z[dots_counter],surf->col[dots_counter]); 
         dots_counter++;
      }    
   }  
   fclose(f);
}

void surf_translate(struct surf* surf,float x,float y,float z)
{
   int i;
   for (i=0;i<surf->n_dots;i++)
   {
      surf->x[i]+=x;surf->y[i]+=y;surf->z[i]+=z;
   }
   surf->org.x-=x;surf->org.y-=y;surf->org.z-=z;
}

void surf_x_rotate(struct surf* surf,float rx)
{
   int i;
   float raggio,angolo;
   for (i=0;i<surf->n_dots;i++)
   {
      raggio=sqrtf(surf->z[i]*surf->z[i]+surf->y[i]*surf->y[i]);
      angolo=rx+atan2f(surf->y[i],surf->z[i]);
      surf->z[i]=raggio*cosf(angolo);
      surf->y[i]=raggio*sinf(angolo);
   }
}

void surf_y_rotate(struct surf* surf,float ry)
{
   int i;
   float raggio,angolo;
   for (i=0;i<surf->n_dots;i++)
   {
      raggio=sqrtf(surf->z[i]*surf->z[i]+surf->x[i]*surf->x[i]);
      angolo=ry+atan2f(surf->x[i],surf->z[i]);
      surf->z[i]=raggio*cosf(angolo);
      surf->x[i]=raggio*sinf(angolo);
   }
}

void surf_z_rotate(struct surf* surf,float rz)
{
   int i;
   float raggio,angolo;
   for (i=0;i<surf->n_dots;i++)
   {
      raggio=sqrtf(surf->x[i]*surf->x[i]+surf->y[i]*surf->y[i]);
      angolo=rz+atan2f(surf->y[i],surf->x[i]);
      surf->x[i]=raggio*cosf(angolo);
      surf->y[i]=raggio*sinf(angolo);
   }
}

void surf_copy(struct surf* dest,const struct surf* source)
{
   dest->org=source->org;
   dest->n_atoms=source->n_atoms;
   dest->n_dots=source->n_dots;
   dest->atom=(struct atom_ref*)calloc(dest->n_atoms,sizeof(struct atom_ref));
   dest->col=(int*)calloc(dest->n_dots,sizeof(int));
   dest->x=(float*)calloc(dest->n_dots,sizeof(float));
   dest->y=(float*)calloc(dest->n_dots,sizeof(float));
   dest->z=(float*)calloc(dest->n_dots,sizeof(float));
   if (dest->z==NULL) {fprintf(stderr,"surf_copy\n");exit(1);}
   memcpy(dest->col,source->col,dest->n_dots*sizeof(int));
   memcpy(dest->x,source->x,dest->n_dots*sizeof(float));
   memcpy(dest->y,source->y,dest->n_dots*sizeof(float));
   memcpy(dest->z,source->z,dest->n_dots*sizeof(float));
   memcpy(dest->atom,source->atom,dest->n_atoms*sizeof(struct atom_ref));
}

void surf_delete(struct surf* surf)
{
   free(surf->atom);
   free(surf->x);
   free(surf->y); 
   free(surf->z);
   free(surf->col);
}

struct point surf_center(struct surf* surf)
{
   int i;
   float z_min,z_max,x_min,x_max,y_min,y_max;
   struct point centro;

   z_min=surf->z[0];z_max=surf->z[0];
   x_min=surf->x[0];x_max=surf->x[0];
   y_min=surf->y[0];y_max=surf->y[0];
   for (i=0;i<surf->n_dots;i++)
   { 
      z_min=min(z_min,surf->z[i]);
      x_min=min(x_min,surf->x[i]);
      y_min=min(y_min,surf->y[i]);
      z_max=max(z_max,surf->z[i]);
      x_max=max(x_max,surf->x[i]);
      y_max=max(y_max,surf->y[i]);
   } 
   centro.x=x_min+(x_max-x_min)/2.0;
   centro.y=y_min+(y_max-y_min)/2.0;
   centro.z=z_min+(z_max-z_min)/2.0;
   return centro;
} 

void surf_max_min(struct surf* surf, struct point *smax, struct point *smin)
{
   int i;
   float z_min,z_max,x_min,x_max,y_min,y_max;

   z_min=surf->z[0];z_max=surf->z[0];
   x_min=surf->x[0];x_max=surf->x[0];
   y_min=surf->y[0];y_max=surf->y[0];
   for (i=0;i<surf->n_dots;i++)
   {
      z_min=min(z_min,surf->z[i]);
      x_min=min(x_min,surf->x[i]);
      y_min=min(y_min,surf->y[i]);
      z_max=max(z_max,surf->z[i]);
      x_max=max(x_max,surf->x[i]);
      y_max=max(y_max,surf->y[i]);
   }
   smax->x=x_max;smax->y=y_max;smax->z=z_max;
   smin->x=x_min;smin->y=y_min;smin->z=z_min;
}

float surf_radius_max(struct surf* surf,struct point centro)
{
   int i;
   float radius_max=0.;
   float x,y,z;
   for (i=0;i<surf->n_dots;i++)
   {
      x=(surf->x[i]-centro.x)*(surf->x[i]-centro.x);
      y=(surf->y[i]-centro.y)*(surf->y[i]-centro.y);
      z=(surf->z[i]-centro.z)*(surf->z[i]-centro.z);     
      radius_max=max(radius_max,sqrt(x+y+z));
   }
   return radius_max;
}
