#ifndef SURF
#define SURF

struct point {float x,y,z;};

struct surf
{
   struct atom_ref* atom;
   float* x;
   float* y;
   float* z;
   int* col;
   int n_atoms;
   int n_dots;
   struct point org;
};

struct atom_ref
{
   char label[30];
   int atom_dots;
};

void surf_read(char* name,struct surf*);
void surf_write(char* name,struct surf*);
void surf_translate(struct surf*,float x,float y,float z);
void surf_x_rotate(struct surf*,float rx);
void surf_y_rotate(struct surf*,float ry);
void surf_z_rotate(struct surf*,float rz);
void surf_copy(struct surf* dest,const struct surf* source);
void surf_delete(struct surf*);
struct point surf_center(struct surf*);
void surf_max_min(struct surf*,struct point *max, struct point *min);
float surf_radius_max(struct surf*,struct point centro);
#endif
