
/*********************************************************************
****         ESCHER Next Generation - Score attribution           ****
**** (c) 1997-2012, G. Ausiello, G. Cesareni, M. Helmer Citterich ****
****               NG version by Alessandro Pedretti              ****
*********************************************************************/


#include "my_macros.h"

#include "brk.h"
#include "charges.h"

#if 0
float brk_surfatoms(ES_BRK *p1, ES_BRK *p2)
{
  ES_ULONG      i, j;
  float         dist, sommaraggi;

  float         score = 0.0f;

  for(i = 0; i < p1 -> n_atoms; i++) {
    for(j = i; j < p2 -> n_atoms; j++) {
      dist       = Distance(&p1 -> atom[i], &p2 -> atom[j]);
      sommaraggi = p1 -> atom[i].r + p2 -> atom[j].r + 0.3;
      if (dist < sommaraggi + 0.6f) {
      printf("%3d %3d %4.1f\n",
             p1 -> atom[i].carica, p2 -> atom[j].carica, j, dist - sommaraggi);
      }
      if (dist < sommaraggi) {
        score += (dist - sommaraggi) * 20.0f;
      } else {
      if (dist < sommaraggi + 0.6f)
      score += 1.0f; /* 5.0f * (0.7f - (dist - sommaraggi)); */
    }
  } /* End of for (j) */
  } /* End of for (i) */

  printf("                 %f\n", score);

  return score;
}
#endif


/**** Evaluate the collisions ****/

float brk_bumps(ES_BRK *p1, ES_BRK *p2, ES_ATMFLAG *p1flags, ES_ATMFLAG *p2flags,
                float overlap)
{
  ES_ULONG      i, j;
  float         dist, mindist;

  float         score = 0.0f;

  for(i = 0; i < p1 -> n_atoms; i++) p1flags[i].bf = 0;
  for(j = 0; j < p2 -> n_atoms; j++) p2flags[j].bf = 0;

  for(i = 0; i < p1 -> n_atoms; i++) {
    for(j = 0; j < p2 -> n_atoms; j++) {
      dist    = Distance(&p1 -> atom[i], &p2 -> atom[j]);
      mindist = p1 -> atom[i].r + p2 -> atom[j].r - overlap;
      if (dist < mindist) {
        p1flags[i].bf = 1;
        p2flags[j].bf = 1;
        score += mindist - dist;
      }
    } /* End of for (j) */
  } /* End of for (i) */

  return score;
}


/**** Evaluate the actractive electrostatic interactions ****/

float brk_pos_neg(ES_BRK *p1, ES_BRK *p2, ES_ATMFLAG *p1flags, ES_ATMFLAG *p2flags,
                  float maxdist)
{
  ES_ULONG      i, j;

  float         score = 0.0f;

  for(i = 0; i < p1 -> n_atoms; i++) p1flags[i].cf = 0;
  for(j = 0; j < p2 -> n_atoms; j++) p2flags[j].cf = 0;

  for(i = 0; i < p1 -> n_atoms; i++)
    if (p1 -> atom[i].carica > 0)
      if (p1flags[i].bf == 0)
        if (p1flags[i].cf == 0)
          for(j = 0; j < p2 -> n_atoms; j++)
            if (p2 -> atom[j].carica > 0)
              if(p2flags[j].bf == 0)
                if(p2flags[j].cf == 0)
                  if(((p1 -> atom[i].carica >= 2) && (p2 -> atom[j].carica <= 2)) ||
                     ((p1 -> atom[i].carica <= 2) && (p2 -> atom[j].carica >= 2)))
                    if (Distance(&p1 -> atom[i], &p2 -> atom[j]) < maxdist) {
                      p1flags[i].cf  = 1;
                      p2flags[j].cf  = 1;
                      score         += p1 -> atom[i].valore + p2 -> atom[j].valore;
                    }

  return score;
}


/**** Evaluate the apolar interactions ****/

float brk_apo_apo(ES_BRK *p1, ES_BRK *p2, ES_ATMFLAG *p1flags, ES_ATMFLAG *p2flags,
                  float maxdist)
{
  ES_ULONG      i, j;

  float         score = 0.0f;

  for(i = 0; i < p1 -> n_atoms; i++) {
    if ((p1 -> atom[i].carica == 0) && (p1flags[i].bf == 0)) {
      for(j = 0; j < p2 -> n_atoms; j++) {
        if ((p2flags[j].bf == 0) && (p2 -> atom[j].carica == 0) &&
            (Distance(&p1 -> atom[i], &p2 -> atom[j]) < maxdist))
         score += 1.0f;
      } /* End of for */
    }
  } /* End of for */

  return score;
}


/**** Repulsive interactions ****/

float brk_pos_pos(ES_BRK *p1, ES_BRK *p2, ES_ATMFLAG *p1flags, ES_ATMFLAG *p2flags,
                  float maxdist)
{
  ES_ULONG      i, j;

  float         score = 0.0f;

  for(i = 0; i < p1 -> n_atoms; i++)
    if (p1flags[i].cf == 0)
      if ((p1 -> atom[i].carica == 1) || (p1 -> atom[i].carica == 1))
        for(j = 0; j < p2 -> n_atoms; j++)
          if (p2flags[j].cf == 0)
            if ((Distance(&p1 -> atom[i], &p2 -> atom[j]) < maxdist))
              if (((p1 -> atom[i].carica == 1) && (p2 -> atom[j].carica == 1)) ||
                  ((p1 -> atom[i].carica == 3) && (p2 -> atom[j].carica == 3)))
                score += p1 -> atom[i].valore + p2 -> atom[j].valore;

  return score;
}


/**** Repulsive interactions ****/

float brk_apo_pos(ES_BRK *p1, ES_BRK *p2, ES_ATMFLAG *p1flags, ES_ATMFLAG *p2flags,
                  float maxdist)
{
  ES_ULONG      i, j;

  float         score = 0.0f;

  for(i = 0; i < p1 -> n_atoms; i++)
    if (p1flags[i].cf == 0)
      for(j = 0; j < p2 -> n_atoms; j++)
        if (p2flags[j].cf == 0)
          if ((p1 -> atom[i].carica != p2 -> atom[j].carica) &&
              ((p1 -> atom[i].carica == 0) || (p2 -> atom[j].carica == 0)))
            if ((Distance(&p1 -> atom[i], &p2->atom[j]) < maxdist))
              score += max(p1 -> atom[i].valore, p2 -> atom[j].valore);

  return score;
}


/**** Calculate the distance between two atoms ****/

float Distance(ES_ATOM *Atm1, ES_ATOM *Atm2)
{
  return fsqrt(square(Atm1 -> x - Atm2 -> x) +
               square(Atm1 -> y - Atm2 -> y) +
               square(Atm1 -> z - Atm2 -> z));
}


