
/*********************************************************************
****          ESCHER Next Generation - Atom parameters            ****
**** (c) 1997-2012, G. Ausiello, G. Cesareni, M. Helmer Citterich ****
****               NG version by Alessandro Pedretti              ****
*********************************************************************/

/* Parameters for elements:                                            */
/* Element, Atomic number, Mass, Covalent radius, Van Der Waals radius */

#ifndef __ES_PARAM
#  define __ES_PARAM

#  define  ES_DEFAULT_VDWRAD      1.70f


const ES_ATMTAB AtmTable[]     = {{{"H" },   1, 1.008f, 0.37f, 1.20f},
                                  {{"C" },   6, 12.01f, 0.77f, 1.70f},
                                  {{"N" },   7, 14.01f, 0.75f, 1.55f},
                                  {{"O" },   8, 16.00f, 0.73f, 1.52f},
                                  {{"S" },  16, 32.06f, 1.02f, 1.80f},
                                  {{"P" },  15, 30.97f, 1.10f, 1.80f},
                                  {{"F" },   9, 19.00f, 0.71f, 1.47f},
                                  {{"Cl"},  17, 35.45f, 0.99f, 1.75f},
                                  {{"Br"},  35, 79.90f, 1.14f, 1.85f},
                                  {{"I" },  53, 126.9f, 1.33f, 1.98f},

                                  {{"He"},   2, 4.003f, 0.50f, 1.80f},
                                  {{"Li"},   3, 6.941f, 1.34f, 1.80f},
                                  {{"Be"},   4, 9.012f, 1.25f, 1.82f},
                                  {{"B" },   5, 10.81f, 0.90f, 1.98f},
                                  {{"Ne"},  10, 20.18f, 0.65f, 1.55f},
                                  {{"Na"},  11, 22.99f, 1.54f, 2.30f},
                                  {{"Mg"},  12, 24.31f, 1.45f, 1.70f},
                                  {{"Al"},  13, 26.98f, 1.30f, 1.74f},
                                  {{"Si"},  14, 28.09f, 1.18f, 2.10f},
                                  {{"Ar"},  18, 39.95f, 0.95f, 1.90f},
                                  {{"K" },  19, 39.10f, 1.96f, 2.80f},
                                  {{"Ca"},  20, 40.08f, 1.74f, 1.94f},
                                  {{"Sc"},  21, 44.96f, 1.44f, 1.82f},
                                  {{"Ti"},  22, 47.90f, 1.32f, 2.25f},
                                  {{"V" },  23, 50.94f, 1.25f, 2.18f},
                                  {{"Cr"},  24, 52.00f, 1.27f, 2.11f},
                                  {{"Mn"},  25, 54.94f, 1.43f, 2.03f},
                                  {{"Fe"},  26, 55.85f, 1.22f, 1.22f},
                                  {{"Co"},  27, 58.93f, 1.26f, 1.26f},
                                  {{"Ni"},  28, 58.71f, 1.20f, 1.61f},
                                  {{"Cu"},  29, 63.55f, 1.38f, 1.41f},
                                  {{"Zn"},  30, 65.37f, 1.25f, 1.40f},
                                  {{"Ga"},  31, 69.72f, 1.25f, 1.26f},
                                  {{"Ge"},  32, 72.60f, 1.22f, 1.22f},
                                  {{"As"},  33, 74.92f, 1.21f, 1.20f},
                                  {{"Se"},  34, 78.96f, 1.17f, 1.16f},
                                  {{"Kr"},  36, 83.80f, 1.11f, 1.12f},
                                  {{"Rb"},  37, 85.47f, 2.16f, 2.16f},
                                  {{"Sr"},  38, 87.62f, 1.91f},
                                  {{"Y" },  39, 88.91f, 1.62f},
                                  {{"Zr"},  40, 91.22f, 1.45f},
                                  {{"Nb"},  41, 92.91f, 1.34f},
                                  {{"Mo"},  42, 95.94f, 1.30f},
                                  {{"Tc"},  43, 99.00f, 1.27f},
                                  {{"Ru"},  44, 101.1f, 1.25f},
                                  {{"Rh"},  45, 102.9f, 1.25f},
                                  {{"Pd"},  46, 106.4f, 1.28f},
                                  {{"Ag"},  47, 107.9f, 1.34f},
                                  {{"Cd"},  48, 112.4f, 1.41f},
                                  {{"In"},  49, 114.8f, 1.50f},
                                  {{"Sn"},  50, 118.7f, 1.40f},
                                  {{"Sb"},  51, 121.8f, 1.39f},
                                  {{"Te"},  52, 127.6f, 1.37f},
                                  {{"Xe"},  54, 131.3f, 1.30f},
                                  {{"Cs"},  55, 132.9f, 2.35f},
                                  {{"Ba"},  56, 137.3f, 1.98f},
                                  {{"La"},  57, 138.9f, 1.69f},
                                  {{"Ce"},  58, 140.1f, 1.65f},
                                  {{"Pr"},  59, 140.9f, 1.65f},
                                  {{"Nd"},  60, 144.2f, 1.64f},
                                  {{"Pm"},  61, 147.0f, 1.63f},
                                  {{"Sm"},  62, 150.4f, 1.62f},
                                  {{"Eu"},  63, 152.0f, 1.85f},
                                  {{"Gd"},  64, 157.3f, 1.61f},
                                  {{"Tb"},  65, 158.9f, 1.59f},
                                  {{"Dy"},  66, 162.5f, 1.59f},
                                  {{"Ho"},  67, 164.9f, 1.58f},
                                  {{"Er"},  68, 167.3f, 1.57f},
                                  {{"Tm"},  69, 168.9f, 1.56f},
                                  {{"Yb"},  70, 173.0f, 1.56f},
                                  {{"Lu"},  71, 175.0f, 1.56f},
                                  {{"Hf"},  72, 178.5f, 1.44f},
                                  {{"Ta"},  73, 180.9f, 1.34f},
                                  {{"W" },  74, 183.9f, 1.30f},
                                  {{"Re"},  75, 186.2f, 1.28f},
                                  {{"Os"},  76, 190.2f, 1.26f},
                                  {{"Ir"},  77, 192.2f, 1.27f},
                                  {{"Pt"},  78, 195.1f, 1.30f},
                                  {{"Au"},  79, 197.0f, 1.34f},
                                  {{"Hg"},  80, 200.6f, 1.44f},
                                  {{"Tl"},  81, 204.4f, 1.55f},
                                  {{"Pb"},  82, 207.2f, 1.54f},
                                  {{"Bi"},  83, 209.0f, 1.51f},
                                  {{"Po"},  84, 210.0f, 1.46f},
                                  {{"At"},  85, 210.0f, 1.45f},
                                  {{"Rn"},  86, 222.0f, 1.45f},
                                  {{"Fr"},  87, 223.0f, 1.00f},
                                  {{"Ra"},  88, 226.0f, 1.00f},
                                  {{"Ac"},  89, 227.0f, 1.00f},
                                  {{"Th"},  90, 232.0f, 1.00f},
                                  {{"Pa"},  91, 231.0f, 1.00f},
                                  {{"U" },  92, 238.0f, 1.00f},
                                  {{"Np"},  93, 237.0f, 1.00f},
                                  {{"Pu"},  94, 242.0f, 1.00f},
                                  {{"Am"},  95, 243.0f, 1.00f},
                                  {{"Cm"},  96, 248.0f, 1.00f},
                                  {{"Bk"},  97, 247.0f, 1.00f},
                                  {{"Cf"},  98, 251.0f, 1.00f},
                                  {{"Es"},  99, 254.0f, 1.00f},
                                  {{"Fm"}, 100, 253.0f, 1.00f},
                                  {{"Md"}, 101, 256.0f, 1.00f},
                                  {{"No"}, 102, 254.0f, 1.00f},
                                  {{"Lw"}, 103, 257.0f, 1.00f},
                                  {{"Rf"}, 104, 261.0f, 1.00f},
                                  {{"Dd"}, 105, 262.0f, 1.00f},
                                  {{"Sg"}, 106, 266.0f, 1.00f},
                                  {{"Bh"}, 107, 264.0f, 1.00f},
                                  {{"Hs"}, 108, 269.0f, 1.00f},
                                  {{"Mt"}, 109, 268.0f, 1.00f},

                                  {{"Du"}, 200, 12.01f, 0.77f, 1.94f},
                                  {{"Lp"}, 201,  0.00f, 0.00f, 0.00f},
                                  {{"Xc"}, 202,  0.00f, 0.00f, 0.00f},

                                  {{""  },   0,  0.00f, 0.00f, 0.00f}
                                 };
#endif

