
/*********************************************************************
****             ESCHER Next Generation - Surf2Prot               ****
**** (c) 1997-2012, G. Ausiello, G. Cesareni, M. Helmer Citterich ****
****               NG version by Alessandro Pedretti              ****
*********************************************************************/


#include "my_macros.h"

#include "prot.h"
#include "surf.h"
#include "surf2prot.h"
#include "utils.h"


/**** Convert the surface in polygonals ****/

struct Proteina *Surf2Prot(struct surf *surf, float spessore)
{
  int                   i, j, dot;
  int                   *n_vertici;
  struct Proteina       *p;
  struct point          smax, smin;

  surf_max_min(surf, &smax, &smin);

  if ((p = proteina_new(1 + (int)((smax.z - smin.z) / spessore))) != NULL) {
    p -> spessore = spessore;
    p -> z_min    = smin.z;

    if ((n_vertici = (int *)Alloca(p -> n_poligonali * sizeof(int))) != NULL) {
      for(i = 0; i < p -> n_poligonali; i++) n_vertici[i] = 0;

      for(dot = 0, i = 0; i < surf -> n_atoms; i++)
        for(j = 0; j < surf -> atom[i].atom_dots; j++, dot++)
          n_vertici[(int)((surf -> z[dot] - p -> z_min) /spessore)]++;

      for (i = 0; i < p -> n_poligonali; i++) {
        poligonale_new(&p -> poligonale[i], n_vertici[i]);
        p -> poligonale[i].n_vertici = 0;
      } /* End of for */


      for (dot = 0, i = 0; i < surf -> n_atoms; i++) {
        for (j = 0; j < surf -> atom[i].atom_dots; j++, dot++) {
          int sezione =(unsigned)((surf -> z[dot] - p -> z_min) / spessore);
          int punto_sezione = p -> poligonale[sezione].n_vertici++;
          p -> poligonale[sezione].vertice[punto_sezione].x   = surf -> x[dot];
          p -> poligonale[sezione].vertice[punto_sezione].y   = surf -> y[dot];
          p -> poligonale[sezione].vertice[punto_sezione].col = surf -> col[dot];
        } /* End of for */
      } /* End of for */
    } else {
      proteina_delete(p);
      p = NULL;
    }
  }

  return p;
}
