
/*********************************************************************
****              ESCHER Next Generation - Utilities              ****
**** (c) 1997-2012, G. Ausiello, G. Cesareni, M. Helmer Citterich ****
****               NG version by Alessandro Pedretti              ****
*********************************************************************/


#include <ctype.h>
#include <stdarg.h>

#ifdef __BORLANDC__
#  pragma hdrstop
#endif

#include <sys/stat.h>

#ifdef __WIN32__
#  define  DXWCPU_C
#  include <dxwcpu.h>
#  include <shlobj.h>

extern DXWCPU           EsCpu;
#endif

#include "my_macros.h"
#include "globstr.h"
#include "utils.h"

#  if defined(WIN32) && !defined(strcasecmp)
#    define  strcasecmp         stricmp
#  endif


/**** Allocate the memory with error check ****/

void *Alloca(ES_ULONG Mem)
{
  void    *Ind;

  if ((Ind = (void *)ALLOC(Mem)) == NULL)
    fprintf(stderr, "Out of memory\n");

  return Ind;
}


/**** Check if the directory exists ****/

ES_BOOL DirExists(char *DirName)
{
  struct stat           StatBuf;

  if ((!DirName) || (!*DirName) ||
      (stat(DirName, &StatBuf)))
    return FALSE;

  return (StatBuf.st_mode & S_IFDIR);
}


/**** Check if the file exists ****/

ES_BOOL FileExists(char *FileName)
{
  struct stat           StatBuf;

  if ((!FileName) || (!*FileName) ||
      (stat(FileName, &StatBuf)))
    return FALSE;

  return (StatBuf.st_mode & S_IFREG);
}


/**** Return the file name ****/

char *GetFileName(char *Str)
{
  register char *Ptr = Str + strlen(Str);

  while ((Ptr != Str) &&
#ifdef AMIGA
         (*Ptr != ':') &&
#endif

#ifdef WIN32
         (*Ptr != '\\')
#else
         (*Ptr != '/')
#endif
        ) --Ptr;

  if (Ptr != Str) ++Ptr;

  return Ptr;
}


/**** Return the file name ****/

void GetFilePath(char *Path, char *Str)
{
  register char *Ptr;

  strcpy(Path, Str);
  Ptr = Path + strlen(Path);

  while ((Ptr != Path) &&
#ifdef AMIGA
         (*Ptr != ':') &&
#endif

#ifdef WIN32
         (*Ptr != '\\')
#else
         (*Ptr != '/')
#endif
        ) --Ptr;

  *Ptr = 0;
}


/**** Return the program path ****/

ES_BOOL GetPrgPath(char *Str, ES_BOOL ConfigDir)
{
  char          *CharPtr, *Env;

  if ((Env = getenv("VEGADIR")) == NULL) {
#ifdef AMIGA
    strcpy(Str, "PROGDIR:");
#else
#  ifdef WIN32
   if (ConfigDir) {
     char          Path[MAX_PATH];
     IMalloc *     pShellMalloc;
     LPITEMIDLIST  pidlItem;

     SHGetMalloc(&pShellMalloc);
     SHGetSpecialFolderLocation(NULL, CSIDL_COMMON_APPDATA, &pidlItem);
     SHGetPathFromIDList(pidlItem, Path);
     pShellMalloc -> lpVtbl -> Free(pShellMalloc, pidlItem);
     strcpy(Str, Path);
     strcat(Str, "\\VEGA ZZ");

     if (!DirExists(Str)) {
       GetPrgPath(Str, FALSE);
       strcat(Str, "Config\\");
       return TRUE;
     }
   } else {
     if (GetModuleFileName(NULL, Str, MAX_PATH)) {
       for(CharPtr = Str + strlen(Str) - 1; *CharPtr; --CharPtr) {
         if (*CharPtr == '\\') {
           CharPtr[1] = 0;
           break;
         }
       } /* End of for (CharPtr) */
       strcat(Str, "\\..\\..");
     }
   }
#  else
    return CatErr(MSG_ERR_UTILS_VEGADIR);
#  endif
#endif
  } else strcpy(Str, Env);

  CharPtr = Str + strlen(Str) - 1;

#ifdef WIN32
  if (*CharPtr != '\\') strcat(Str, "\\");
  if (ConfigDir) strcat(Str, "Config\\");
#else
  if ((*CharPtr != ':') && (*CharPtr != '/')) strcat(Str, "/");
  if (ConfigDir) strcat(Str, "Config/");
#endif

  return TRUE;
}


/**** Load the preferences ****/

void LoadPrefs(ES_PREFS *Prf, char *FileName)
{
  char                  Buf[256], *Ptr;
  FILE                  *FH;

  static const char     *Sep = " \t\012\015";

  if ((FH = fopen(FileName, "r")) != NULL) {
    while(fgets(Buf, 255, FH)) {
      if (((Ptr = strtok(Buf, Sep)) != NULL) &&
          (*Ptr != ';')) {
        if ((!strcasecmp(Ptr, "LANGUAGE")) &&
            ((Ptr = strtok(NULL, Sep)) != NULL) &&
            (strlen(Ptr) < ES_PRF_LANGLEN)) {
          strcpy(Prf -> Language, Ptr);
          Lower(Prf -> Language);
        }
      }
    } /* End of while */
    fclose(FH);
  } /* End of while */
}


/**** Convert to lower case ****/

void Lower(register char *Str)
{
  do {
    if ((*Str >= 'A') && (*Str <= 'Z')) *Str += (char)32;
  } while (*++Str);
}



/**** Translates a string into a QCHAR ****/

void Str2Qchar(ES_QCHAR *Res, register char *Str)
{
  register char      *Dest = (*Res).C;
  register ES_UWORD  k;

  (*Res).L = 0;
  for(k = 0;(*Str) && (k < 4); ++k) {
   *Dest = *Str;
   ++Str;
   ++Dest;
  }
}


/**** Skip file lines ****/

ES_BOOL SkipLines(FILE *FH, char *Buf, ES_ULONG Lines)
{
  while(Lines > 0) {
    if (!fgets(Buf, 255, FH)) {
      PrintDosErr();
      return FALSE;
    }
   --Lines;
  } /* End of while */

  return TRUE;
}


/**** Change a string to uppercase ****/

void Upper(register char *Str)
{
  do *Str = (char)toupper(*Str); while(*++Str);
}


/***********************************
**** Windows specific functions ****
***********************************/


/**** Load the DLL function addresses ****/

#ifdef WIN32
ES_BOOL GetProcAddresses(HINSTANCE *hLibrary, LPCSTR lpszLibrary, INT nCount, ... )
{
  va_list       va;

  if (*hLibrary == NULL) {
    va_start(va, nCount);
    if ((*hLibrary = DXWCPU_LoadLibrary(&EsCpu, lpszLibrary)) != NULL) {
      FARPROC * lpfProcFunction;
      LPSTR     lpszFuncName;
      INT       nIdxCount        = 0;
      while(nIdxCount < nCount) {
        lpfProcFunction = va_arg(va, FARPROC*);
        lpszFuncName    = va_arg(va, LPSTR);
        if ((*lpfProcFunction = GetProcAddress(*hLibrary, lpszFuncName)) == NULL) {
          *lpfProcFunction = NULL;
          FreeLibrary(*hLibrary);
          *hLibrary = NULL;
          CatErr(MSG_ERR_WIN_CANTGETADDR, lpszFuncName, lpszLibrary);
          return FALSE;
        }
        nIdxCount++;
      } /* End of while */
    } else {
      va_end(va);
      CatErr(MSG_ERR_WIN_CANTLOADLIB, lpszLibrary);
      return FALSE;
    }
    va_end(va);
  }

  return TRUE;
}
#endif

